var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
var kiteclib_3 = require('kiteclib');
var kiteclib_4 = require('kiteclib');
var NethomeCoreResource_1 = require('../../NethomeCoreResource');
var Geometry_1 = require('./Geometry');
//module nethome.geom.primitive
/**
 * @author kawae**/
var GPoint2Df = (function (_super) {
    __extends(GPoint2Df, _super);
    /**
     * コンストラクタ
     * @param x
     * @param y
    **/
    function GPoint2Df(x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        _super.call(this, GPoint2Df.GEOMNAME);
        this.x = x;
        this.y = y;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigure#getType()
    **/
    GPoint2Df.prototype.getType = function () {
        return kiteclib_3.K2DFigureType.POINT;
    };
    /**
     * 座標地のセット**/
    GPoint2Df.prototype.setXY = function (x, y) {
        this.x = x;
        this.y = y;
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#getX()
    **/
    GPoint2Df.prototype.getX = function () {
        return this.x;
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#getY()
    **/
    GPoint2Df.prototype.getY = function () {
        return this.y;
    };
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#setX(double)
    **/
    GPoint2Df.prototype.setX = function (x) {
        this.x = x;
    };
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#setY(double)
    **/
    GPoint2Df.prototype.setY = function (y) {
        this.y = y;
    };
    /**
     * 座標地のセット
     * @param p
    **/
    GPoint2Df.prototype.setPoint = function (p) {
        this.setXY(p.getX(), p.getY());
    };
    /**
     * 最大・最小値の更新**/
    GPoint2Df.prototype.updateMinMax = function (area) {
        area.updateMinMax(this.x, this.y);
    };
    /**
     * コピーインスタンスの取得**/
    GPoint2Df.prototype.copy = function () {
        return this.copyTo(new GPoint2Df());
    };
    /**
     * コピーインスタンスの取得**/
    GPoint2Df.prototype.copyTo = function (g) {
        if (g == null || !(g instanceof GPoint2Df))
            return null;
        var p = (g);
        _super.prototype.copyTo.call(this, p);
        p.setPoint(this);
        p.area.maximize();
        p.updateMinMax(p.area);
        return p;
    };
    GPoint2Df.prototype.getNearNode = function (x, y) {
        return this;
    };
    GPoint2Df.prototype.getDistanceToPoint = function (x, y) {
        return kiteclib_4.MathUtil.getLength2D(x, y, this.x, this.y);
    };
    GPoint2Df.prototype.offset = function (dx, dy) {
        this.x += dx;
        this.y += dy;
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GPoint2Df.prototype.rotate = function (xc, yc, angl) {
        var _tmpf = new Array(2);
        kiteclib_4.MathUtil.rotation2D(xc, yc, angl, this.x, this.y, _tmpf);
        _tmpf[0] = (Math.round(_tmpf[0] * 1000) / 1000);
        _tmpf[1] = (Math.round(_tmpf[1] * 1000) / 1000);
        this.x = this.area.minX = this.area.maxX = _tmpf[0];
        this.y = this.area.minY = this.area.maxY = _tmpf[1];
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GPoint2Df.prototype.drawHighLight = function (d, c, outline) {
        GPoint2Df.drawHighLight(d, c, this.x, this.y);
    };
    GPoint2Df.drawHighLight = function (d, c, x, y) {
        d.setColor(c);
        d.drawMark(x, y, NethomeCoreResource_1.NethomeCoreResource.MARKER_SIZE, kiteclib_1.IRichGraphicsConst.MARK_REC_FILL);
        d.setColor(kiteclib_2.KColor.BLACK);
        d.drawMark(x, y, NethomeCoreResource_1.NethomeCoreResource.MARKER_SIZE, kiteclib_1.IRichGraphicsConst.MARK_REC);
    };
    /**
     * 幾何データの保存
     * @param savenode		保存対象ノード
     * @author kawae
     * @since 2003/01/01
    **/
    GPoint2Df.prototype.save = function (savenode) {
        if (savenode == null)
            return;
        _super.prototype.save.call(this, savenode);
        savenode.addNode("x", this.x);
        savenode.addNode("y", this.y);
    };
    GPoint2Df.prototype.flipx = function (x, ofsx) {
        this.x = x - (this.x - x) + ofsx;
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GPoint2Df.prototype.flipy = function (y, ofsy) {
        this.y = y - (this.y - y) + ofsy;
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GPoint2Df.prototype.rot = function (x, y, ofsx, ofsy) {
        var tmpx;
        var tmpy;
        tmpx = this.x;
        tmpy = this.y;
        this.x = x - (tmpy - y) + ofsy;
        this.y = y + (tmpx - x);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    /**
     * 描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    GPoint2Df.prototype.drawGeom = function (d) {
    };
    GPoint2Df.GEOMNAME = "POINT";
    return GPoint2Df;
})(Geometry_1.Geometry);
exports.GPoint2Df = GPoint2Df;
//# sourceMappingURL=GPoint2Df.js.map