var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
var kiteclib_3 = require('kiteclib');
var Geometry_1 = require('./Geometry');
var GPoint2Df_1 = require('./GPoint2Df');
//module nethome.geom.primitive
var GLine = (function (_super) {
    __extends(GLine, _super);
    function GLine(x1OrP1, y1OrP2, x2OrLtype, y2) {
        _super.call(this, GLine.GEOMNAME);
        var p1;
        var p2;
        var ltype;
        if (x1OrP1 === undefined) {
            p1 = new GPoint2Df_1.GPoint2Df();
            p2 = new GPoint2Df_1.GPoint2Df();
            ltype = null;
        }
        else {
            if (typeof x1OrP1 === "number") {
                p1 = new GPoint2Df_1.GPoint2Df(x1OrP1, y1OrP2);
                p2 = new GPoint2Df_1.GPoint2Df(x2OrLtype, y2);
                ltype = null;
            }
            else {
                p1 = x1OrP1;
                p2 = y1OrP2;
                ltype = x2OrLtype;
            }
        }
        this.mGeomColor = kiteclib_1.KColor.BLACK;
        this.pA = p1;
        this.pB = p2;
        this.lineType = ltype;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    GLine.prototype.getSnapNode = function (x1, y1, gx, gy, min, res, eps, limit) {
        return false;
    };
    GLine.prototype.getSnapLoop = function (v) {
        v.push(this.pA);
        v.push(this.pB);
    };
    GLine.prototype.getCenter = function (p) {
        p.x = (this.pA.x + this.pB.x) / 2;
        p.y = (this.pA.y + this.pB.y) / 2;
    };
    GLine.prototype.getNearNodeOnLine = function (p1, p2, eps) {
        var len;
        var min = Number.MAX_VALUE;
        var res = null;
        for (var k = 0; k < 2; k++) {
            var pa = k == 0 ? this.pA : this.pB;
            if ((len = kiteclib_2.MathUtil.getLengthLimitLineToPoint2D(pa.x, pa.y, p1.x, p1.y, p2.x, p2.y)) >= 0 && len < eps && len < min) {
                min = len;
                res = pa;
            }
        }
        return res;
    };
    GLine.prototype.getNearLine = function (x, y, eps, pts) {
        var len;
        var pa = this.pA;
        var pb = this.pB;
        if ((len = kiteclib_2.MathUtil.getLengthLimitLineToPoint2D(x, y, pa.x, pa.y, pb.x, pb.y)) >= 0 && len < eps) {
            pts[0] = pa;
            pts[1] = pb;
            return true;
        }
        return false;
    };
    GLine.prototype.getRotbasePoint = function () {
        return this.pA;
    };
    GLine.prototype.updateMinMax = function (area) {
        area.updateMinMax(this.pA.x, this.pA.y);
        area.updateMinMax(this.pB.x, this.pB.y);
    };
    GLine.prototype.copy = function () {
        return this.copyTo(new GLine());
    };
    GLine.prototype.copyTo = function (g) {
        if (g == null || !(g instanceof GLine))
            return null;
        var gl = g;
        _super.prototype.copyTo.call(this, gl);
        gl.pA.setPoint(this.pA);
        gl.pB.setPoint(this.pB);
        gl.area.maximize();
        gl.updateMinMax(gl.area);
        return gl;
    };
    /**
     * 一番近くの構成点を探す
     * @param x
     * @param y
     * @return
    **/
    GLine.prototype.getNearNode = function (x, y) {
        var min = Number.MAX_VALUE;
        var gp = null;
        var tmp;
        if ((tmp = kiteclib_2.MathUtil.getLength2D(x, y, this.pA.x, this.pA.y)) < min) {
            gp = this.pA;
            min = tmp;
        }
        if ((tmp = kiteclib_2.MathUtil.getLength2D(x, y, this.pB.x, this.pB.y)) < min)
            gp = this.pB;
        return gp;
    };
    GLine.prototype.getDistanceToPoint = function (x, y) {
        var len;
        len = kiteclib_2.MathUtil.getLengthLimitLineToPoint2D(x, y, this.pA.x, this.pA.y, this.pB.x, this.pB.y);
        if (len < 0)
            return -1;
        return len;
    };
    GLine.prototype.offset = function (x, y) {
        this.pA.x += x;
        this.pA.y += y;
        this.pB.x += x;
        this.pB.y += y;
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GLine.prototype.rotate = function (xc, yc, angl) {
        this.pA.rotate(xc, yc, angl);
        this.pB.rotate(xc, yc, angl);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GLine.prototype.isInner = function (minx, miny, maxx, maxy) {
        var p1 = false;
        var p2 = false;
        if (this.pA.x > minx && this.pA.x < maxx && this.pA.y > miny && this.pA.y < maxy)
            p1 = true;
        if (this.pB.x > minx && this.pB.x < maxx && this.pB.y > miny && this.pB.y < maxy)
            p2 = true;
        return p1 && p2;
    };
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    return ToolPolygon.isInnerPolygon(v, this.pA.x, this.pA.y) && ToolPolygon.isInnerPolygon(v, this.pB.x, this.pB.y);
    //}
    /**
     * 幾何データの保存
     * @param savenode		保存対象ノード
     * @author kawae
     * @since 2003/01/01
    **/
    GLine.prototype.save = function (savenode) {
        if (savenode == null)
            return;
        _super.prototype.save.call(this, savenode);
        savenode.addNode("x1", this.pA.x);
        savenode.addNode("y1", this.pA.y);
        savenode.addNode("x2", this.pB.x);
        savenode.addNode("y2", this.pB.y);
    };
    /**
     * 線種の設定
     * @param ltype　線種
    **/
    GLine.prototype.setLType = function (ltype) {
        this.lineType = ltype;
    };
    GLine.prototype.getLType = function () {
        return this.lineType;
    };
    /**
     * 描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, this.mGeomColor, null);
    //}
    /**
     * ハイライト描画
     * @param d	描画インターフェース
     * @param c		幾何描画色
     * @author kawae
     * @since 2003/01/01
    **/
    GLine.prototype.drawHighLight = function (d, c, outline) {
        if (outline) {
            this.drawAbstDevice(d, c, c, null);
        }
        this.pA.drawHighLight(d, c, false);
        this.pB.drawHighLight(d, c, false);
    };
    GLine.prototype.drawGeom = function (d, fore, back) {
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, null);
    };
    GLine.prototype.drawAlias = function (d, fore, back, la) {
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, la);
    };
    /**
     * 最終描画
     * @param d	描画インターフェース
     * @param fore	前景色
     * @param back	背景色
     * @param la	描画座標
     * @author kawae
     * @since 2004/09/24
    **/
    GLine.prototype.drawAbstDevice = function (d, fore, back, la) {
        var x1;
        var y1;
        var x2;
        var y2;
        if (la != null) {
            x1 = la.getGlobalX(this.pA.x, this.pA.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            y1 = la.getGlobalY(this.pA.x, this.pA.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            x2 = la.getGlobalX(this.pB.x, this.pB.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            y2 = la.getGlobalY(this.pB.x, this.pB.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
        }
        else {
            x1 = this.pA.x;
            y1 = this.pA.y;
            x2 = this.pB.x;
            y2 = this.pB.y;
        }
        d.setColor(fore);
        d.drawLine(x1, y1, x2, y2, null);
    };
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
    **/
    GLine.prototype.getNearControlPoint = function (x, y) {
        var min = Number.POSITIVE_INFINITY;
        var pt = null;
        for (var i = 0; i < 2; i++) {
            var p = i == 0 ? this.pA : this.pB;
            var len = p.getDistanceToPoint(x, y);
            if (len < min) {
                min = len;
                pt = p;
            }
        }
        return pt;
    };
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
    **/
    GLine.prototype.moveControlPoint = function (cp, x, y) {
        if (cp == this.pA) {
            this.pA.x = x;
            this.pA.y = y;
        }
        else if (cp == this.pB) {
            this.pB.x = x;
            this.pB.y = y;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GLine.prototype.flipx = function (x, ofsx) {
        this.pA.flipx(x, ofsx);
        this.pB.flipx(x, ofsx);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GLine.prototype.flipy = function (y, ofsy) {
        this.pA.flipy(y, ofsy);
        this.pB.flipy(y, ofsy);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GLine.prototype.rot = function (x, y, ofsx, ofsy) {
        this.pA.rot(x, y, ofsx, ofsy);
        this.pB.rot(x, y, ofsx, ofsy);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigure#getType()
    **/
    GLine.prototype.getType = function () {
        return kiteclib_3.K2DFigureType.LINE;
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getX1()
    **/
    GLine.prototype.getX1 = function () {
        return this.pA.x;
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getX2()
    **/
    GLine.prototype.getX2 = function () {
        return this.pB.x;
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getY1()
    **/
    GLine.prototype.getY1 = function () {
        return this.pA.y;
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getY2()
    **/
    GLine.prototype.getY2 = function () {
        return this.pB.y;
    };
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX1(double)
    **/
    GLine.prototype.setX1 = function (x) {
        this.pA.setX(x);
    };
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX2(double)
    **/
    GLine.prototype.setX2 = function (x) {
        this.pB.setX(x);
    };
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY1(double)
    **/
    GLine.prototype.setY1 = function (y) {
        this.pA.setY(y);
    };
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY2(double)
    **/
    GLine.prototype.setY2 = function (y) {
        this.pB.setY(y);
    };
    GLine.GEOMNAME = "LINE";
    return GLine;
})(Geometry_1.Geometry);
exports.GLine = GLine;
//# sourceMappingURL=GLine.js.map