import { KArea } from 'kiteclib';
import { KColor } from 'kiteclib';
import { IRichGraphics } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { K2DPathFigureLine } from 'kiteclib';
import { LocalAxis2Df } from '../LocalAxis2Df';
import { Ltype } from '../Ltype';
import { Geometry } from './Geometry';
import { GPoint2Df } from './GPoint2Df';
import { Primitive } from './Primitive';
export declare class GLine extends Geometry implements K2DPathFigureLine, Primitive {
    static GEOMNAME: string;
    /**
     * 端点1 **/
    pA: GPoint2Df;
    /**
     * 端点2 **/
    pB: GPoint2Df;
    /**
     * コンストラクタ**/
    constructor();
    /**
     * コンストラクタ**/
    constructor(p1: GPoint2Df, p2: GPoint2Df);
    /**
     * コンストラクタ**/
    constructor(p1: GPoint2Df, p2: GPoint2Df, ltype: Ltype);
    /**
     * コンストラクタ
     * @param x1
     * @param y1
     * @param x2
     * @param y2
    **/
    constructor(x1: number, y1: number, x2: number, y2: number);
    getSnapNode(x1: number, y1: number, gx: number, gy: number, min: number[], res: number[], eps: number, limit: number): boolean;
    getSnapLoop(v: GPoint2Df[]): void;
    getCenter(p: GPoint2Df): void;
    getNearNodeOnLine(p1: GPoint2Df, p2: GPoint2Df, eps: number): GPoint2Df;
    getNearLine(x: number, y: number, eps: number, pts: GPoint2Df[]): boolean;
    getRotbasePoint(): GPoint2Df;
    updateMinMax(area: KArea): void;
    copy(): Geometry;
    copyTo(g: Geometry): Geometry;
    /**
     * 一番近くの構成点を探す
     * @param x
     * @param y
     * @return
    **/
    getNearNode(x: number, y: number): GPoint2Df;
    getDistanceToPoint(x: number, y: number): number;
    offset(x: number, y: number): void;
    rotate(xc: number, yc: number, angl: number): void;
    isInner(minx: number, miny: number, maxx: number, maxy: number): boolean;
    /**
     * 幾何データの保存
     * @param savenode		保存対象ノード
     * @author kawae
     * @since 2003/01/01
    **/
    save(savenode: ObjectFolder): void;
    /**
     * 線種の設定
     * @param ltype　線種
    **/
    setLType(ltype: Ltype): void;
    getLType(): Ltype;
    /**
     * 描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    /**
     * ハイライト描画
     * @param d	描画インターフェース
     * @param c		幾何描画色
     * @author kawae
     * @since 2003/01/01
    **/
    drawHighLight(d: IRichGraphics, c: KColor, outline: boolean): void;
    drawGeom(d: IRichGraphics, fore: KColor, back: KColor): void;
    drawAlias(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    /**
     * 最終描画
     * @param d	描画インターフェース
     * @param fore	前景色
     * @param back	背景色
     * @param la	描画座標
     * @author kawae
     * @since 2004/09/24
    **/
    drawAbstDevice(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
    **/
    getNearControlPoint(x: number, y: number): Object;
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
    **/
    moveControlPoint(cp: Object, x: number, y: number): void;
    flipx(x: number, ofsx: number): void;
    flipy(y: number, ofsy: number): void;
    rot(x: number, y: number, ofsx: number, ofsy: number): void;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigure#getType()
    **/
    getType(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getX1()
    **/
    getX1(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getX2()
    **/
    getX2(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getY1()
    **/
    getY1(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getY2()
    **/
    getY2(): number;
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX1(double)
    **/
    setX1(x: number): void;
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX2(double)
    **/
    setX2(x: number): void;
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY1(double)
    **/
    setY1(y: number): void;
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY2(double)
    **/
    setY2(y: number): void;
}
