import { KColor } from 'kiteclib';
import { KArea } from 'kiteclib';
import { IRichGraphics } from 'kiteclib';
import { K2DPathFigureArc } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { Geometry } from './Geometry';
import { Primitive } from './Primitive';
import { IFillableGeometry } from './IFillableGeometry';
import { GPoint2Df } from './GPoint2Df';
import { LocalAxis2Df } from '../LocalAxis2Df';
export declare class GCircle extends Geometry implements K2DPathFigureArc, Primitive, IFillableGeometry {
    static GEOMNAME: string;
    /**
     * 中心座標
     **/
    mCp: GPoint2Df;
    /**
     * 半径
     **/
    _r: number;
    /**
     * 開始角度
     **/
    _start: number;
    /**
     * 終了角度
     **/
    _end: number;
    /**
     * 最大・最小点リスト
     **/
    _maxPts: GPoint2Df[];
    _tmpP: GPoint2Df;
    /**
     * 塗潰しモード
     **/
    mFill: boolean;
    /**
     * 塗潰し色
     **/
    mFillColor: KColor;
    /**
     * コンストラクタ
    **/
    /**
     * コンストラクタ**/
    constructor(cx?: number, cy?: number, r?: number, start?: number, end?: number);
    getSnapNode(x1: number, y1: number, gx: number, gy: number, min: number[], res: number[], eps: number, limit: number): boolean;
    getCenter(p: GPoint2Df): void;
    getSnapLoop(v: GPoint2Df[]): void;
    /**
     * TODO:実装**/
    getNearNodeOnLine(p1: GPoint2Df, p2: GPoint2Df, eps: number): GPoint2Df;
    getNearLine(x: number, y: number, eps: number, pts: GPoint2Df[]): boolean;
    getRotbasePoint(): GPoint2Df;
    static isParallel(g1: Geometry, g2: Geometry): boolean;
    static marge(g1: Geometry, g2: Geometry): Geometry;
    getStart(): number;
    setStart(f: number): void;
    getEnd(): number;
    setEnd(f: number): void;
    getR(): number;
    setR(r: number): void;
    setX(f: number): void;
    setY(f: number): void;
    getX(): number;
    getY(): number;
    copy(): Geometry;
    copyTo(g: Geometry): Geometry;
    updateMinMax(area: KArea): void;
    updateMaxPoints(): void;
    getNearNode(x: number, y: number): GPoint2Df;
    getDistanceToPoint(x: number, y: number): number;
    offset(x: number, y: number): void;
    rotate(xc: number, yc: number, angl: number): void;
    isInner(minx: number, miny: number, maxx: number, maxy: number): boolean;
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode: ObjectFolder): void;
    drawGeom(d: IRichGraphics, fore: KColor, back: KColor): void;
    drawAlias(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    drawAbstDevice(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    drawHighLight(d: IRichGraphics, c: KColor, outline: boolean): void;
    getLocalMinMax(area: KArea): void;
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
    **/
    getNearControlPoint(x: number, y: number): Object;
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
    **/
    moveControlPoint(cp: Object, x: number, y: number): void;
    flipx(x: number, ofsx: number): void;
    flipy(y: number, ofsy: number): void;
    rot(x: number, y: number, ofsx: number, ofsy: number): void;
    setFillMode(fill: boolean): void;
    isFillMode(): boolean;
    /**
     * @return Returns the mFillColor.**/
    getFillColor(): KColor;
    /**
     * @param fillColor The mFillColor to set.**/
    setFillColor(fillColor: KColor): void;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#getCX()
    **/
    getCX(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#getCY()
    **/
    getCY(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#getRadius()
    **/
    getRadius(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#isCw()
    **/
    isCw(): boolean;
    /**
     * @param cw
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setCw(boolean)
    **/
    setCw(cw: boolean): void;
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setCX(double)
    **/
    setCX(x: number): void;
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setCY(double)
    **/
    setCY(y: number): void;
    /**
     * @param radius
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setRadius(double)
    **/
    setRadius(radius: number): void;
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getX1()
    **/
    getX1(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getX2()
    **/
    getX2(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getY1()
    **/
    getY1(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getY2()
    **/
    getY2(): number;
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX1(double)
    **/
    setX1(x: number): void;
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX2(double)
    **/
    setX2(x: number): void;
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY1(double)
    **/
    setY1(y: number): void;
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY2(double)
    **/
    setY2(y: number): void;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigure#getType()
    **/
    getType(): number;
}
