var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
var kiteclib_3 = require('kiteclib');
//module nethome.geom
/**
 * @author kawae**/
var WorkSheet = (function () {
    /**
     * Constructor for Shikichi.**/
    function WorkSheet() {
        /**
         * グリッド分割数**/
        this.mGridDiv = 1;
        this.mArea = new kiteclib_3.KArea();
        this.mAreaPolygon = [];
        this.mModule = 0;
        this.mGridCenterX = 0;
        this.mGridCenterY = 0;
        this.mExtraGridX = [];
        this.mExtraGridY = [];
    }
    /**
     * コピーインスタンスの作成
     * @return
     * @author kawae
     * @since 2004/10/02
    **/
    WorkSheet.prototype.getCopy = function () {
        var ws = new WorkSheet();
        ws.setName(this.getName());
        ws.setArea(this.mArea.minX, this.mArea.minY, this.mArea.maxX, this.mArea.maxY);
        ws.mGridDiv = this.mGridDiv;
        ws.mModule = this.mModule;
        ws.mGridCenterX = this.mGridCenterX;
        ws.mGridCenterY = this.mGridCenterY;
        return ws;
    };
    /**
     * ワークシート名の設定
     * @param s
     * @author kawae
     * @since 2004/10/02
    **/
    WorkSheet.prototype.setName = function (s) {
        this.mName = s;
    };
    /**
     * ワークシート名の取得
     * @return
     * @author kawae
     * @since 2004/10/02
    **/
    WorkSheet.prototype.getName = function () {
        return this.mName;
    };
    /**
     * 領域の設定
     * @param minx
     * @param miny
     * @param maxx
     * @param maxy
     * @author kawae
     * @since 2004/10/02
    **/
    WorkSheet.prototype.setArea = function (minx, miny, maxx, maxy) {
        this.mArea.maximize();
        this.mArea.updateMinMax(minx, miny);
        this.mArea.updateMinMax(maxx, maxy);
        this.mAreaPolygon.length = 0;
        this.mAreaPolygon.push(new kiteclib_1.KPoint2d(minx, miny));
        this.mAreaPolygon.push(new kiteclib_1.KPoint2d(maxx, miny));
        this.mAreaPolygon.push(new kiteclib_1.KPoint2d(maxx, maxy));
        this.mAreaPolygon.push(new kiteclib_1.KPoint2d(minx, maxy));
    };
    /**
     * 領域の取得
     * @return
     * @author kawae
     * @since 2004/10/02
    **/
    WorkSheet.prototype.getArea = function () {
        return this.mArea;
    };
    WorkSheet.prototype.updateArea = function () {
        this.mArea.maximize();
        for (var i = 0; i < this.mAreaPolygon.length; i++) {
            var p = this.mAreaPolygon[i];
            this.mArea.updateMinMax(p.x, p.y);
        }
    };
    WorkSheet.prototype.getAreaPolygon = function () {
        return this.mAreaPolygon.slice();
    };
    /**
     * モジュールの取得
     * @return
    **/
    WorkSheet.prototype.getModule = function () {
        return this.mModule;
    };
    /**
     * モジュールの設定
     * @param f
    **/
    WorkSheet.prototype.setModule = function (f) {
        if (f < 0)
            throw new Error("negative module");
        this.mModule = f;
    };
    /**
     * グリッドのベースモジュールに対する分割数の設定
     * @param i
    **/
    WorkSheet.prototype.setGridDivide = function (i) {
        if (i <= 0)
            throw new Error("negative grid division");
        this.mGridDiv = i;
    };
    WorkSheet.prototype.getGridDivide = function () {
        return this.mGridDiv;
    };
    WorkSheet.prototype.getCurrentGrid = function () {
        return this.mModule / this.mGridDiv;
    };
    WorkSheet.prototype.setGridCenter = function (x, y) {
        this.mGridCenterX = x;
        this.mGridCenterY = y;
    };
    WorkSheet.prototype.getGridCenterX = function () {
        return this.mGridCenterX;
    };
    WorkSheet.prototype.getGridCenterY = function () {
        return this.mGridCenterY;
    };
    /**
     * 最も近いXグリッドを探す
     * @param x
     * @param extra 追加グリッドも含めて探すかのフラグ。
     * @return
    **/
    WorkSheet.prototype.getNearGridX = function (x, extra) {
        return this.getNearGrid(x, extra, this.getCurrentGrid(), this.getGridCenterX(), this.mExtraGridX);
    };
    /**
     * 最も近いYグリッドを探す
     * @param y
     * @param extra 追加グリッドも含めて探すかのフラグ。
     * @return
    **/
    WorkSheet.prototype.getNearGridY = function (y, extra) {
        return this.getNearGrid(y, extra, this.getCurrentGrid(), this.getGridCenterY(), this.mExtraGridY);
    };
    WorkSheet.prototype.getNearGrid = function (v, extra, currentGrid, gridCenter, extraGrid) {
        if (currentGrid == 0)
            return v;
        var near = Number.MAX_VALUE;
        var step = v <= gridCenter ? -1 : 1;
        var c = Math.floor(((v - gridCenter) / currentGrid) * step);
        while (true) {
            var len = Math.abs(v - (gridCenter + currentGrid * c * step));
            if (near > len)
                near = len;
            else
                break;
            c++;
        }
        var gridcandidate = step * (c - 1) * currentGrid + gridCenter;
        if (extra && extraGrid != null) {
            for (var i = 0; i < extraGrid.length; i++) {
                var f = extraGrid[i];
                var len = Math.abs(v - f);
                if (len < near) {
                    gridcandidate = f;
                    near = len;
                }
            }
        }
        return gridcandidate;
    };
    /**
     * デフォルトのスナップX
     * @param x
     * @return double
    **/
    WorkSheet.prototype.getDefNearGridX = function (x) {
        var near = Number.MAX_VALUE;
        var div = this.getModule() / WorkSheet.DEF_NEAR_GRID_DIVIDE;
        var c = ((x - x % div) / div) | 0;
        var res = 0;
        for (var i = c - 1; i <= c + 1; i++) {
            if (Math.abs(div * i - x) < near) {
                near = Math.abs(div * i - x);
                res = i;
            }
        }
        return res * div;
    };
    WorkSheet.prototype.getDefNearGridY = function (y) {
        var near = Number.MAX_VALUE;
        var div = this.getModule() / WorkSheet.DEF_NEAR_GRID_DIVIDE;
        var c = ((y - y % div) / div) | 0;
        var res = 0;
        for (var i = c - 1; i <= c + 1; i++) {
            if (Math.abs(div * i - y) < near) {
                near = Math.abs(div * i - y);
                res = i;
            }
        }
        return res * div;
    };
    WorkSheet.prototype.isOnGridX = function (x) {
        var xx = this.getNearGridX(x, true);
        if (Math.abs(xx - x) < kiteclib_2.MathUtil.EPS)
            return true;
        return false;
    };
    WorkSheet.prototype.isOnGridY = function (y) {
        var yy = this.getNearGridY(y, true);
        if (Math.abs(yy - y) < kiteclib_2.MathUtil.EPS)
            return true;
        return false;
    };
    WorkSheet.prototype.isOnBaseGridX = function (x) {
        var c = Math.abs(x % this.mModule);
        if (c < kiteclib_2.MathUtil.EPS || Math.abs(c - this.mModule) < kiteclib_2.MathUtil.EPS) {
            return true;
        }
        return false;
    };
    WorkSheet.prototype.isOnBaseGridY = function (y) {
        var c = Math.abs(y % this.mModule);
        if (c < kiteclib_2.MathUtil.EPS || Math.abs(c - this.mModule) < kiteclib_2.MathUtil.EPS) {
            return true;
        }
        return false;
    };
    WorkSheet.prototype.getNearGridX2 = function (x, dir) {
        if (this.getCurrentGrid() == 0)
            return x;
        var ss = Math.floor(((x - this.getGridCenterX()) / this.getCurrentGrid()));
        var candx = this.getGridCenterX() + ss * this.getCurrentGrid();
        var candx1;
        var candx2;
        if (candx < x) {
            candx1 = candx;
            candx2 = this.getGridCenterX() + (ss + 1) * this.getCurrentGrid();
        }
        else {
            candx1 = this.getGridCenterX() + (ss - 1) * this.getCurrentGrid();
            candx2 = candx;
        }
        if (Math.abs(candx1 - x) < this.getCurrentGrid() / WorkSheet.NEAR_GRID2_THRESHOLD_DIVIDE) {
            return candx1;
        }
        if (Math.abs(candx2 - x) < this.getCurrentGrid() / WorkSheet.NEAR_GRID2_THRESHOLD_DIVIDE) {
            return candx2;
        }
        if (this.mExtraGridX != null) {
            for (var i = 0; i < this.mExtraGridX.length; i++) {
                var f = this.mExtraGridX[i];
                if (Math.abs(f - x) < this.getCurrentGrid() / WorkSheet.NEAR_GRID2_THRESHOLD_DIVIDE)
                    return f;
                if (candx1 < f && x > f)
                    candx1 = f;
                if (x < f && candx2 > f)
                    candx2 = f;
            }
        }
        if (dir)
            return candx2;
        return candx1;
    };
    WorkSheet.prototype.getNearGridY2 = function (y, dir) {
        if (this.getCurrentGrid() == 0)
            return y;
        var ss = Math.floor(((y - this.getGridCenterY()) / this.getCurrentGrid()));
        var candy = this.getGridCenterY() + ss * this.getCurrentGrid();
        var candy1;
        var candy2;
        if (candy < y) {
            candy1 = candy;
            candy2 = this.getGridCenterY() + (ss + 1) * this.getCurrentGrid();
        }
        else {
            candy1 = this.getGridCenterY() + (ss - 1) * this.getCurrentGrid();
            candy2 = candy;
        }
        if (Math.abs(candy1 - y) < this.getCurrentGrid() / WorkSheet.NEAR_GRID2_THRESHOLD_DIVIDE) {
            return candy1;
        }
        if (Math.abs(candy2 - y) < this.getCurrentGrid() / WorkSheet.NEAR_GRID2_THRESHOLD_DIVIDE) {
            return candy2;
        }
        if (this.mExtraGridY != null) {
            for (var i = 0; i < this.mExtraGridY.length; i++) {
                var f = this.mExtraGridY[i];
                if (Math.abs(f - y) < this.getCurrentGrid() / WorkSheet.NEAR_GRID2_THRESHOLD_DIVIDE)
                    return f;
                if (candy1 < f && y > f)
                    candy1 = f;
                if (y < f && candy2 > f)
                    candy2 = f;
            }
        }
        if (dir) {
            return candy2;
        }
        return candy1;
    };
    /**
     * 追加グリッドを抜いたグリッドの取得
     * @param x
     * @param bx
     * @param module
     * @return
    **/
    WorkSheet.prototype.getNearNotExtraGrid = function (x, bx, module) {
        var near = Number.MAX_VALUE;
        var step = x <= bx ? -1 : 1;
        var c = Math.floor(((x - bx) / module) * step);
        while (true) {
            var len = Math.abs(x - (bx + module * c * step));
            if (near > len)
                near = len;
            else
                break;
            c++;
        }
        return step * (c - 1);
    };
    WorkSheet.prototype.getExtraGridX = function () {
        return this.mExtraGridX;
    };
    WorkSheet.prototype.getExtraGridY = function () {
        return this.mExtraGridY;
    };
    WorkSheet.prototype.addExtraGridX = function (x) {
        if (Math.abs(this.getNearGridX(x, true) - x) < kiteclib_2.MathUtil.EPS)
            return false;
        if (this.mExtraGridX == null)
            this.mExtraGridX = [];
        for (var i = 0; i < this.mExtraGridX.length; i++) {
            var f = this.mExtraGridX[i];
            if (Math.abs(f - x) < kiteclib_2.MathUtil.EPS)
                return false;
        }
        this.mExtraGridX.push(x);
        return true;
    };
    WorkSheet.prototype.addExtraGridY = function (y) {
        if (Math.abs(this.getNearGridY(y, true) - y) < kiteclib_2.MathUtil.EPS)
            return false;
        if (this.mExtraGridY == null)
            this.mExtraGridY = [];
        for (var i = 0; i < this.mExtraGridY.length; i++) {
            var f = this.mExtraGridY[i];
            if (Math.abs(f - y) < kiteclib_2.MathUtil.EPS)
                return false;
        }
        this.mExtraGridY.push(y);
        return true;
    };
    WorkSheet.NEAR_GRID2_THRESHOLD_DIVIDE = 30;
    WorkSheet.DEF_NEAR_GRID_DIVIDE = 50;
    return WorkSheet;
})();
exports.WorkSheet = WorkSheet;
//# sourceMappingURL=WorkSheet.js.map