import { KPoint2d } from 'kiteclib';
import { KArea } from 'kiteclib';
/**
 * @author kawae**/
export declare class WorkSheet {
    static NEAR_GRID2_THRESHOLD_DIVIDE: number;
    static DEF_NEAR_GRID_DIVIDE: number;
    /**
     * ワークシート名 **/
    private mName;
    /**
     * 基本モジュール **/
    private mModule;
    /**
     * 領域 **/
    private mArea;
    /**
     * グリッド分割数**/
    private mGridDiv;
    /**
     * グリッドを通過する点**/
    private mGridCenterX;
    private mGridCenterY;
    /**
     * 追加グリッド**/
    private mExtraGridX;
    private mExtraGridY;
    /**
     * エリアポリゴン **/
    private mAreaPolygon;
    /**
     * Constructor for Shikichi.**/
    constructor();
    /**
     * コピーインスタンスの作成
     * @return
     * @author kawae
     * @since 2004/10/02
    **/
    getCopy(): WorkSheet;
    /**
     * ワークシート名の設定
     * @param s
     * @author kawae
     * @since 2004/10/02
    **/
    setName(s: string): void;
    /**
     * ワークシート名の取得
     * @return
     * @author kawae
     * @since 2004/10/02
    **/
    getName(): string;
    /**
     * 領域の設定
     * @param minx
     * @param miny
     * @param maxx
     * @param maxy
     * @author kawae
     * @since 2004/10/02
    **/
    setArea(minx: number, miny: number, maxx: number, maxy: number): void;
    /**
     * 領域の取得
     * @return
     * @author kawae
     * @since 2004/10/02
    **/
    getArea(): KArea;
    updateArea(): void;
    getAreaPolygon(): Array<KPoint2d>;
    /**
     * モジュールの取得
     * @return
    **/
    getModule(): number;
    /**
     * モジュールの設定
     * @param f
    **/
    setModule(f: number): void;
    /**
     * グリッドのベースモジュールに対する分割数の設定
     * @param i
    **/
    setGridDivide(i: number): void;
    getGridDivide(): number;
    getCurrentGrid(): number;
    setGridCenter(x: number, y: number): void;
    getGridCenterX(): number;
    getGridCenterY(): number;
    /**
     * 最も近いXグリッドを探す
     * @param x
     * @param extra 追加グリッドも含めて探すかのフラグ。
     * @return
    **/
    getNearGridX(x: number, extra: boolean): number;
    /**
     * 最も近いYグリッドを探す
     * @param y
     * @param extra 追加グリッドも含めて探すかのフラグ。
     * @return
    **/
    getNearGridY(y: number, extra: boolean): number;
    private getNearGrid(v, extra, currentGrid, gridCenter, extraGrid);
    /**
     * デフォルトのスナップX
     * @param x
     * @return double
    **/
    getDefNearGridX(x: number): number;
    getDefNearGridY(y: number): number;
    isOnGridX(x: number): boolean;
    isOnGridY(y: number): boolean;
    isOnBaseGridX(x: number): boolean;
    isOnBaseGridY(y: number): boolean;
    getNearGridX2(x: number, dir: boolean): number;
    getNearGridY2(y: number, dir: boolean): number;
    /**
     * 追加グリッドを抜いたグリッドの取得
     * @param x
     * @param bx
     * @param module
     * @return
    **/
    getNearNotExtraGrid(x: number, bx: number, module: number): number;
    getExtraGridX(): number[];
    getExtraGridY(): number[];
    addExtraGridX(x: number): boolean;
    addExtraGridY(y: number): boolean;
}
