var kiteclib_1 = require('kiteclib');
var SymbolAttribute_1 = require('./SymbolAttribute');
//module nethome.geom
/**
 * シンボルの属性コレクション
 * @author kawae
**/
var SymbolAttributeCollection = (function () {
    /**
     * コンストラクタ**/
    function SymbolAttributeCollection() {
        this.mAttributes = new Array();
    }
    /**
     * コピーの取得
     * @return
    **/
    SymbolAttributeCollection.prototype.getCopy = function () {
        var sac = new SymbolAttributeCollection();
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            sac.mAttributes.push(sa.getCopy());
        }
        return sac;
    };
    SymbolAttributeCollection.prototype.addAttribute = function (key, val, copybuffer) {
        if (key instanceof SymbolAttribute_1.SymbolAttribute) {
            this.mAttributes.push(key);
        }
        var a = new SymbolAttribute_1.SymbolAttribute();
        a.mKey = key;
        a.mValue = val;
        a.mCopyBuffer = copybuffer;
        this.mAttributes.push(a);
    };
    /**
     * アトリビュートの取得
     * @param key
     * @return
    **/
    SymbolAttributeCollection.prototype.getAttributes = function () {
        return this.mAttributes;
    };
    /**
     * キーが存在するか
     * @param key
     * @return
    **/
    SymbolAttributeCollection.prototype.hasAttribute = function (key) {
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            if (sa.mKey.toLowerCase() === key.toLowerCase())
                return true;
        }
        return false;
    };
    /**
     * キーの削除
     * @param key
    **/
    SymbolAttributeCollection.prototype.getAttribute = function (key) {
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            if (sa.mKey.toLowerCase() == key.toLowerCase())
                return sa;
        }
        return null;
    };
    /**
     * キーの削除
     * @param key
    **/
    SymbolAttributeCollection.prototype.removeAttributeKey = function (key) {
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            if (sa.mKey.toLowerCase() == key.toLowerCase()) {
                this.mAttributes.splice(i, 1);
                i--;
            }
        }
    };
    /**
     * キーの削除
     * @param key
    **/
    SymbolAttributeCollection.prototype.removeAttribute = function (sa) {
        var i = this.mAttributes.indexOf(sa);
        if (i >= 0) {
            this.mAttributes.splice(i, 1);
        }
    };
    /**
     * 保存
     * @param w
     * @param space
     * @throws Exception
    **/
    SymbolAttributeCollection.prototype.save = function (savenode) {
        savenode.setName("SYMBOLATTRIBUTES");
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            var of = new kiteclib_1.ObjectFolder("");
            sa.save(of);
            savenode.addChild(of, true);
        }
    };
    return SymbolAttributeCollection;
})();
exports.SymbolAttributeCollection = SymbolAttributeCollection;
//# sourceMappingURL=SymbolAttributeCollection.js.map