//module nethome.geom
/**
 * @author kawae
 **/
var SymbolAttribute = (function () {
    function SymbolAttribute() {
        /**
         * コピー操作時に属性もバッファするかのフラグ **/
        this.mCopyBuffer = true;
    }
    SymbolAttribute.readData = function (of, version) {
        var sa = new SymbolAttribute();
        var on = null;
        if ((on = of.getNode("KEY")) != null)
            sa.mKey = on.getString();
        if ((on = of.getNode("VALUE")) != null)
            sa.mValue = on.getString();
        if ((on = of.getNode("COPYBUFFER")) != null)
            sa.mCopyBuffer = on.getInt() > 0;
        return sa;
    };
    SymbolAttribute.prototype.getCopy = function () {
        var sa = new SymbolAttribute();
        sa.mCopyBuffer = this.mCopyBuffer;
        sa.mKey = this.mKey;
        sa.mValue = this.mValue;
        return sa;
    };
    /**
     * データの保存
     * @param savename
    **/
    SymbolAttribute.prototype.save = function (savename) {
        if (savename == null)
            return;
        savename.setName("ATTRIBUTE");
        savename.addNode("KEY", this.mKey);
        savename.addNode("VALUE", this.mValue);
        savename.addNode("COPYBUFFER", this.mCopyBuffer);
    };
    SymbolAttribute.prototype.isSetCopyBuffer = function () {
        return this.mCopyBuffer;
    };
    return SymbolAttribute;
})();
exports.SymbolAttribute = SymbolAttribute;
//# sourceMappingURL=SymbolAttribute.js.map