import { KLocalAxis } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
/**
 * ローカル座標系**/
export declare class LocalAxis2Df implements KLocalAxis {
    /**
     * 座標系原点の絶対座標 **/
    mX: number;
    mY: number;
    /**
     * 回転角度 **/
    mRot: number;
    /**
     * XY軸の反転 **/
    mFlipX: boolean;
    mFlipY: boolean;
    /**
     * 横方向変形可能フラグ **/
    scaleEnableX: boolean;
    /**
     * 縦方向変形可能フラグ **/
    scaleEnableY: boolean;
    /**
     * 拡大率 **/
    mScaleX: number;
    mScaleY: number;
    /**
     * コンストラクタ**/
    constructor();
    /**
     * コンストラクタ
     * @param x1
     * @param y1
     * @param x2
     * @param y2
    **/
    constructor(x1: number, y1: number, x2: number, y2: number);
    /**
     * コンストラクタ
     * @param lc
    **/
    constructor(lc: LocalAxis2Df);
    /**
     * 横方向のサイズの取得
     * @return
    **/
    getScaleX(): number;
    /**
     * 縦方向のサイズの取得
     * @return
    **/
    getScaleY(): number;
    setScaleX(x: number, aspect: boolean): void;
    setScaleY(y: number, aspect: boolean): void;
    setScale(x: number, y: number): void;
    setScaleEnable(x: boolean, y: boolean): void;
    isScaleEnableX(): boolean;
    isScaleEnableY(): boolean;
    /**
     * 読み込み(2005/06/09追加)
     * @param of
     * @param version
     * @return
     * @throws Exception
     * @author kawae
     * @since 2005/06/09
    **/
    static readData(of: ObjectFolder): LocalAxis2Df;
    /**
     * データの保存
     * @param parent
    **/
    save(parent: ObjectFolder): void;
    setLocalCoordinates(x1: number, y1: number, x2: number, y2: number, fx: boolean, fy: boolean): void;
    setLocalCoordinatesRot(x: number, y: number, rot: number, fx: boolean, fy: boolean): void;
    setLocalCoordinatesLc(lc: LocalAxis2Df): void;
    getFlipX(): boolean;
    setFlipX(f: boolean): void;
    getFlipY(): boolean;
    setFlipY(f: boolean): void;
    getScaledX(x: number, y: number, keepaspect: boolean, sx: boolean, sy: boolean, bx: number, by: number): number;
    getScaledY(x: number, y: number, keepaspect: boolean, sx: boolean, sy: boolean, bx: number, by: number): number;
    /**
     * ローカル座標->Xグローバル座標(拡大縮小フラグ有り)**/
    getGlobalX(x: number, y: number, keepaspect?: boolean, sx?: boolean, sy?: boolean, bx?: number, by?: number): number;
    /**
     * ローカル座標->Yグローバル座標(拡大縮小フラグ有り)**/
    getGlobalY(x: number, y: number, keepaspect?: boolean, sx?: boolean, sy?: boolean, bx?: number, by?: number): number;
    getGlobalLength(len: number): number;
    /**
     * グローバル座標->Xローカル座標**/
    getLocalX(x: number, y: number): number;
    /**
     * グローバル座標->Xローカル座標**/
    getLocalY(x: number, y: number): number;
    getGlobalAngl(rad: number): number;
    equals(obj: LocalAxis2Df): boolean;
}
