import { Geometry } from './primitive/Geometry';
import { ILinkTarget } from './ILinkTarget';
/**
 * リンクライン
 * @author kawae
**/
export interface ILinkLine {
    /**
     * リンクする端点オブジェクトか調べる**/
    isLinkNode(o: Object): boolean;
    /**
     * リンクモードの設定
     * @param mode
     * @author kawae
     * @since 2004/10/04
    **/
    setLinkModeStart(mode: number): void;
    setLinkModeEnd(mode: number): void;
    /**
     * リンクモードの取得
     * @return
     * @author kawae
     * @since 2004/10/04
    **/
    getLinkModeStart(): number;
    getLinkModeEnd(): number;
    setLinkVH(flag: boolean): void;
    isLinkVH(): boolean;
    isLinkStart(o: Object): boolean;
    isLinkEnd(o: Object): boolean;
    getLinkNodeStart(): Object;
    getLinkNodeEnd(): Object;
    /**
     * リンク先を設定**/
    setLinkObject(lnode: Object, ltarget: ILinkTarget): void;
    /**
     * リンクオブジェクトにリンクしている幾何オブジェクトの取得**/
    getLinkNode(ltarget: ILinkTarget): Geometry;
    /**
     * ノードにリンクしているオブジェクトの取得
     * @param node
     * @return
     * @author kawae
     * @since 2004/10/08
    **/
    getLinkObject(node: Object): ILinkTarget;
    getRefNode(g: Geometry): Geometry;
    /**
     * リンクの位置を更新
     * @param g リンクの縛りの点オブジェクト
    **/
    updateLinkShape(): void;
    /**
     * 読み込み時等、ダミーのリンクオブジェクトのリカバリーを行う。
     * @param geoms
     * @author kawae
     * @since 2004/11/02
    **/
    recoverLink(geoms: Geometry[]): void;
}
