import { IRichGraphics, KColor } from 'kiteclib';
import { Geometry } from './primitive/Geometry';
import { GPoint2Df } from './primitive/GPoint2Df';
import { GText } from './primitive/GText';
export declare class GTextGroup extends Geometry {
    /**
     * 中心座標 **/
    mCp: GPoint2Df;
    /**
     * 角度 **/
    mAngl: number;
    /**
     * サイズ **/
    mSize: number;
    /**
     * 文字列群 **/
    mTexts: Array<GText>;
    /**
     * 描画方向 (true:横) **/
    mDir: boolean;
    mBackFill: boolean;
    mFillColor: KColor;
    mScaleFont: string;
    /**
     * コンストラクタ
     * @param p1
     * @param scaleFontLabel
     * @param angl
     * @param size
    **/
    constructor(p1: GPoint2Df, scaleFontLabel: string, angl: number, size: number);
    /**
     * 描画方向の設定**/
    setDir(dir: boolean): void;
    setBackColor(fill: boolean, c: KColor): void;
    /**
     * テキストの個数の取得**/
    getTextSize(): number;
    update(): void;
    addText(s: string, size: number, bold: boolean): void;
    /**
     * 全テキストの削除**/
    removeAll(): void;
    getDistanceToPoint(x: number, y: number): number;
    offset(x: number, y: number): void;
    /**
     * 横反転**/
    flipx(x: number, ofsx: number): void;
    /**
     * 縦反転**/
    flipy(y: number, ofsy: number): void;
    drawGeom(d: IRichGraphics, fore: KColor, back: KColor): void;
}
