var kiteclib_1 = require('kiteclib');
var GLine_1 = require('./primitive/GLine');
var NethomeCoreLookAndFeel_1 = require('../NethomeCoreLookAndFeel');
var NethomeCoreResource_1 = require('../NethomeCoreResource');
//module nethome.geom
/**
 * 領域コントロールクラス
 * @author kawae
**/
var AreaControl = (function () {
    /**
     * コンストラクタ**/
    function AreaControl() {
        /**
         * エリアのクローズオプション **/
        this.mClose = true;
        this._points = [];
        this._lines = [];
    }
    /**
     * 初期化**/
    AreaControl.prototype.init = function () {
        this._points.length = 0;
        this._lines.length = 0;
    };
    AreaControl.prototype.setCloseMode = function (f) {
        this.mClose = f;
    };
    AreaControl.prototype.getCloseMode = function () {
        return this.mClose;
    };
    /**
     * 線群の作成**/
    AreaControl.prototype.close = function () {
        var ofs = this.mClose ? 0 : 1;
        this._lines.length = 0;
        for (var i = 0; i < this._points.length - ofs; i++) {
            var p1 = this._points[(i + this._points.length) % this._points.length];
            var p2 = this._points[(i + 1) % this._points.length];
            this._lines.push(new GLine_1.GLine(p1, p2));
        }
    };
    /**
     * 点群の取得
     * @return
    **/
    AreaControl.prototype.getPoints = function () {
        return this._points;
    };
    /**
     * 線群の取得**/
    AreaControl.prototype.getLines = function () {
        return this._lines;
    };
    /**
     * エリアのセット**/
    AreaControl.prototype.setArea = function (a) {
        this._points = [];
        for (var i = 0; i < a.length; i++)
            this._points.push(a[i]);
        this.close();
    };
    AreaControl.prototype.drawGeomHilight = function (d) {
        if (this._points.length || !this.mClose) {
            var ofs = this.mClose ? 0 : 1;
            d.setColor(NethomeCoreLookAndFeel_1.NethomeCoreLookAndFeel.SELECT_SYMBOL_COLOR);
            for (var i = 0; i < this._points.length - ofs; i++) {
                var p1 = this._points[(i + this._points.length) % this._points.length];
                var p2 = this._points[(i + 1) % this._points.length];
                d.drawLine(p1.x, p1.y, p2.x, p2.y, kiteclib_1.IRichGraphicsConst.LINE_DASH_1);
            }
            for (var i = 0; i < this._points.length; i++) {
                var pt = this._points[i];
                d.setColor(NethomeCoreLookAndFeel_1.NethomeCoreLookAndFeel.SELECT_SYMBOL_COLOR);
                d.drawMark(pt.x, pt.y, NethomeCoreResource_1.NethomeCoreResource.MARKER_SIZE, kiteclib_1.IRichGraphicsConst.MARK_REC_FILL);
                d.setColor(NethomeCoreLookAndFeel_1.NethomeCoreLookAndFeel.SELECT_SYMBOL_MARK_FRAME_COLOR);
                d.drawMark(pt.x, pt.y, NethomeCoreResource_1.NethomeCoreResource.MARKER_SIZE, kiteclib_1.IRichGraphicsConst.MARK_REC);
            }
        }
    };
    return AreaControl;
})();
exports.AreaControl = AreaControl;
//# sourceMappingURL=AreaControl.js.map