import { IRichGraphics } from 'kiteclib';
import { GPoint2Df } from './primitive/GPoint2Df';
import { GLine } from './primitive/GLine';
/**
 * 領域コントロールクラス
 * @author kawae
**/
export declare class AreaControl {
    /**
     * 点群 **/
    private _points;
    /**
     * 線群 **/
    private _lines;
    /**
     * エリアのクローズオプション **/
    private mClose;
    /**
     * コンストラクタ**/
    constructor();
    /**
     * 初期化**/
    init(): void;
    setCloseMode(f: boolean): void;
    getCloseMode(): boolean;
    /**
     * 線群の作成**/
    close(): void;
    /**
     * 点群の取得
     * @return
    **/
    getPoints(): GPoint2Df[];
    /**
     * 線群の取得**/
    getLines(): GLine[];
    /**
     * エリアのセット**/
    setArea(a: GPoint2Df[]): void;
    drawGeomHilight(d: IRichGraphics): void;
}
