import { Project } from './Project';
export interface ProjectHistoryManager {
    /**
     * プロジェクトを設定
     * @param project
    **/
    setProject(project: Project): void;
    /**
     * ヒストリのクリア
     * @param o
    **/
    flushHistory(): void;
    /**
     * ヒストリに設定
     * @param o
    **/
    setHistoryObject(o: Object): void;
    /**
     * カレントフロアの最後のヒストリの取得
     * @return
    **/
    getLastHistory(): Object;
    /**
     * カレントフロアの現在のヒストリの取得
     * @return
    **/
    getCurrentHistory(): Object;
    /**
     * アンドゥ**/
    undo(): boolean;
    /**
     * リドゥ**/
    redo(): boolean;
    /**
     * ヒストリに追加
     * @author kawae
     * @since 2004/09/22
    **/
    addHistory(): void;
    /**
     * UNDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    hasUndo(): boolean;
    /**
     * REDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    hasRedo(): boolean;
    /**
     * 指定された数の履歴を保存する新たな履歴を構築する。
     * @param num
    **/
    setMaxHistory(num: number): void;
}
