import { ProjectListener } from './ProjectListener';
import { DocumentFactory } from './DocumentFactory';
import { Layer } from './Layer';
import { ObjectFolder } from 'kiteclib';
/**
 * プロジェクトの基本単位
 * @author kawae
**/
export interface Project {
    /**
     * データの保存
     * @return
    **/
    save(): ObjectFolder;
    load(rootf: ObjectFolder, docFactory: DocumentFactory): void;
    /**
     * レイヤーノードの読み込み
     * @param layerf
     * @param docFactory
     * @author kawae
     * @since 2005/10/07
    **/
    loadLayer(layerf: ObjectFolder, docFactory: DocumentFactory): Layer;
    /**
     * レイヤーノードの読み込み
     * @param layerf
     * @param docFactory
     * @author kawae
     * @since 2005/11/02
    **/
    loadLayer(layerf: ObjectFolder, docFactory: DocumentFactory, recover: boolean): Layer;
    /**
     * プロジェクト情報の取得
     * @return
    **/
    getProjectInfoMap(): Map<Object, Object>;
    /**
     * プロジェクト情報の特定のオブジェクトの取得
     * @param key
     * @return
    **/
    getProjectInfo(key: Object): Object;
    /**
     * レイヤーの追加
     * @param lm
    **/
    addLayer(l: Layer): void;
    /**
     * 現在のレイヤーの設定
     * @param i	レイヤーID
    **/
    setCurrentLayer(i: number): void;
    /**
     * 現在レイヤーの設定
     * @param s	レイヤーの名前
    **/
    setCurrentLayer(s: string): void;
    getLayers(): Array<Layer>;
    setSaved(changed: boolean): void;
    isSaved(): boolean;
    /**
     * 現在のアクティブレイヤーの取得
     * @return アクティブなレイヤー
    **/
    getCurrentLayer(): Layer;
    /**
     * ドキュメントのクリア**/
    documentRefresh(): void;
    /**
     * ヒストリのクリア
     * @param o
    **/
    flushHistory(): void;
    /**
     * カレントフロアの最後のヒストリの取得
     * @return
    **/
    getLastHistory(): Object;
    /**
     * カレントフロアの現在のヒストリの取得
     * @return
    **/
    getCurrentHistory(): Object;
    /**
     * アンドゥ**/
    undo(): boolean;
    /**
     * リドゥ**/
    redo(): boolean;
    /**
     * ヒストリに追加
     * @author kawae
     * @since 2004/09/22
    **/
    addHistory(): void;
    /**
     * UNDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    hasUndo(): boolean;
    /**
     * REDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    hasRedo(): boolean;
    /**
     * 指定された数の履歴を保存する新たな履歴を構築する。
     * @param num
    **/
    setMaxHistory(num: number): void;
    /**
     * プロジェクトの変更を通知するリスナーを通知リストに追加
     * @param l
    **/
    addProjectListener(l: ProjectListener): void;
    /**
     * リスナーを通知リストから削除
     * @param l
    **/
    removeProjectListener(l: ProjectListener): void;
    /**
     * プロジェクトが変更されたことを全てのリスナーに通知**/
    fireProjectChanged(source: Object): void;
}
