import { ObjectFolder } from 'kiteclib';
import { History } from 'kiteclib';
import { Project } from './Project';
import { DocumentFactory } from './DocumentFactory';
import { ProjectHistoryManager } from './ProjectHistoryManager';
export declare class ObjectFolderProjectHistoryManager implements ProjectHistoryManager {
    /**
     * 管理プロジェクト **/
    mProject: Project;
    /**
     * ヒストリー **/
    mHistory: History<Project, ObjectFolder>;
    /**
     * コンストラクタ**/
    constructor(histnum: number, factory: DocumentFactory);
    setProject(project: Project): void;
    flushHistory(): void;
    setHistoryObject(o: Object): void;
    getLastHistory(): Object;
    getCurrentHistory(): Object;
    undo(): boolean;
    redo(): boolean;
    copyProject(src: Project): void;
    addHistory(): void;
    hasUndo(): boolean;
    hasRedo(): boolean;
    setMaxHistory(num: number): void;
}
