var kiteclib_1 = require('kiteclib');
var WorkSheet_1 = require('../geom/WorkSheet');
//import { Document } from './Document'
//module nethome.doc
/**
 * 画層最小単位クラス
 * @author kawae
**/
var Layer = (function () {
    /**
    // * 選択バッファソート用バッファ **/
    //mSortTmp: ArrayList<Geometry> = new ArrayList<Geometry>();
    ///**
    // * コンストラクタ**/
    //public constructor() {
    //    thisconstructor(null, new WorkSheet());
    //}
    ///**
    // * コンストラクタ
    // * @param ws 作業範囲
    //**/
    //public constructor(ws: WorkSheet) {
    //    thisconstructor(null, ws);
    //}
    /**
     * コンストラクタ
     * @param name レイヤ名
     * @param ws 作業範囲
    **/
    function Layer(ws, name) {
        this.mName = name;
        this.mPrims = [];
        this.mVisible = true;
        this.mWorkSheet = ws || new WorkSheet_1.WorkSheet();
        this.mSelectBuffer = [];
    }
    Layer.prototype.setName = function (name) {
        this.mName = name;
    };
    Layer.prototype.getName = function () {
        return this.mName;
    };
    /**
     * ワークシートの指定
     * @param ws
     * @author kawae
     * @since 2004/10/02
    **/
    Layer.prototype.setWorkSheet = function (ws) {
        this.mWorkSheet = ws;
    };
    /**
     * ワークシートの取得**/
    Layer.prototype.getWorkSheet = function () {
        return this.mWorkSheet;
    };
    /**
     * IDのリナンバリング
     * @author kawae
     * @since 2004/10/12
    **/
    Layer.prototype.renumberID = function () {
        for (var i = 0; i < this.mPrims.length; i++) {
            var g = this.mPrims[i];
            g.setID(i + 1);
        }
    };
    /**
     * データの保存
     * @param savenode
    **/
    Layer.prototype.save = function (savenode) {
        savenode.setName("LAYER");
        savenode.addNode("TYPE", "LAYER");
        for (var i = 0; i < this.mPrims.length; i++) {
            var g = this.mPrims[i];
            var of = new kiteclib_1.ObjectFolder("");
            g.save(of);
            savenode.addChild(of, true);
        }
    };
    /**
     * 選択バッファに追加
     * @param g			追加する幾何オブジェクト
     * @param flip		true:反転モード（既にバッファ内に存在すればバッファから削除）
     * false:通常モード（単純追加。但し、バッファに存在すれば追加しない）
    **/
    Layer.prototype.addSelectBuffer = function (g, flip) {
        if (this.mPrims.indexOf(g) < 0)
            return;
        var i = this.mSelectBuffer.indexOf(g);
        if (i >= 0) {
            if (flip)
                this.mSelectBuffer.splice(i, 1);
        }
        else {
            this.mSelectBuffer.push(g);
        }
        this.sortSelectBuffer();
    };
    /**
     * 選択バッファのクリア**/
    Layer.prototype.clearSelectBuffer = function () {
        this.mSelectBuffer.length = 0;
    };
    /**
     * 選択バッファコレクションの取得
     * @return
    **/
    Layer.prototype.getSelectBuffer = function () {
        return this.mSelectBuffer;
    };
    /**
     * 選択バッファのソート**/
    Layer.prototype.sortSelectBuffer = function () {
        if (this.mSelectBuffer.length == 0)
            return;
        var sortTmp = [];
        for (var i = 0; i < this.mPrims.length; i++) {
            var o = this.mPrims[i];
            if (this.mSelectBuffer.indexOf(o) >= 0)
                sortTmp.push(o);
        }
        this.mSelectBuffer = sortTmp;
    };
    /**
     * レイヤーを初期化する**/
    Layer.prototype.refresh = function () {
        this.mPrims.length = 0;
        this.mVisible = true;
    };
    /**
     * レイヤー内にプリミティブを持つか確認
     * @return
    **/
    Layer.prototype.hasData = function () {
        return this.mPrims.length > 0;
    };
    /**
     * ファイルの読み込み
     * サブクラスにて実装する必要がある。
     * @param r 未記載
     * @param doc 未記載
     * @param version 未記載
     * @return 未記載
     * @throws Exception 未記載
    **/
    Layer.readData = function (of, doc, version) {
        return null;
    };
    /**
     * 表示・非表示を確認
     * @return
    **/
    Layer.prototype.isVisible = function () {
        return this.mVisible;
    };
    /**
     * 表示状態を設定
     * @param b 未記載
    **/
    Layer.prototype.setVisible = function (b) {
        this.mVisible = b;
    };
    /**
     * 要素コレクションの取得
     * @return 要素コレクション
    **/
    Layer.prototype.getPrims = function () {
        return this.mPrims;
    };
    /**
     * 要素コレクションの設定
     * @param v 設定する要素のコレクション
    **/
    Layer.prototype.setPrims = function (v) {
        this.mPrims = v.slice();
    };
    /**
     * 要素の追加
     * @param p 追加する要素
    **/
    Layer.prototype.addPrimitive = function (p) {
        this.mPrims.push(p);
    };
    /**
     * 要素の削除
     * @param p 削除する要素
    **/
    Layer.prototype.removePrimitive = function (p) {
        var i = this.mPrims.indexOf(p);
        if (i >= 0)
            this.mPrims.splice(i, 1);
    };
    /**
     * 全ての要素を削除する。**/
    Layer.prototype.deleteAll = function () {
        this.mPrims.length = 0;
    };
    return Layer;
})();
exports.Layer = Layer;
//# sourceMappingURL=Layer.js.map