import { ObjectFolder } from 'kiteclib';
import { WorkSheet } from '../geom/WorkSheet';
import { Geometry } from '../geom/primitive/Geometry';
/**
 * 画層最小単位クラス
 * @author kawae
**/
export declare class Layer {
    /**
     * レイヤ名 **/
    protected mName: string;
    /**
     * 基本エリア **/
    protected mWorkSheet: WorkSheet;
    /**
     * 表示・非表示フラグ **/
    protected mVisible: boolean;
    /**
     * 保持プリミティブのコレクション **/
    protected mPrims: Geometry[];
    /**
     * 選択バッファ **/
    protected mSelectBuffer: Geometry[];
    /**
    // * 選択バッファソート用バッファ **/
    /**
     * コンストラクタ
     * @param name レイヤ名
     * @param ws 作業範囲
    **/
    constructor(ws?: WorkSheet, name?: string);
    setName(name: string): void;
    getName(): string;
    /**
     * ワークシートの指定
     * @param ws
     * @author kawae
     * @since 2004/10/02
    **/
    setWorkSheet(ws: WorkSheet): void;
    /**
     * ワークシートの取得**/
    getWorkSheet(): WorkSheet;
    /**
     * IDのリナンバリング
     * @author kawae
     * @since 2004/10/12
    **/
    renumberID(): void;
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode: ObjectFolder): void;
    /**
     * 選択バッファに追加
     * @param g			追加する幾何オブジェクト
     * @param flip		true:反転モード（既にバッファ内に存在すればバッファから削除）
     * false:通常モード（単純追加。但し、バッファに存在すれば追加しない）
    **/
    addSelectBuffer(g: Geometry, flip: boolean): void;
    /**
     * 選択バッファのクリア**/
    clearSelectBuffer(): void;
    /**
     * 選択バッファコレクションの取得
     * @return
    **/
    getSelectBuffer(): Geometry[];
    /**
     * 選択バッファのソート**/
    sortSelectBuffer(): void;
    /**
     * レイヤーを初期化する**/
    refresh(): void;
    /**
     * レイヤー内にプリミティブを持つか確認
     * @return
    **/
    hasData(): boolean;
    /**
     * ファイルの読み込み
     * サブクラスにて実装する必要がある。
     * @param r 未記載
     * @param doc 未記載
     * @param version 未記載
     * @return 未記載
     * @throws Exception 未記載
    **/
    static readData(of: ObjectFolder, doc: Document, version: number): Object;
    /**
     * 表示・非表示を確認
     * @return
    **/
    isVisible(): boolean;
    /**
     * 表示状態を設定
     * @param b 未記載
    **/
    setVisible(b: boolean): void;
    /**
     * 要素コレクションの取得
     * @return 要素コレクション
    **/
    getPrims(): Geometry[];
    /**
     * 要素コレクションの設定
     * @param v 設定する要素のコレクション
    **/
    setPrims(v: Geometry[]): void;
    /**
     * 要素の追加
     * @param p 追加する要素
    **/
    addPrimitive(p: Geometry): void;
    /**
     * 要素の削除
     * @param p 削除する要素
    **/
    removePrimitive(p: Geometry): void;
    /**
     * 全ての要素を削除する。**/
    deleteAll(): void;
}
