import { DocumentListener } from './DocumentListener';
import { Project } from './Project';
import { ProjectListener } from './ProjectListener';
import { ProjectEvent } from './ProjectEvent';
/**
 * ライブラリ用のドキュメントなど、各種ドキュメントを管理する
 * ドキュメント管理クラス。
 * @since 　2003/03/12
 * @author　Kawae
 * @version 2003/03/12
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
**/
export declare class Document implements ProjectListener {
    /**
     * プロジェクトドキュメント **/
    protected mProject: Project;
    /**
     * プロジェクトドキュメント **/
    protected mProjects: Project[];
    /**
     * リスナー **/
    protected mListeners: DocumentListener[];
    /**
     * すべてのドキュメントを空として、新たな Document を構築する。
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    constructor();
    /**
     * この Document が管理する NetHomeドキュメントを返す。
     * @return NetHomeドキュメント
     * @see #setNh3Doc(DocumentNh3)
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    getProject(): Project;
    /**
     * 指定されたプロジェクトを、この Document が管理する
     * NetHome ドキュメントとして設定する。
     * @param prj	NetHome ドキュメント
     * @see #getProject()
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    setProject(prj: Project): void;
    /**
     * 指定されたプロジェクトを、この Document が管理するプロジェクトに追加する。
     * @param prj
    **/
    addProject(prj: Project): void;
    /**
     * 指定されたプロジェクトを、この Document が管理するプロジェクトから削除する。
     * @param prj
    **/
    removeProject(prj: Project): void;
    /**
     * この Document が管理するプロジェクトのリストを返す。**/
    getProjects(): Project[];
    /**
     * この Document が管理するすべてのドキュメントをリフレッシュする。
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    refreshDocument(): void;
    addDocumentListener(l: DocumentListener): void;
    removeDocumentListener(l: DocumentListener): void;
    fireDocumentChanged(source: Object): void;
    projectChanged(e: ProjectEvent): void;
}
