var kiteclib_1 = require('kiteclib');
var ProjectEvent_1 = require('./ProjectEvent');
//module nethome.doc
/**
 * プロジェクトの基本単位
 * @author kawae
**/
var DefaultProject = (function () {
    /**
     * コンストラクタ**/
    function DefaultProject(history) {
        this.mLayers = [];
        this.mProjectInfo = new Map();
        this.mHistoryManager = history;
        this.mHistoryManager.setProject(this);
        this.mListeners = [];
        this.setSaved(true);
    }
    /**
     * データの保存
     * @return
    **/
    DefaultProject.prototype.save = function () {
        var of = new kiteclib_1.ObjectFolder("DATA");
        this.saveProjectInformation(of);
        this.getLayers().forEach(function (l) {
            var lf = new kiteclib_1.ObjectFolder("");
            lf.addNode("NAME", l.getName());
            l.save(lf);
            of.addChild(lf, true);
        });
        return of;
    };
    DefaultProject.prototype.load = function (rootf, docFactory) {
        var _this = this;
        var tmp = rootf.getNode("DATA");
        if (tmp != null && tmp instanceof kiteclib_1.ObjectFolder) {
            var of = (tmp);
            this.loadProjectInformation(of);
            var v = of.getNamedElement("LAYER");
            v.forEach(function (on) {
                var lm = _this.loadLayer(on, docFactory);
                _this.addLayer(lm);
            });
        }
    };
    /**
     * レイヤーノードの読み込み
     * @param layerf
     * @param docFactory
     * @author kawae
     * @since 2005/10/07
    **/
    //loadLayer(layerf: ObjectFolder, docFactory: DocumentFactory): Layer {
    //    return this.loadLayer(layerf, docFactory, true);
    //}
    /**
     * レイヤーノードの読み込み
     * @param layerf
     * @param docFactory
     * @author kawae
     * @since 2005/11/02
    **/
    DefaultProject.prototype.loadLayer = function (layerf, docFactory, recover) {
        var _this = this;
        if (recover === void 0) { recover = true; }
        var layerName = (layerf.getNode("NAME").getObject());
        var l = this.createLoadLayer(docFactory, layerName);
        layerf.getChildren().forEach(function (o) {
            if (o instanceof kiteclib_1.ObjectFolder) {
                var geom = o;
                var ng = docFactory.getGeomParser().getGeometry(geom);
                _this.addGeomToLayer(l, ng);
            }
        });
        if (recover)
            this.recoverAfterLoad(l);
        return l;
    };
    /**
     * ロード時のLayer
     * @param app
     * @param layerName
     * @return
     * @author kawae
     * @since 2004/12/13
    **/
    DefaultProject.prototype.createLoadLayer = function (app, layerName) {
        var lm = app.createLayer(this, layerName);
        return lm;
    };
    /**
     * プロジェクト情報の書き込み
     * @param savenode
     * @author kawae
     * @since 2004/11/06
    **/
    DefaultProject.prototype.saveProjectInformation = function (savenode) {
    };
    /**
     * プロジェクト情報の読み込み
     * @param savenode
     * @author kawae
     * @since 2004/11/28
    **/
    DefaultProject.prototype.loadProjectInformation = function (node) {
    };
    /**
     * 読み込んだ幾何をレイヤーに追加
     * @param l
     * @param g
     * @author kawae
     * @since 2004/11/06
    **/
    DefaultProject.prototype.addGeomToLayer = function (l, g) {
        if (g != null)
            l.addPrimitive(g);
    };
    /**
     * レイヤー単位で読み込み完了後に必要な処理の実行
     * @param l
     * @author kawae
     * @since 2004/11/06
    **/
    DefaultProject.prototype.recoverAfterLoad = function (l) {
        for (var j = 0; j < l.getPrims().length; j++) {
            var o = l.getPrims()[j];
            //if (o instanceof ILinkLine) {
            if (typeof o.recoverLink === "function") {
                o.recoverLink(l.getPrims());
            }
        }
    };
    /**
     * プロジェクト情報の取得
     * @return
    **/
    DefaultProject.prototype.getProjectInfoMap = function () {
        return this.mProjectInfo;
    };
    /**
     * プロジェクト情報の特定のオブジェクトの取得
     * @param key
     * @return
    **/
    DefaultProject.prototype.getProjectInfo = function (key) {
        if (this.mProjectInfo == null)
            return null;
        return this.mProjectInfo.get(key);
    };
    /**
     * レイヤーの追加
     * @param lm
    **/
    DefaultProject.prototype.addLayer = function (l) {
        this.mLayers.push(l);
    };
    DefaultProject.prototype.setCurrentLayer = function (t) {
        if (typeof t === "number") {
            var i = t;
            if (i >= 0 && i < this.mLayers.length)
                this.mActiveLayer = this.mLayers[i];
        }
        if (typeof t === "string") {
            var s = t;
            for (var i = 0; i < this.mLayers.length; i++) {
                var l = this.mLayers[i];
                var ss = l.getName();
                if (ss != null && ss === s) {
                    this.mActiveLayer = l;
                    return;
                }
            }
        }
    };
    DefaultProject.prototype.getLayers = function () {
        return this.mLayers;
    };
    DefaultProject.prototype.setSaved = function (changed) {
        this.mSaved = changed;
    };
    DefaultProject.prototype.isSaved = function () {
        return this.mSaved;
    };
    /**
     * 現在のアクティブレイヤーの取得
     * @return アクティブなレイヤー
    **/
    DefaultProject.prototype.getCurrentLayer = function () {
        return this.mActiveLayer;
    };
    /**
     * ドキュメントのクリア**/
    DefaultProject.prototype.documentRefresh = function () {
        this.mActiveLayer = null;
        for (var i = 0; i < this.mLayers.length; i++) {
            var l = this.mLayers[i];
            l.deleteAll();
            l.clearSelectBuffer();
        }
        this.mLayers.length = 0;
        this.mHistoryManager.flushHistory();
    };
    /**
     * ヒストリのクリア
     * @param o
    **/
    DefaultProject.prototype.flushHistory = function () {
        this.mHistoryManager.flushHistory();
    };
    /**
     * ヒストリに設定
     * @param o
    **/
    DefaultProject.prototype.setHistoryObject = function (o) {
        this.mHistoryManager.setHistoryObject(o);
    };
    /**
     * カレントフロアの最後のヒストリの取得
     * @return
    **/
    DefaultProject.prototype.getLastHistory = function () {
        return this.mHistoryManager.getLastHistory();
    };
    /**
     * カレントフロアの現在のヒストリの取得
     * @return
    **/
    DefaultProject.prototype.getCurrentHistory = function () {
        return this.mHistoryManager.getCurrentHistory();
    };
    /**
     * アンドゥ**/
    DefaultProject.prototype.undo = function () {
        return this.mHistoryManager.undo();
    };
    /**
     * リドゥ**/
    DefaultProject.prototype.redo = function () {
        return this.mHistoryManager.redo();
    };
    /**
     * ヒストリに追加
     * @author kawae
     * @since 2004/09/22
    **/
    DefaultProject.prototype.addHistory = function () {
        this.mHistoryManager.addHistory();
    };
    /**
     * UNDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    DefaultProject.prototype.hasUndo = function () {
        return this.mHistoryManager.hasUndo();
    };
    /**
     * REDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    DefaultProject.prototype.hasRedo = function () {
        return this.mHistoryManager.hasRedo();
    };
    /**
     * 指定された数の履歴を保存する新たな履歴を構築する。
     * @param num
    **/
    DefaultProject.prototype.setMaxHistory = function (num) {
        this.mHistoryManager.setMaxHistory(num);
    };
    DefaultProject.prototype.addProjectListener = function (l) {
        if (l == null)
            return;
        if (this.mListeners.indexOf(l) >= 0)
            return;
        this.mListeners.push(l);
    };
    DefaultProject.prototype.removeProjectListener = function (l) {
        var i = this.mListeners.indexOf(l);
        if (i >= 0)
            this.mListeners.splice(i, 1);
    };
    DefaultProject.prototype.fireProjectChanged = function (source) {
        var e = new ProjectEvent_1.ProjectEvent(source, this);
        var size = this.mListeners.length;
        for (var i = size - 1; i >= 0; i--) {
            this.mListeners[i].projectChanged(e);
        }
    };
    return DefaultProject;
})();
exports.DefaultProject = DefaultProject;
//# sourceMappingURL=DefaultProject.js.map