var kiteclib_1 = require('kiteclib');
//module nethome
/**
 * リソースを表すクラス
 * @author $Author: tanaka $
 * @version $Revision: 446 $ $Date:: 2010-03-19 20:38:08 +0900#$
**/
var NethomeCoreResource;
(function (NethomeCoreResource) {
    NethomeCoreResource.TEXT_CONFIRM = "確認";
    /**
     * ライブラリフォルダ **/
    NethomeCoreResource.LIB_DIR = "library";
    /**
     * 拡張子群 **/
    NethomeCoreResource.LIB_TYPES = null;
    /**
     * 縦書き文字列 **/
    NethomeCoreResource.TATE_STRING = "ー（）()";
    /**
     * マウスオペレーションの閾値（ドットサイズ）**/
    NethomeCoreResource.EPS_DOT_LEN = 5;
    /**
     * スケーリング用フォントサイズ **/
    NethomeCoreResource.SCALEFONTSIZE = 100;
    /**
     * 基本フォント **/
    NethomeCoreResource.DEF_FONT_NAME = "Dialog";
    /**
     * 部屋名表記用のスケールフォント **/
    NethomeCoreResource.SCALEFONT_DEF_NAME = "DEF";
    NethomeCoreResource.SCALEFONT_DEF_FONTNAME = "MS Gothic";
    NethomeCoreResource.SCALEFONT_DEF_FONTTYPE = kiteclib_1.KFont.PLAIN;
    /**
     * 部屋名表記用のフォント **/
    NethomeCoreResource.SCALEFONT_ROOM_NAME = "ROOM";
    NethomeCoreResource.SCALEFONT_ROOM_FONTNAME = "MS Gothic";
    NethomeCoreResource.SCALEFONT_ROOM_FONTTYPE = kiteclib_1.KFont.PLAIN;
    /**
     * グリッド分割数 **/
    NethomeCoreResource.GRID_DIVS = [1, 2, 4];
    /**
     * テキストの縦書きの場合の方向 左から右が true **/
    NethomeCoreResource.TATEGAKI_DIR = false;
    /**
     * マーカのサイズ（ドット） **/
    NethomeCoreResource.MARKER_SIZE = 3;
    /**
     * 会社名(バージョンに記述される) **/
    NethomeCoreResource.CORP = "";
    /**
     * テキストプロパティファイル名 **/
    NethomeCoreResource.mTextPropertyFile = null;
    /**
     * ページ最大数 **/
    NethomeCoreResource.MAX_PAGE_NUMBER = 3;
    /**
     * テキストリソースプロパティ **/
    var mTextProperty = null;
    /**
     * アプレットモード(true:アプレット false:アプリケーション) **/
    NethomeCoreResource.mAppletMode = true;
    /**
     * NethomeRuntimeの実装クラス名 **/
    NethomeCoreResource.RUNTIME_NAME = null;
    var mScaleFontDB;
    //private static $init_NethomeCoreResource_2006_flg : Boolean = $init_NethomeCoreResource_2006();
    //private static function $init_NethomeCoreResource_2006() : Boolean {{
    //        NethomeCoreResource.mScaleFontDB = new HashMap<stringKFont>();
    //        NethomeCoreResource.update();
    //    }
    //    return true;
    //}
    //static update() : void {
    //    NethomeCoreResource.mDefFont = KFont.getFont(NethomeCoreResource.DEF_FONT_NAME, KFont.PLAIN, 12);
    //    NethomeCoreResource.mScaleFont = KFont.getFont(NethomeCoreResource.SCALEFONT_DEF_FONTNAME, NethomeCoreResource.SCALEFONT_DEF_FONTTYPE, NethomeCoreResource.SCALEFONTSIZE);
    //    NethomeCoreResource.mRoomNameScaleFont = KFont.getFont(NethomeCoreResource.SCALEFONT_ROOM_FONTNAME, NethomeCoreResource.SCALEFONT_ROOM_FONTTYPE, NethomeCoreResource.SCALEFONTSIZE);
    //}
    /**
     * スケールフォントの取得
     * @param s
     * @return Font
    **/
    function getScaleFont(s) {
        if (s.toLowerCase() === NethomeCoreResource.SCALEFONT_DEF_NAME.toLowerCase())
            return NethomeCoreResource.mScaleFont;
        else if (s.toLowerCase() === NethomeCoreResource.SCALEFONT_ROOM_NAME.toLowerCase())
            return NethomeCoreResource.mRoomNameScaleFont;
        else {
            if (mScaleFontDB.get(s) != null)
                return mScaleFontDB.get(s);
            var f = kiteclib_1.KFont.getFont(s, NethomeCoreResource.SCALEFONT_ROOM_FONTTYPE, NethomeCoreResource.SCALEFONTSIZE);
            mScaleFontDB.set(s, f);
            return f;
        }
    }
    NethomeCoreResource.getScaleFont = getScaleFont;
    /**
     * propertyファイルからリソースファイルを取得
     * @param s
     * @return
    **/
    function getTextResource(s) {
        if (mTextProperty == null) {
            mTextProperty = new Map();
        }
        var res = mTextProperty.get(s);
        return res;
    }
    NethomeCoreResource.getTextResource = getTextResource;
    mScaleFontDB = new Map();
})(NethomeCoreResource = exports.NethomeCoreResource || (exports.NethomeCoreResource = {}));
//# sourceMappingURL=NethomeCoreResource.js.map