var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var kwt = require('kiteclib');
var WRichGraphics_1 = require('./WRichGraphics');
var WRuntime = (function (_super) {
    __extends(WRuntime, _super);
    function WRuntime() {
        _super.apply(this, arguments);
    }
    WRuntime.prototype.getFont = function (fontname, fontstyle, fontsize) {
        var font = new WFont(fontname, fontstyle, fontsize);
        return font;
    };
    WRuntime.prototype.wrapFont = function (nativeFont) {
        return null;
    };
    WRuntime.prototype.getImage = function (fs, s) {
        return null;
    };
    WRuntime.prototype.wrapNativeImage = function (image) {
        return null;
    };
    return WRuntime;
})(kwt.KRuntime);
exports.WRuntime = WRuntime;
var WFont = (function (_super) {
    __extends(WFont, _super);
    function WFont(fontname, fonttype, fontsize) {
        _super.call(this, fontname, fonttype, fontsize);
        this.fontMetrics = new WFontMetricsSimple(fontsize, fontsize, fontsize, 0);
    }
    WFont.prototype.getFontMetrics = function (context) {
        var ctx = null;
        if (context instanceof CanvasRenderingContext2D) {
            ctx = context;
        }
        if (context instanceof WRichGraphics_1.WRichGraphics) {
            ctx = context.ctx;
        }
        if (ctx)
            return new WFontMetrics(this, ctx);
        return this.fontMetrics;
    };
    WFont.prototype.getFontObject = function () {
        return this;
    };
    return WFont;
})(kwt.KFont);
//TODO
var WFontMetrics = (function () {
    function WFontMetrics(font, context) {
        this.font = font;
        this.context = context;
    }
    WFontMetrics.prototype.stringWidth = function (s) {
        this.context.save();
        WRichGraphics_1.applyFont(this.context, this.font.name(), this.font.style(), this.font.size());
        var m = this.context.measureText(s);
        var w = m.width;
        this.context.restore();
        return w;
    };
    WFontMetrics.prototype.getHeight = function () {
        return this.font.height();
    };
    WFontMetrics.prototype.getAscent = function () {
        return this.font.height();
    };
    WFontMetrics.prototype.getDescent = function () {
        return 0;
    };
    return WFontMetrics;
})();
var WFontMetricsSimple = (function () {
    function WFontMetricsSimple(w, h, ascent, descent) {
        this.w = w;
        this.h = h;
        this.ascent = ascent;
        this.descent = descent;
    }
    WFontMetricsSimple.prototype.stringWidth = function (s) {
        return this.w * s.length;
    };
    WFontMetricsSimple.prototype.getHeight = function () {
        return this.h;
    };
    WFontMetricsSimple.prototype.getAscent = function () {
        return this.ascent;
    };
    WFontMetricsSimple.prototype.getDescent = function () {
        return this.descent;
    };
    return WFontMetricsSimple;
})();
//# sourceMappingURL=WRuntime.js.map