var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var kwt = require('kiteclib');
var WRichGraphics = (function (_super) {
    __extends(WRichGraphics, _super);
    function WRichGraphics() {
        _super.call(this);
    }
    WRichGraphics.prototype.setColor = function (color) {
        if (color instanceof kwt.KColor) {
            var c = color.css();
            this.ctx.fillStyle = c;
            this.ctx.strokeStyle = c;
        }
    };
    WRichGraphics.prototype.setStroke = function (lt) {
        if (!lt)
            lt = kwt.IRichGraphicsConst.LINE_1;
        var w = 0;
        if (lt.widthType() === kwt.KLineType.TYPE_DEVICE)
            w = lt.width();
        else if (lt.widthType() === kwt.KLineType.TYPE_DRAWING)
            w = lt.width() * this.mDotPerLen;
        this.ctx.lineWidth = w;
    };
    WRichGraphics.prototype.setQuality = function (quality) {
        this.quality = quality;
    };
    WRichGraphics.prototype.getQuality = function () {
        return this.quality;
    };
    WRichGraphics.prototype.setClipArea = function (x1, y1, x2, y2) { };
    WRichGraphics.prototype.releaseClipArea = function () { };
    WRichGraphics.prototype.drawCircle = function (x1, y1, x2, y2, p4, lt) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawEllipse = function (x1, y1, x2, y2, p4, p5, lt) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawFillCircle = function (x1, y1, x2, y2, p4, lt) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawFillEllipse = function (x1, y1, x2, y2, p4, p5, lt) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawFillRect = function (x1, y1, x2, y2, lt) {
        this.setStroke(lt);
        var xa = this.realToDevXd(x1);
        var ya = this.realToDevYd(y1);
        var xb = this.realToDevXd(x2);
        var yb = this.realToDevYd(y2);
        if (xa > xb) {
            var tmp = xa;
            xa = xb;
            xb = tmp;
        }
        if (ya < yb) {
            var tmp = ya;
            ya = yb;
            yb = tmp;
        }
        this.ctx.fillRect(xa, ya, xb - xa, yb - ya);
    };
    WRichGraphics.prototype.drawFillRoundRect = function (x1, y1, x2, y2, p4, lt) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawImageId = function (img, id, x1, y1, x2, y2) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawImagePrefixId = function (img, prefix, id, x1, y1, x2, y2) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawImagePosition = function (img, x1, y1, x2, y2) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawImageRect = function (img, cx, cy, width, height, angle) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawLine = function (x1, y1, x2, y2, lt) {
        var xa = this.realToDevXd(x1);
        var ya = this.realToDevYd(y1);
        var xb = this.realToDevXd(x2);
        var yb = this.realToDevYd(y2);
        this.setStroke(lt);
        this.ctx.beginPath();
        this.ctx.moveTo(xa, ya);
        this.ctx.lineTo(xb, yb);
        this.ctx.stroke();
    };
    WRichGraphics.prototype.drawMark = function (x, y, r, type) {
        //console.warn("Unimplemented " + arguments);
        var xc = this.realToDevX(x);
        var yc = this.realToDevY(y);
        switch (type) {
            case kwt.IRichGraphicsConst.MARK_CIR:
                //g2.drawArc(xc - r, yc - r, r * 2, r * 2, 0, 360);
                this.ctx.beginPath();
                this.ctx.arc(xc, yc, r, 0, 360);
                this.ctx.stroke();
                break;
            case kwt.IRichGraphicsConst.MARK_CIR_FILL:
                //g2.fillArc(xc - r, yc - r, r * 2, r * 2, 0, 360);
                this.ctx.beginPath();
                this.ctx.arc(xc, yc, r, 0, 360);
                this.ctx.fill();
                break;
            case kwt.IRichGraphicsConst.MARK_REC:
                //g2.drawRect(xc - r, yc - r, r * 2, r * 2);
                this.ctx.beginPath();
                this.ctx.rect(xc - r, yc - r, r * 2, r * 2);
                this.ctx.stroke();
                break;
            case kwt.IRichGraphicsConst.MARK_REC_FILL:
                //g2.fillRect(xc - r, yc - r, r * 2, r * 2);
                this.ctx.beginPath();
                this.ctx.rect(xc - r, yc - r, r * 2, r * 2);
                this.ctx.fill();
                break;
            case kwt.IRichGraphicsConst.MARK_CROS:
                this.ctx.beginPath();
                this.ctx.moveTo(xc - r, yc);
                this.ctx.lineTo(xc + r, yc);
                this.ctx.moveTo(xc, yc - r);
                this.ctx.lineTo(xc, yc + r);
                this.ctx.stroke();
                //g2.drawLine(xc - r, yc, xc + r, yc);
                //g2.drawLine(xc, yc - r, xc, yc + r);
                break;
        }
    };
    WRichGraphics.prototype.drawRect = function (x1, y1, x2, y2, lt) {
        this.setStroke(lt);
        var xa = this.realToDevXd(x1);
        var ya = this.realToDevYd(y1);
        var xb = this.realToDevXd(x2);
        var yb = this.realToDevYd(y2);
        if (xa > xb) {
            var tmp = xa;
            xa = xb;
            xb = tmp;
        }
        if (ya < yb) {
            var tmp = ya;
            ya = yb;
            yb = tmp;
        }
        this.ctx.strokeRect(xa, ya, xb - xa, yb - ya);
    };
    WRichGraphics.prototype.drawRoundRect = function (x1, y1, x2, y2, p4, lt) {
        console.warn("Unimplemented " + arguments);
    };
    WRichGraphics.prototype.drawText = function (text, x, y, fontname, fonttype, size, angle) {
        var xx = this.realToDevXd(x);
        var yy = this.realToDevYd(y);
        var tsize = this.mDotPerLen * size;
        this.ctx.font = tsize + "px '" + fontname + "'";
        if (angle == 0) {
            this.ctx.fillText(text, xx, yy);
        }
        else {
            this.ctx.save();
            this.ctx.translate(xx, yy);
            this.ctx.rotate(-angle * kwt.MathUtil.D2R);
            this.ctx.translate(-xx, -yy);
            this.ctx.fillText(text, xx, yy);
            this.ctx.restore();
        }
    };
    WRichGraphics.prototype.fillPath = function (lt) {
        this.setStroke(lt);
        if (this.fillRule === kwt.IRichGraphicsConst.WIND_EVEN_ODD)
            this.ctx.fill("evenodd");
        else if (this.fillRule === kwt.IRichGraphicsConst.WIND_NON_ZERO)
            this.ctx.fill("nonzero");
        else
            this.ctx.fill();
    };
    WRichGraphics.prototype.drawPath = function (lt) {
        this.setStroke(lt);
        this.ctx.stroke();
    };
    WRichGraphics.prototype.pathClear = function () {
        this.ctx.beginPath();
    };
    WRichGraphics.prototype.pathClose = function () {
        this.ctx.closePath();
    };
    WRichGraphics.prototype.pathInit = function (w) {
        this.fillRule = w;
        this.ctx.beginPath();
    };
    WRichGraphics.prototype.pathLineTo = function (x, y, la) {
        var xx = this.getx(x, y, la);
        var yy = this.gety(x, y, la);
        this.ctx.lineTo(xx, yy);
    };
    WRichGraphics.prototype.pathMoveTo = function (x, y, la) {
        var xx = this.getx(x, y, la);
        var yy = this.gety(x, y, la);
        this.ctx.moveTo(xx, yy);
    };
    WRichGraphics.prototype.pathQuadTo = function (x1, y1, x2, y2, la) {
        var xa = this.getx(x1, y1, la);
        var ya = this.gety(x1, y1, la);
        var xb = this.getx(x2, y2, la);
        var yb = this.gety(x2, y2, la);
        this.ctx.quadraticCurveTo(xa, ya, xb, yb);
    };
    WRichGraphics.prototype.pathCurveTo = function (x1, y1, x2, y2, x3, y3, la) {
        var xa = this.getx(x1, y1, la);
        var ya = this.gety(x1, y1, la);
        var xb = this.getx(x2, y2, la);
        var yb = this.gety(x2, y2, la);
        var xc = this.getx(x3, y3, la);
        var yc = this.gety(x3, y3, la);
        this.ctx.bezierCurveTo(xa, ya, xb, yb, xc, yc);
    };
    return WRichGraphics;
})(kwt.AbstractRichGraphics);
exports.WRichGraphics = WRichGraphics;
function applyFont(ctx, fontname, fonttype, size) {
    ctx.font = size + "px '" + fontname + "'";
}
exports.applyFont = applyFont;
//# sourceMappingURL=WRichGraphics.js.map