import { IRichGraphics } from 'kiteclib';
import { Canvas2D } from '../Canvas2D';
/**
 * ドキュメント操作クラス<br> <br> サブクラスでアプリケーション特有の操作処理を実装する。<br> <br> [注意事項]<br> ・ドキュメント状態の表示とその操作に特化する。<br> ・<B>このクラスが無くてもドキュメントを再現出来ることが必要</B><br>　あくまでもMVCモデルのC(コントローラ）であることを厳守する。<br>
 * 　一時的なものであり、このサブクラスが存在しなくても操作が出来なくなるだけで、ドキュメントを構成する<br>
 * 　要素でな無いことに最大限注意する。<br>・ドキュメントはMainComponentのインスタンスから取得する。<br> MainComponent mc = MainComponent.getInstance();<br> MainApplication app = mc.getApplication();<br>
 * @author kawae
 * @version 1.0
**/
export declare class Command {
    /**
     * コマンド情報(タイトル、チップなど) **/
    protected mCommandInfo: any;
    /**
     * 動作完了後も継続動作するかの指定フラグ **/
    /**
     * UIコンポーネント **/
    mComponent: HTMLElement;
    /**
     * コールバックリスナ **/
    /**
     * コンテキストメニューアイテム **/
    canvas: Canvas2D;
    /**
     * コンストラクタ
     **/
    constructor();
    /**
     * コマンドの引き続き有効モードの設定
     * @param b
    **/
    /**
     * フレームが閉じられた場合の処理**/
    /**
     * コールバックリスナの設定
     * @param l
    **/
    /**
     * コンテキストメニューアイテムの設定**/
    /**
     * コンテキストメニューの取得**/
    /**
     * 初期処理<BR> 単一動作時は処理自体を、継続動作時は初期化処理を行うことを推奨。
     * @author kawae
     * @since 2004/01/01
    **/
    play(): void;
    /**
     * 終了時処理
     * @author kawae
     * @since 2004/01/01
    **/
    end(): void;
    /**
     * ユーザーインターフェースの更新
     * @author kawae
     * @since 2004/01/01
    **/
    updateInterface(): void;
    /**
     * ユーザーインターフェースの初期化
     * @author kawae
     * @since 2004/01/01
    **/
    initInterface(): void;
    /**
     * UIの作成
     * @param info	コマンド属性情報
     * @return　UIコンポーネント
     * @author kawae
     * @since 2004/10/02
    **/
    createComponent(info: any): HTMLElement;
    /**
     * @return
     * @author kawae
     * @since 2005/09/06
    **/
    /**
     * 別コマンドが実行された場合の後始末。
     * @author kawae
     * @since 2003/01/01
    **/
    restoration(): void;
    /**
     * コンポーネントの取得
     * @return
    **/
    getComponent(): HTMLElement;
    /**
     * コンポーネントの設定**/
    setComponent(c: HTMLElement): void;
    onclick: (ev: MouseEvent) => any;
    ondblclick: (ev: MouseEvent) => any;
    onmousedown: (ev: MouseEvent) => any;
    onmouseenter: (ev: MouseEvent) => any;
    onmouseleave: (ev: MouseEvent) => any;
    onmousemove: (ev: MouseEvent) => any;
    onmouseout: (ev: MouseEvent) => any;
    onmouseover: (ev: MouseEvent) => any;
    onmouseup: (ev: MouseEvent) => any;
    onmousewheel: (ev: MouseWheelEvent) => any;
    onkeydown: (ev: KeyboardEvent) => any;
    onkeypress: (ev: KeyboardEvent) => any;
    onkeyup: (ev: KeyboardEvent) => any;
    /**
     * コマンドの描画
     * @param rg	描画コンテキスト
     * @author kawae
     * @since 2003/01/01//	 * @since 2004/09/22
     * @see nethome.ui.command.Command#drawCommand(jp.kitec.kwt.IRichGraphics)
    **/
    drawCommand(d: IRichGraphics): void;
}
