var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Command_1 = require('./Command');
var Canvas2D_1 = require('../Canvas2D');
//import { CommandUtil } from './CommandUtil'
//module nethome.ui.command
/**
 * 画面移動コマンドクラス
 * @author 未入力
 * @version 1.0
**/
var ComViewMove = (function (_super) {
    __extends(ComViewMove, _super);
    function ComViewMove() {
        var _this = this;
        _super.call(this);
        this.mPres = false;
        //mouseMove(x: number, y: number, mod: number): void {
        //}
        this.onmousedown = function (ev) {
            //mousePress(x: number, y: number, mod: number): void {
            var x = ev.offsetX;
            var y = ev.offsetY;
            _this.mPres = true;
            var can = _this.canvas;
            if (can == null)
                return;
            _this.mX = x;
            _this.mY = y;
            _this.mCx = can.getViewPort().getCx();
            _this.mCy = can.getViewPort().getCy();
            //can.setDrawMode(Canvas2D.DRAW_LINE);
            can.updateImage();
            can.repaint();
        };
        this.onmousemove = function (ev) {
            var x = ev.offsetX;
            var y = ev.offsetY;
            if (ev.buttons === 0)
                return;
            //mouseDrag(x: number, y: number, mod: number): void {
            var can = _this.canvas;
            if (can == null)
                return;
            can.setCursor(Canvas2D_1.Canvas2D.MOUSE_MOVE);
            var xx = can.devToRealX(x);
            var yy = can.devToRealY(y);
            can.getViewPort().setViewCenter(_this.mCx - (xx - can.devToRealX(_this.mX)), _this.mCy - (yy - can.devToRealY(_this.mY)));
            can.updateImage();
            can.repaint();
            can.updateViewControl();
        };
        this.onmouseup = function (ev) {
            var x = ev.offsetX;
            var y = ev.offsetY;
            //mouseRelease(x: number, y: number, mod: number): void {
            if (!_this.mPres)
                return;
            var can = _this.canvas;
            if (can == null)
                return;
            //can.setDrawMode(Canvas2D.DRAW_FULL);
            can.updateImage();
            _this.mPres = false;
            //if (!this.mContinue)
            //    can.setMouseCommand(null);
            can.repaint();
        };
    }
    ComViewMove.prototype.play = function () {
        //CommandUtil.setActiveUI(this.mComponent, true);
        var can = this.canvas;
        if (can == null)
            return;
        can.setCursor(Canvas2D_1.Canvas2D.MOUSE_MOVE);
    };
    ComViewMove.prototype.end = function () {
        //CommandUtil.setActiveUI(this.mComponent, false);
        var can = this.canvas;
        if (can == null)
            return;
        if (this.mPres) {
            this.mPres = false;
            //can.setDrawMode(Canvas2D.DRAW_FULL);
            can.updateImage();
            can.repaint();
        }
        can.setCursor(Canvas2D_1.Canvas2D.MOUSE_DEF);
    };
    return ComViewMove;
})(Command_1.Command);
exports.ComViewMove = ComViewMove;
//# sourceMappingURL=ComViewMove.js.map