var k = require('kiteclib');
var Canvas2D_1 = require('./Canvas2D');
//module nethome.ui
var DefaultCanvasDrawer = (function () {
    function DefaultCanvasDrawer() {
        this.gridColor1 = k.KColor.LIGHT_GRAY;
        this.gridColor2 = k.KColor.MORELIGHT_GRAY;
    }
    /**
     * 表示
     * @param g グラフィックスコンテキスト
    **/
    DefaultCanvasDrawer.prototype.draw = function (data, rg) {
        this.drawGrid(data, rg);
        this.drawPlan(data, rg);
    };
    /**
     * 追加表示
     * @param g
    **/
    //protected drawAdditional(o: Project, g: IRichGraphics): void {
    //    let data = o as DefaultDrawData;
    //    data.mAdditionalDrawGeoms.forEach(geom => {
    //        geom.drawGeom(g);
    //    });
    //}
    /**
     * グリッドの表示
     * @param g グラフィックスコンテキスト
    **/
    DefaultCanvasDrawer.prototype.drawGrid = function (data, rg) {
        var l = data.getCurrentLayer();
        if (!l)
            return;
        var ws = l.getWorkSheet();
        var area = ws.getArea();
        var minx, miny, maxx, maxy;
        if (rg instanceof k.AbstractRichGraphics) {
            var vp = rg.getViewPort();
            var size = rg.getSize();
            minx = vp.devToRealX(size, 0);
            miny = vp.devToRealY(size, 0);
            maxx = vp.devToRealX(size, size.width);
            maxy = vp.devToRealY(size, size.height);
        }
        else {
            minx = area.minX;
            miny = area.minY;
            maxx = area.maxX;
            maxy = area.maxY;
        }
        var xx = ws.getGridCenterX();
        var yy = ws.getGridCenterY();
        var minxc = ws.getNearNotExtraGrid(minx, xx, ws.getCurrentGrid()) - 1;
        var minyc = ws.getNearNotExtraGrid(maxy, yy, ws.getCurrentGrid()) - 1;
        var maxxc = ws.getNearNotExtraGrid(maxx, xx, ws.getCurrentGrid()) + 1;
        var maxyc = ws.getNearNotExtraGrid(miny, yy, ws.getCurrentGrid()) + 1;
        minx = xx + minxc * ws.getCurrentGrid();
        miny = yy + minyc * ws.getCurrentGrid();
        maxx = xx + maxxc * ws.getCurrentGrid();
        maxy = yy + maxyc * ws.getCurrentGrid();
        rg.setColor(k.KColor.WHITE);
        //if (fill)
        rg.drawFillRect(area.minX, area.minY, area.maxX, area.maxY, k.IRichGraphicsConst.LINE_1);
        var mDrawMode = data.getProjectInfo("DRAW_MODE");
        if (mDrawMode === undefined)
            mDrawMode = Canvas2D_1.Canvas2D.DRAW_FULL;
        var dispgrid = data.getProjectInfo("DISP_GRID");
        if (dispgrid === undefined)
            dispgrid = true;
        var mc = this.gridColor1;
        var sc = this.gridColor2;
        var dash = false;
        if ((mDrawMode === Canvas2D_1.Canvas2D.DRAW_LINE || mDrawMode === Canvas2D_1.Canvas2D.DRAW_FULL) && dispgrid) {
            for (var i = minxc; i <= maxxc; i++) {
                var x = xx + i * ws.getCurrentGrid();
                var ddd = Math.abs((x - ws.getGridCenterX()) % ws.getModule());
                if (ddd < 1e-3 || Math.abs(ddd - ws.getModule()) < 1e-3) {
                    rg.setColor(mc);
                    if (!dash)
                        rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_1);
                    else
                        rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_DASH_1);
                }
                else {
                    rg.setColor(sc);
                    if (!dash)
                        rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_1);
                    else
                        rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_DASH_1);
                }
            }
            for (var i = minyc; i < maxyc; i++) {
                var y = yy + i * ws.getCurrentGrid();
                var ddd = Math.abs((y - ws.getGridCenterY()) % ws.getModule());
                if (ddd < 1e-3 || Math.abs(ddd - ws.getModule()) < 1e-3) {
                    rg.setColor(mc);
                    if (!dash)
                        rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_1);
                    else
                        rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_DASH_1);
                }
                else {
                    rg.setColor(sc);
                    if (!dash)
                        rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_1);
                    else
                        rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_DASH_1);
                }
            }
            var exX = ws.getExtraGridX();
            if (exX != null) {
                rg.setColor(mc);
                for (var i = 0; i < exX.length; i++) {
                    var x = exX[i];
                    if (x > minx && x < maxx) {
                        if (!dash)
                            rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_1);
                        else
                            rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_DASH_1);
                    }
                }
            }
            var exY = ws.getExtraGridY();
            if (exY != null) {
                rg.setColor(mc);
                for (var i = 0; i < exY.length; i++) {
                    var y = exY[i];
                    if (y > miny && y < maxy) {
                        if (!dash)
                            rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_1);
                        else
                            rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_DASH_1);
                    }
                }
            }
        }
    };
    //protected drawPreGridObject(data: Project, g: IRichGraphics): void {
    //}
    //protected drawPostGridObject(data: Project, g: IRichGraphics): void {
    //}
    /**
     * Projectの表示
     * @param g グラフィックスコンテキスト
    **/
    DefaultCanvasDrawer.prototype.drawPlan = function (data, rg) {
        var l = data.getCurrentLayer();
        if (!l)
            return;
        for (var _i = 0, _a = l.getPrims(); _i < _a.length; _i++) {
            var g = _a[_i];
            g.drawGeom(rg);
        }
    };
    DefaultCanvasDrawer.prototype.drawDynamic = function (data, rg) {
        //this.drawAdditional(data, rg);
        //this.drawOptionalObject(data, rg);
        this.drawSelectedObject(data, rg);
    };
    //protected drawOptionalObject(obj: Project, rg: IRichGraphics): void {
    //    var data = obj as DefaultDrawData;
    //    for (var i: number = 0; i < data.mOptionalDrawElement.length; i++) {
    //        var o = data.mOptionalDrawElement[i];
    //        if (o instanceof Geometry)
    //            o.drawGeom(g);
    //    }
    //}
    /**
     * 選択されたオブジェクトの描画**/
    DefaultCanvasDrawer.prototype.drawSelectedObject = function (data, rg) {
        var l = data.getCurrentLayer();
        if (!l)
            return;
        for (var _i = 0, _a = l.getSelectBuffer(); _i < _a.length; _i++) {
            var g = _a[_i];
            g.drawHighLight(rg, k.KColor.GREEN, true);
        }
    };
    return DefaultCanvasDrawer;
})();
exports.DefaultCanvasDrawer = DefaultCanvasDrawer;
//# sourceMappingURL=DefaultCanvasDrawer.js.map