//import { KKeyEvent } from '../../jp/kitec/kwt/KKeyEvent'
import { CommandManager } from './CommandManager'
//import { AccelKey } from '../../jp/kitec/lib/gui/event/AccelKey'
import { Command } from './command/Command'
//import { MultiCanvasCommand } from './command/MultiCanvasCommand'
import { Canvas2D } from './Canvas2D'

//module nethome.ui

/**
 * 各種イベントをコマンドに振り分ける
 * @author matsuzaki
**/
export class CanvasCommandDispatcher {
    /**
     * アクティブなコマンド **/
    mActiveCommand: Command = null;
    /**
     * アクティブなマスクコマンド **/
    mActiveMaskCommand: Command = null;
    /**
     * 矢印キーコマンド **/
    mArrowCommand: Command = null;
    /**
     * ビューコントロールコマンド **/
    mViewControlCommand: Command;
    /**
     * オペレーションが無い場合のコマンド **/
    mNullCommand: Command = null;
    mCanvas: Canvas2D;

    /****/
    public constructor(can: Canvas2D) {
        this.mCanvas = can;
    }

    /**
     * 現在アクティブなマスクコマンドの取得
     * @return the activeMaskCommand
    **/
    getActiveMaskCommand(): Command {
        return this.mActiveMaskCommand;
    }

    /**
     * マスクコマンドをクリア**/
    clearMaskCommand(): void {
        this.mActiveMaskCommand = null;
    }

    /**
     * 現在アクティブなコマンドの取得
     * @return
     * @author kawae
    **/
    getMouseCommand(): Command {
        return this.mActiveCommand;
    }

    /**
     * オペレーションが無い場合のコマンド**/
    setNullCommand(c: Command): void {
        this.mNullCommand = c;
        this.setMouseCommand(c);
    }

    /**
     * 矢印キーコマンドの設定**/
    setArrowKeyCommand(m: Command): void {
        this.mArrowCommand = m;
    }

    /**
     * ビューコントロールコマンドの設定
     * @param c
    **/
    setViewControlCommand(c: Command): void {
        this.mViewControlCommand = c;
    }

    /**
     * ビューコントロールコマンドの取得
     * @return
    **/
    getViewControlCommand(): Command {
        return this.mViewControlCommand;
    }

    /**
     * ビューコントロールコマンドの更新**/
    updateViewControl(): void {
        if (this.mViewControlCommand != null)
            this.mViewControlCommand.updateInterface();
    }

    /**
     * アクティブコマンドの設定
     * @param c
    **/
    setMouseCommand(c: Command): void {
        if (this.mActiveCommand != null)
            this.mActiveCommand.end();
        if (c == null) {
            this.mActiveCommand = this.mNullCommand;
            if (this.mNullCommand != null) {
                this.mNullCommand.updateInterface();
                this.mNullCommand.play();
            }

        } else {
            this.mActiveCommand = c;
        }
        if (this.mActiveCommand != null) {
            this.mActiveCommand.setCurrentCanvas(this.mCanvas);
        }

        this.mCanvas.repaint();
    }

    /*
    onbeforecopy(ev: DragEvent): any {
    }
    onbeforecut(ev: DragEvent): any {
    }
    ondrag(ev: DragEvent): any {
    }
    ondragend(ev: DragEvent): any {
    }
    ondragenter(ev: DragEvent): any {
    }
    ondragleave(ev: DragEvent): any {
    }
    ondragover(ev: DragEvent): any {
    }
    ondragstart(ev: DragEvent): any {
    }
    ondrop(ev: DragEvent): any {
    }
    onpaste(ev: DragEvent): any {
    }
    */

define(`HANDLER',`
    $1(ev: $2): any {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.$1)
                this.mActiveMaskCommand.$1(ev);
        } else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.$1)
                this.mActiveCommand.$1(ev);
        }
    }')

HANDLER(onclick, MouseEvent)
HANDLER(ondblclick, MouseEvent)
HANDLER(onmousedown, MouseEvent)
HANDLER(onmouseenter, MouseEvent)
HANDLER(onmouseleave, MouseEvent)
HANDLER(onmousemove, MouseEvent)
HANDLER(onmouseout, MouseEvent)
HANDLER(onmouseover, MouseEvent)
HANDLER(onmouseup, MouseEvent)
HANDLER(onmousewheel, MouseWheelEvent)

HANDLER(onkeydown, KeyboardEvent)
HANDLER(onkeypress, KeyboardEvent)
HANDLER(onkeyup, KeyboardEvent)

    //mouseWheelUp(x: number, y: number, modifiers: number): void {
    //    if (this.mViewControlCommand != null)
    //        this.mViewControlCommand.wheelUp(x, y, modifiers);
    //}

    //mouseWheelDown(x: number, y: number, modifiers: number): void {
    //    if (this.mViewControlCommand != null)
    //        this.mViewControlCommand.wheelDown(x, y, modifiers);
    //}

    //protected clicktime: number = 0;

    //mouseClicked(x: number, y: number, modifiers: number): void {
    //    if (this.mActiveMaskCommand != null)
    //        return;
    //    this.mCanvas.updateCurrentMousePos(x, y, modifiers);
    //    if (this.mActiveMaskCommand != null)
    //        return;
    //    let curtime: number = System.currentTimeMillis();
    //    if (curtime - this.clicktime < 300) {
    //        if (this.mActiveCommand != null)
    //            this.mActiveCommand.mouseDoubleClicked(x, y, modifiers);
    //    }

    //    this.clicktime = curtime;
    //}

    //mousePressed(x: number, y: number, modifiers: number): void {
    //    this.mCanvas.updateCurrentMousePos(x, y, modifiers);
    //    if (this.mActiveMaskCommand != null)
    //        this.mActiveMaskCommand.mousePress(x, y, modifiers);
    //    else if (this.mActiveCommand != null)
    //        this.mActiveCommand.mousePress(x, y, modifiers);
    //}

    //mouseReleased(x: number, y: number, modifiers: number): void {
    //    mCanvas.updateCurrentMousePos(x, y, modifiers);
    //    if (mActiveMaskCommand != null) mActiveMaskCommand.mouseRelease(x, y, modifiers); else if (this.mActiveCommand != null) mActiveCommand.mouseRelease(x, y, modifiers);
    //}

    //mouseDragged(x: number, y: number, modifiers: number): void {
    //    mCanvas.updateCurrentMousePos(x, y, modifiers);
    //    if (mActiveMaskCommand != null) mActiveMaskCommand.mouseDrag(x, y, modifiers); else if (this.mActiveCommand != null) mActiveCommand.mouseDrag(x, y, modifiers);
    //}

    //mouseMoved(x: number, y: number, modifiers: number): void {
    //    mCanvas.updateCurrentMousePos(x, y, modifiers);
    //    if (mActiveMaskCommand != null) mActiveMaskCommand.mouseMove(x, y, modifiers); else if (this.mActiveCommand != null) mActiveCommand.mouseMove(x, y, modifiers);
    //}

    //mouseEntered(x: number, y: number, modifiers: number): void {
    //    mCanvas.updateCurrentMousePos(x, y, modifiers);
    //    if (mActiveMaskCommand != null) {
    //        mActiveMaskCommand.mouseEntered(x, y, modifiers);
    //    }
    //    else if (mActiveCommand != null) {
    //        mActiveCommand.mouseEntered(x, y, modifiers);
    //    }

    //}

    //mouseExited(x: number, y: number, modifiers: number): void {
    //    mCanvas.updateCurrentMousePos(x, y, modifiers);
    //    if (mActiveMaskCommand != null) {
    //        mActiveMaskCommand.mouseExited(x, y, modifiers);
    //    }
    //    else if (mActiveCommand != null) {
    //        mActiveCommand.mouseExited(x, y, modifiers);
    //    }

    //}

    //keyPress(keycode: number, keymod: number): void {
    //    let mc: CommandManager = CommandManager.getInstance();
    //    if (this.mActiveCommand != null &&
    //        this.mActiveCommand.keyPress(keycode, keymod)) return;
    //    if (this.mArrowCommand != null
    //        && (KKeyEvent.isMatchKey(keycode, "UP")
    //            || KKeyEvent.isMatchKey(keycode, "DOWN")
    //            || KKeyEvent.isMatchKey(keycode, "LEFT")
    //            || KKeyEvent.isMatchKey(keycode, "RIGHT")
    //            || KKeyEvent.isMatchKey(keycode, "PAGE_UP")
    //            || KKeyEvent.isMatchKey(keycode, "PAGE_DOWN")
    //            || KKeyEvent.isMatchKey(keycode, "HOME"))) {
    //        if (this.mArrowCommand.keyPress(keycode, keymod)) return;
    //    }

    //    /*
    //      let kc: AccelKey = mc.getAccel(keycode, keymod);
    //      if (kc != null) {
    //          (((kc.getObject()) as Command) ).accelerate();
    //          if (mActiveCommand != null) mActiveCommand.restoration();
    //          if (mActiveMaskCommand != null) {
    //              mActiveMaskCommand.end();
    //              mActiveMaskCommand = null;
    //          }
  
    //          return;
    //      }
    //    */

    //    if (KKeyEvent.isMatchKey(keycode, "ESCAPE")) {
    //        if (this.mActiveCommand != null)
    //            this.mActiveCommand.restoration();
    //        this.setMouseCommand(null);
    //        this.mCanvas.repaint();
    //        return;
    //    }

    //    let c: Command = mc.getMaskCommand(keymod);
    //    if (c != this.mActiveMaskCommand) {
    //        if (this.mActiveMaskCommand != null)
    //            this.mActiveMaskCommand.end();
    //        this.mActiveMaskCommand = c;
    //        if (this.mActiveMaskCommand != null) {
    //            if (this.mActiveCommand != null)
    //                this.mActiveCommand.restoration();
    //            this.mActiveMaskCommand.play();
    //        }
    //    }
    //}

    //keyRelease(keycode: number, keymod: number): void {
    //    let mc: CommandManager = CommandManager.getInstance();
    //    if (this.mActiveMaskCommand != null) {
    //        this.mActiveMaskCommand.end();
    //        this.mActiveMaskCommand = null;
    //    }

    //    this.mActiveMaskCommand = mc.getMaskCommand(keymod);
    //    if (this.mActiveMaskCommand != null) {
    //        this.mActiveMaskCommand.play();
    //    } else if (this.mActiveCommand != null) {
    //        this.mActiveCommand.keyReleased(keycode, keymod);
    //    }
    //    this.mCanvas.repaint();
    //}
}
