import { Command } from './command/Command';
import { Canvas2D } from './Canvas2D';
/**
 * 各種イベントをコマンドに振り分ける
 * @author matsuzaki
**/
export declare class CanvasCommandDispatcher {
    /**
     * アクティブなコマンド **/
    private mActiveCommand;
    /**
     * アクティブなマスクコマンド **/
    private mActiveMaskCommand;
    /**
     * 矢印キーコマンド **/
    private mArrowCommand;
    /**
     * ビューコントロールコマンド **/
    private mViewControlCommand;
    /**
     * オペレーションが無い場合のコマンド **/
    private mNullCommand;
    private mCanvas;
    /****/
    constructor(can: Canvas2D);
    /**
     * 現在アクティブなマスクコマンドの取得
     * @return the activeMaskCommand
    **/
    getActiveMaskCommand(): Command;
    /**
     * マスクコマンドをクリア**/
    clearMaskCommand(): void;
    /**
     * 現在アクティブなコマンドの取得
     * @return
     * @author kawae
    **/
    getMouseCommand(): Command;
    /**
     * オペレーションが無い場合のコマンド**/
    setNullCommand(c: Command): void;
    /**
     * 矢印キーコマンドの設定**/
    setArrowKeyCommand(m: Command): void;
    /**
     * ビューコントロールコマンドの設定
     * @param c
    **/
    setViewControlCommand(c: Command): void;
    /**
     * ビューコントロールコマンドの取得
     * @return
    **/
    getViewControlCommand(): Command;
    /**
     * ビューコントロールコマンドの更新**/
    updateViewControl(): void;
    /**
     * アクティブコマンドの設定
     * @param c
    **/
    setMouseCommand(c: Command): void;
    onclick(ev: MouseEvent): any;
    ondblclick(ev: MouseEvent): any;
    onmousedown(ev: MouseEvent): any;
    onmouseenter(ev: MouseEvent): any;
    onmouseleave(ev: MouseEvent): any;
    onmousemove(ev: MouseEvent): any;
    onmouseout(ev: MouseEvent): any;
    onmouseover(ev: MouseEvent): any;
    onmouseup(ev: MouseEvent): any;
    onmousewheel(ev: MouseWheelEvent): any;
    onkeydown(ev: KeyboardEvent): any;
    onkeypress(ev: KeyboardEvent): any;
    onkeyup(ev: KeyboardEvent): any;
}
export declare var bindHandlers: (canvas: Canvas2D, dispatcher: CanvasCommandDispatcher) => void;
