var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
var kiteclib_3 = require('kiteclib');
var kiteclib_4 = require('kiteclib');
var DefaultCanvasDrawer_1 = require('./DefaultCanvasDrawer');
var CanvasCommandDispatcher_1 = require('./CanvasCommandDispatcher');
var WRichGraphics_1 = require('../web/WRichGraphics');
//module nethome.ui
/**
 * 描画クラス**/
var Canvas2D = (function () {
    /**
     * コンストラクタ
     * @author kawae
     **/
    function Canvas2D(canvas) {
        //static MOUSE_CROSS = KCursor.CURSOR_HAIR;//: Cursor = new Cursor(Cursor.CROSSHAIR_CURSOR);
        /**
         * ドキュメント **/
        this.mDoc = null;
        /**
         * コマンドとイベント処理 **/
        this.mCommandDispatcher = null;
        //static mDefFont: KFont = KFont.getFont("Dialog", KFont.PLAIN, 12);
        /**
         * 背景色 **/
        this.mBackColor = kiteclib_4.KColor.SUPERLIGHT_GRAY;
        /**
         * 抽象キャンバス
         **/
        this.mAbstCanvas = new WRichGraphics_1.WRichGraphics();
        /**
         * ポップアップの位置
         **/
        //private mPopUpPos: Point;
        /**
         * 再描画の必要有り
         **/
        this.mNeedImageUpdate = true;
        this.domElement = canvas;
        this.mContext2D = this.domElement.getContext("2d");
        this.mCommandDispatcher = new CanvasCommandDispatcher_1.CanvasCommandDispatcher(this);
        //this.setBackground(java.awt.Color.white);
        //this.addMouseListener(this);
        //this.addMouseMotionListener(this);
        //mPopup = new KPopupMenu();
        //mPopUpPos = new Point(0, 0);
        this.mCurrentMouse = new kiteclib_3.KPoint2d();
        //this.setFocusable(true);
        this.mDrawer = new DefaultCanvasDrawer_1.DefaultCanvasDrawer();
        //this.mDrawData = new DefaultDrawData();
    }
    Canvas2D.prototype.setEventHandler = function (c) {
        c.addEventListener("click", this.mCommandDispatcher.onclick);
    };
    Canvas2D.prototype.getSize = function () {
        return new kiteclib_2.KDimension(this.domElement.clientWidth, this.domElement.clientHeight);
    };
    /**
     * 現在アクティブなコマンドの取得
     * @return
     * @author kawae
     **/
    Canvas2D.prototype.getMouseCommand = function () {
        return this.mCommandDispatcher.getMouseCommand();
    };
    Canvas2D.prototype.setDrawer = function (d) {
        this.mDrawer = d;
    };
    Canvas2D.prototype.getDrawer = function () {
        return this.mDrawer;
    };
    /**
     * オペレーションが無い場合のコマンド
     **/
    Canvas2D.prototype.setNullCommand = function (c) {
        this.mCommandDispatcher.setNullCommand(c);
    };
    /**
     * 矢印キーコマンドの設定
     **/
    Canvas2D.prototype.setArrowKeyCommand = function (m) {
        this.mCommandDispatcher.setArrowKeyCommand(m);
    };
    /**
     * ライブラリの整合性のため、マスクをクリア
     **/
    Canvas2D.prototype.clearMaskCommand = function () {
        this.mCommandDispatcher.clearMaskCommand();
    };
    /**
     * ビューコントロールコマンドの設定
     * @param c
     **/
    Canvas2D.prototype.setViewControlCommand = function (c) {
        this.mCommandDispatcher.setViewControlCommand(c);
    };
    /**
     * ビューコントロールコマンドの取得
     * @return
     **/
    Canvas2D.prototype.getViewControlCommand = function () {
        return this.mCommandDispatcher.getViewControlCommand();
    };
    /**
     * ビューコントロールコマンドの更新
     **/
    Canvas2D.prototype.updateViewControl = function () {
        this.mCommandDispatcher.updateViewControl();
    };
    /**
     * アクティブコマンドの設定
     * @param c
     **/
    Canvas2D.prototype.setMouseCommand = function (c) {
        this.mCommandDispatcher.setMouseCommand(c);
        this.repaint();
    };
    Canvas2D.prototype.getXdotlength = function (dot) {
        return dot / this.mAbstCanvas.getDotPerLen();
    };
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    Canvas2D.prototype.realToDevX = function (x) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().realToDevX(this.getSize(), x);
    };
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    Canvas2D.prototype.realToDevY = function (y) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().realToDevY(this.getSize(), y);
    };
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    Canvas2D.prototype.realToDevXd = function (x) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().realToDevXd(this.getSize(), x);
    };
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    Canvas2D.prototype.realToDevYd = function (y) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().realToDevYd(this.getSize(), y);
    };
    /**
     * 画面座標から実座標へ（ｘ）
     * @param x	デバイス座標値
     * @return		実座標値
    **/
    Canvas2D.prototype.devToRealX = function (x) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().devToRealX(this.getSize(), x);
    };
    /**
     * 画面座標から実座標へ（ｙ）
     * @param y	デバイス座標値
     * @return		実座標値
    **/
    Canvas2D.prototype.devToRealY = function (y) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().devToRealY(this.getSize(), y);
    };
    /**
     * ドキュメントのセット
     * @param d	ドキュメント
     **/
    Canvas2D.prototype.setDocument = function (d) {
        this.mDoc = d;
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.resetView();
        d.addDocumentListener(this);
    };
    /**
     * ドキュメントの取得
     **/
    Canvas2D.prototype.getDocument = function () {
        return this.mDoc;
    };
    /**
     * プロジェクトの取得
     **/
    Canvas2D.prototype.getProject = function () {
        return this.mDoc.getProject();
    };
    Canvas2D.prototype.setCursor = function (c) {
        //super.setCursor(CursorManager.getInstance().getCursor(c));
    };
    /**
     * コンテキストの現在の表示ステータス
     **/
    //private mDispContext: boolean = false;
    /**
     * コンテキストメニューを表示
     * @param x
     * @param y
    **/
    //showContext(x: number, y: number): void {
    //    let pi = this.getPopupMenu();
    //    mPopUpPos.setLocation(x, y);
    //    if (pi != null) pi.show(this, x, y);
    //    mDispContext = true;
    //}
    /**
     * コンテキストメニューの取得
     * @return
    **/
    //getPopupMenu(): KPopupMenu {
    //    return mPopup;
    //}
    /**
     * ポップアップの位置の取得
     * @return
     * @author kawae
     * @since 2005/03/23
    **/
    //getPopupPos(): KPoint2d {
    //    return this.mPopUpPos;
    //}
    //endContext(): void {
    //    this.mDispContext = false;
    //    this.requestFocus();
    //}
    /**
     * コンテキストメニューが表示されているかを確認
     * @return　表示:true
     * 　　　　　非表示:false
    **/
    //isShowContext(): boolean {
    //    return mDispContext;
    //}
    //getKSize(): KDimension {
    //    return new KDimension(this.getSize().width, this.getSize().height);
    //}
    Canvas2D.prototype.save = function (of) {
    };
    Canvas2D.prototype.load = function (of) {
    };
    /**
     * ビューの更新
     * @author kawae
     * @since 2004/10/02
    **/
    Canvas2D.prototype.updateView = function () {
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.updateImage();
        this.repaint();
    };
    /**
     * ビューポートの取得**/
    Canvas2D.prototype.getViewPort = function () {
        return this.mAbstCanvas.getViewPort();
    };
    /**
     * スケールの設定
     * @param f　対象スケール(%指定。100が標準)
    **/
    Canvas2D.prototype.setZoomAsScale = function (f) {
        var prj = this.mDoc.getProject();
        var vp = this.mAbstCanvas.getViewPort();
        var size = this.mAbstCanvas.getSize();
        if (vp != null && size != null) {
            var module = prj.getCurrentLayer().getWorkSheet().getModule();
            var a = prj.getCurrentLayer().getWorkSheet().getArea();
            var defw = ((a.maxX + module) - (a.minX - module));
            var defh = ((a.maxY + module) - (a.minY - module));
            var rw = defw / size.width;
            var rh = defh / size.height;
            var wx = module / 10;
            var wy = module / 10;
            if (rw > rh) {
                wx = defw * 100 / f / 2;
            }
            else {
                wy = defh * 100 / f / 2;
            }
            this.mAbstCanvas.setView(vp.getCx() - wx, vp.getCy() - wy, vp.getCx() + wx, vp.getCy() + wy);
        }
    };
    /**
     * 現在のズームレシオの取得
     * @return	表示％
     **/
    Canvas2D.prototype.getZoomRatio = function () {
        var vp = this.getViewPort();
        if (vp == null)
            return 0;
        var prj = this.mDoc.getProject();
        var size = this.mAbstCanvas.getSize();
        if (size == null)
            return 100;
        var a = prj.getCurrentLayer().getWorkSheet().getArea();
        var module = prj.getCurrentLayer().getWorkSheet().getModule();
        var defw = (a.maxX + module) - (a.minX - module);
        var defh = (a.maxY + module) - (a.minY - module);
        var rw = defw / size.width;
        var rh = defh / size.height;
        var cp;
        var len;
        if (rw > rh) {
            var x1 = this.mAbstCanvas.devToRealX(0);
            var x2 = this.mAbstCanvas.devToRealX(size.width);
            len = x2 - x1;
            cp = defw;
        }
        else {
            var y1 = this.mAbstCanvas.devToRealY(size.height);
            var y2 = this.mAbstCanvas.devToRealY(0);
            len = y2 - y1;
            cp = defh;
        }
        return (cp / len) * 100;
    };
    /**
     * ワークシートの取得
     * @return
    **/
    Canvas2D.prototype.getWorkSheet = function () {
        var prj = this.mDoc.getProject();
        if (prj != null)
            return prj.getCurrentLayer().getWorkSheet();
        return null;
    };
    /**
     * 描画のリセット**/
    Canvas2D.prototype.resetView = function () {
        var vp = this.getViewPort();
        if (vp != null) {
            var prj = this.mDoc.getProject();
            var l = prj.getCurrentLayer();
            if (l) {
                var module = l.getWorkSheet().getModule();
                var a = prj.getCurrentLayer().getWorkSheet().getArea();
                vp.resetViewPort(a.minX, a.minY, a.maxX, a.maxY, module);
                this.mAbstCanvas.setView(vp.getX1(), vp.getY1(), vp.getX2(), vp.getY2(), this.mAbstCanvas.getSize());
            }
            this.updateImage();
            this.repaint();
        }
    };
    //setDispGrid(b: boolean): void {
    //    this.mDispGrid = b;
    //    this.updateImage();
    //    this.repaint();
    //}
    //displaysGrid(): boolean {
    //    return this.mDispGrid;
    //}
    ///**
    // * シンプル表示フラグ
    // **/
    //private mDrawMode: number = Canvas2D.DRAW_FULL;
    //setDrawMode(b: number): void {
    //    this.mDrawMode = b;
    //}
    //getDrawMode(): number {
    //    return this.mDrawMode;
    //}
    /**
     * 前回描画からCanvasサイズが更新されているか確認
     * @return 変更有:true　変更無:false
    **/
    Canvas2D.prototype.isChangeCanvasSize = function () {
        if (this.mBufferImage == null || this.mBufferGraphics == null)
            return true;
        else if (this.mAbstCanvas.getSize().width != this.mBufferImage.width
            || this.mAbstCanvas.getSize().height != this.mBufferImage.height)
            return true;
        return false;
    };
    Canvas2D.prototype.paintComponent = function () {
        if (this.mDoc == null)
            return;
        this.createOffGraphics();
        if (this.mNeedImageUpdate || this.isChangeCanvasSize()) {
            this.updateImageBuffer();
            this.mNeedImageUpdate = false;
        }
        this.mAbstCanvas.updateViewScale(this.mAbstCanvas.getSize());
        this.mContext2D.clearRect(0, 0, this.domElement.width, this.domElement.height);
        this.drawPlan();
        this.mAbstCanvas.ctx = this.mContext2D;
        if (this.mCommandDispatcher.getActiveMaskCommand() != null)
            this.mCommandDispatcher.getActiveMaskCommand().drawCommand(this.mAbstCanvas);
        if (this.mCommandDispatcher.getMouseCommand() != null)
            this.mCommandDispatcher.getMouseCommand().drawCommand(this.mAbstCanvas);
        //super.paintComponent(this.mOffGraphics);
        this.mAbstCanvas.ctx = null;
        //g.drawImage(this.mContext2D, 0, 0);
    };
    /**
     * バッファの内容と、その他状況依存描画オブジェクトの描画。
     **/
    Canvas2D.prototype.drawPlan = function () {
        this.mAbstCanvas.ctx = this.mContext2D;
        this.mContext2D.drawImage(this.mBufferImage, 0, 0);
        this.mDrawer.drawDynamic(this.mDoc.getProject(), this.mAbstCanvas);
        this.mAbstCanvas.ctx = null;
    };
    /**
     * オフスクリーングラフィックスの作成 オフイメージがnull,又はオフイメージと現在のサイズに 変化があった場合、オフイメージ、オフグラフィックスを 再作成する。
     **/
    Canvas2D.prototype.createOffGraphics = function () {
        this.mAbstCanvas.setSize(this.getSize().width, this.getSize().height);
        // let size = this.mAbstCanvas.getSize();
        // if (this.mOffImage == null) {
        //     this.mOffImage = document.createElement("canvas");
        // }
        // if (this.mOffImage.width != size.width || this.mOffImage.height != size.height) {
        //     this.mOffImage.width = size.width;
        //     this.mOffImage.height = size.height;
        //     this.mOffGraphics = this.mOffImage.getContext("2d");
        // }
    };
    /**
     * 再作図を要求する。 再作図フラグを立て、次回描画時に実際の処理。**/
    Canvas2D.prototype.updateImage = function () {
        this.mNeedImageUpdate = true;
    };
    /****/
    Canvas2D.prototype.updateImageBuffer = function () {
        var size = this.mAbstCanvas.getSize();
        this.mAbstCanvas.updateViewScale(size);
        //if (this.mBufferImage != null && this.mBufferGraphics != null) {
        //    let w = this.mBufferImage.getWidth(this);
        //    let h = this.mBufferImage.getHeight(this);
        //    if (size.width != w || size.height != h) {
        //        this.mBufferImage.flush();
        //        this.mBufferGraphics.dispose();
        //        this.mBufferGraphics = null;
        //        this.mBufferImage = null;
        //    }
        //}
        if (this.mBufferImage == null) {
            this.mBufferImage = document.createElement("canvas");
            this.mBufferGraphics = this.mBufferImage.getContext("2d");
        }
        this.mBufferImage.width = size.width;
        this.mBufferImage.height = size.height;
        this.mBufferGraphics.clearRect(0, 0, size.width, size.height);
        this.mAbstCanvas.ctx = this.mBufferGraphics;
        this.mAbstCanvas.setColor(this.mBackColor);
        var x1 = this.mAbstCanvas.devToRealX(-1);
        var y1 = this.mAbstCanvas.devToRealY(-1);
        var x2 = this.mAbstCanvas.devToRealX(size.width + 2);
        var y2 = this.mAbstCanvas.devToRealY(size.height + 2);
        this.mAbstCanvas.drawFillRect(x1, y1, x2, y2, null);
        //this.mDrawData.setDispGrid(this.mDispGrid);
        //this.mDrawData.setDrawMode(this.mDrawMode);
        this.mDrawer.draw(this.mDoc.getProject(), this.mAbstCanvas);
        this.mAbstCanvas.ctx = null;
    };
    /**
     * 強制描画
     * @param g
    **/
    //protected paintCurrentBuffer(g: WRichGraphics): void {
    //    g.drawBufferImage(this.mBufferImage);
    //}
    /**
     * カレントのマウス位置の取得**/
    Canvas2D.prototype.getCurrentMousePos = function () {
        return this.mCurrentMouse;
    };
    //mouseWheelMoved(e: MouseWheelEvent): void {
    //    if (e.getUnitsToScroll() < 0)
    //        mCommandDispatcher.mouseWheelUp(e.getX(), e.getY(), e.getModifiers());
    //    else
    //        mCommandDispatcher.mouseWheelDown(e.getX(), e.getY(), e.getModifiers());
    //}
    /**
     * 現在のマウス座標の設定
     * @param e	マウスイベント
    **/
    Canvas2D.prototype.updateCurrentMousePos = function (x, y, modifiers) {
        this.mCurrentMouse.x = x;
        this.mCurrentMouse.y = y;
    };
    //mouseClicked(e: MouseEvent): void {
    //    this.requestFocusInWindow();
    //    mCommandDispatcher.mouseClicked(e.getX(), e.getY(), e.getModifiers());
    //}
    //mousePressed(e: MouseEvent): void {
    //    mCommandDispatcher.mousePressed(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseReleased(e: MouseEvent): void {
    //    mCommandDispatcher.mouseReleased(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseDragged(e: MouseEvent): void {
    //    mCommandDispatcher.mouseDragged(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseMoved(e: MouseEvent): void {
    //    mCommandDispatcher.mouseMoved(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseEntered(e: MouseEvent): void {
    //    mCommandDispatcher.mouseEntered(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseExited(e: MouseEvent): void {
    //    mCommandDispatcher.mouseExited(e.getX(), e.getY(), e.getModifiers());
    //}
    //keyPress(e: KeyEvent): void {
    //    mCommandDispatcher.keyPress(e.getKeyCode(), e.getModifiers());
    //}
    //keyRelease(e: KeyEvent): void {
    //    mCommandDispatcher.keyRelease(e.getKeyCode(), e.getModifiers());
    //}
    Canvas2D.prototype.documentChanged = function (e) {
        this.updateImage();
        this.repaint();
    };
    Canvas2D.prototype.repaint = function () {
        this.paintComponent();
    };
    Canvas2D.DRAW_FULL = 0;
    Canvas2D.DRAW_SIMPLE = 1;
    Canvas2D.DRAW_LINE = 2;
    Canvas2D.MOUSE_DEF = kiteclib_1.KCursor.CURSOR_DEF; //: Cursor = new Cursor(Cursor.DEFAULT_CURSOR);
    Canvas2D.MOUSE_WAIT = kiteclib_1.KCursor.CURSOR_WAIT; //: Cursor = new Cursor(Cursor.WAIT_CURSOR);
    Canvas2D.MOUSE_MOVE = kiteclib_1.KCursor.CURSOR_MOVE; //: Cursor = new Cursor(Cursor.MOVE_CURSOR);
    Canvas2D.MOUSE_HAND = kiteclib_1.KCursor.CURSOR_HAND; //: Cursor = new Cursor(Cursor.HAND_CURSOR);
    return Canvas2D;
})();
exports.Canvas2D = Canvas2D;
//# sourceMappingURL=Canvas2D.js.map