import { KColor } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
/**
 * @author kawae
 * @since 2004/09/22
**/
export interface ITextFormat {
    /**
     * フォーマットの設定
     * @param f
     * @author kawae
     * @since 2004/09/22
    **/
    setFormat(f: ITextFormat): void;
    /**
     * フォント名の設定
     * @param s
     * @author kawae
     * @since 2004/09/22
    **/
    setFontName(s: string): void;
    /**
     * フォント名の取得
     * @return
     * @author kawae
     * @since 2004/09/22
    **/
    getFontName(): string;
    /**
     * フォントスタイルの設定
     * @author kawae
     * @since 2004/09/22
    **/
    setFontStyle(style: number): void;
    /**
     * フォントスタイルの取得
     * @return
     * @author kawae
     * @since 2004/09/22
    **/
    getFontStyle(): number;
    /**
     * フォントサイズの設定
     * @param f
     * @author kawae
     * @since 2004/09/22
    **/
    setFontSize(f: number): void;
    /**
     * フォントサイズの取得
     * @return
     * @author kawae
     * @since 2004/09/22
    **/
    getFontSize(): number;
    /**
     * アンダーラインの設定
     * @param flag
     * @return
     * @author kawae
     * @since 2004/09/22
    **/
    setUnderLine(flag: boolean): void;
    /**
     * アンダーラインの取得
     * @return
     * @author kawae
     * @since 2004/09/22
    **/
    isUnderLine(): boolean;
    /**
     * テキスト色の設定
     * @param c
     * @author kawae
     * @since 2004/09/22
    **/
    setTextColor(c: KColor): void;
    /**
     * テキスト色の取得
     * @return
     * @author kawae
     * @since 2004/09/22
    **/
    getTextColor(): KColor;
    /**
     * 塗りつぶし色の設定
     * @param c
     * @author kawae
     * @since 2004/09/22
    **/
    setBackColor(c: KColor): void;
    /**
     * 塗りつぶし色の取得
     * @return
     * @author kawae
     * @since 2004/09/22
    **/
    getBackColor(): KColor;
    /**
     * 同じフォーマットか確認
     * @param tf
     * @return
     * @author kawae
     * @since 2004/09/26
    **/
    isSameTextFormat(tf: ITextFormat): boolean;
    save(savenode: ObjectFolder): void;
}
