var kiteclib_1 = require('kiteclib');
//import { UtilObject } from 'kiteclib'
var kiteclib_2 = require('kiteclib');
var KTextElement_1 = require('./KTextElement');
//module nethome.geom.rich
/**
 * @author kawae
 * @since 2004/11/13
**/
var KTextLine = (function () {
    /**
     * コンストラクタ
     * @author kawae
     * @since 2004/11/14
    **/
    function KTextLine() {
        this.mTextElements = new Array();
    }
    /**
     * データの保存
     * @param savenode
    **/
    KTextLine.prototype.save = function (savenode) {
        if (savenode == null)
            return;
        savenode.setName(KTextLine.GEOMNAME);
        for (var i = 0; i < this.mTextElements.length; i++) {
            var te = this.mTextElements[i];
            var node = new kiteclib_1.ObjectFolder("");
            te.save(node);
            savenode.addChild(node, true);
        }
    };
    /**
     * データの保存
     * @param savenode
    **/
    KTextLine.readData = function (of, tl) {
        var v = of.getNamedElement(KTextElement_1.KTextElement.GEOMNAME);
        for (var i = 0; i < v.length; i++) {
            var tef = v[i];
            var te = new KTextElement_1.KTextElement();
            KTextElement_1.KTextElement.readData(tef, te);
            tl.addTextElement(te);
        }
        return tl;
    };
    /**
     * 内容が同じか確認
     * @param tl
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    KTextLine.prototype.isSame = function (tl) {
        if (this.mTextElements.length != tl.mTextElements.length)
            return false;
        for (var i = 0; i < this.mTextElements.length; i++) {
            var te1 = this.mTextElements[i];
            var te2 = tl.mTextElements[i];
            if (!te1.isSameTextFormat(te2))
                return false;
            if (kiteclib_2.UtilString.isDiff(te1.getText(), te2.getText()))
                return false;
        }
        return true;
    };
    /**
     * 全ての要素にフォーマットを設定
     * @param f
     * @author kawae
     * @since 2004/11/17
    **/
    KTextLine.prototype.setFormat = function (f) {
        this.mTextElements.forEach(function (tl) { return tl.setFormat(f); });
    };
    /**
     * 要素群の取得
     * @return
     * @author kawae
     * @since 2004/11/14
    **/
    KTextLine.prototype.getElements = function () {
        return this.mTextElements;
    };
    /**
     * コピーインスタンスの取得
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    KTextLine.prototype.getCopy = function () {
        var c = new KTextLine();
        this.mTextElements.forEach(function (te) {
            return c.mTextElements.push(te.getCopy());
        });
        return c;
    };
    /**
     * 全てのテキスト要素の削除
     * @author kawae
     * @since 2004/11/15
    **/
    KTextLine.prototype.removeAll = function () {
        this.mTextElements.length = 0;
    };
    /**
     * テキストの追加
     * @param s
     * @param tf
     * @author kawae
     * @since 2004/11/17
    **/
    KTextLine.prototype.addText = function (s, tf) {
        var te = new KTextElement_1.KTextElement();
        te.setText(s);
        te.setFormat(tf);
        this.mTextElements.push(te);
    };
    /**
     * テキスト要素の追加
     * @param e
     * @author kawae
     * @since 2004/11/15
    **/
    KTextLine.prototype.addTextElement = function (e) {
        this.mTextElements.push(e);
    };
    KTextLine.prototype.getDescent = function (dpi) {
        var d = -1;
        for (var j = 0; j < this.mTextElements.length; j++) {
            var te = this.mTextElements[j];
            var tmp = te.getFont().getFontMetrics(null).getDescent();
            d = tmp > d ? tmp : d;
        }
        return dpi.getDpiScaleSize(d);
    };
    /**
     * 最大幅の取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/16
    **/
    KTextLine.prototype.getMaxWidth = function (hor, dpi) {
        var total = 0;
        if (hor) {
            for (var j = 0; j < this.mTextElements.length; j++) {
                var te = this.mTextElements[j];
                total += te.getMaxWidth(hor, dpi);
            }
        }
        else {
            for (var j = 0; j < this.mTextElements.length; j++) {
                var te = this.mTextElements[j];
                var tmpw = te.getMaxWidth(hor, dpi);
                total = total < tmpw ? tmpw : total;
            }
        }
        return total;
    };
    /**
     * 最大高さの取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/16
    **/
    KTextLine.prototype.getMaxHeight = function (hor, dpi) {
        var height = 0;
        if (hor) {
            for (var j = 0; j < this.mTextElements.length; j++) {
                var te = this.mTextElements[j];
                height = Math.max(height, te.getMaxHeight(hor, dpi));
            }
        }
        else {
            for (var j = 0; j < this.mTextElements.length; j++) {
                var te = this.mTextElements[j];
                height += te.getMaxHeight(hor, dpi);
            }
        }
        return height;
    };
    KTextLine.GEOMNAME = "TEXT_LINE";
    return KTextLine;
})();
exports.KTextLine = KTextLine;
//# sourceMappingURL=KTextLine.js.map