import { IRichGraphics } from 'kiteclib';
import { LocalAxis2Df } from '../LocalAxis2Df';
/**
 * ワークシートと描画順を分ける必要のあるオブジェクト
 * @author kawae
 * @since 2004/10/28
**/
export interface IDrawOrderByWorkSheetGeometry {
    /**
     * ワークシート描画前の描画メソッド
     * @param g
     * @author kawae
     * @since 2004/10/28
    **/
    drawAbstDevicePreWorkSheet(g: IRichGraphics, la: LocalAxis2Df): void;
    /**
     * ワークシート描画後の描画メソッド
     * @param g
     * @author kawae
     * @since 2004/10/28
    **/
    drawAbstDevicePostWorkSheet(g: IRichGraphics, la: LocalAxis2Df): void;
}
