var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Geometry_1 = require('./Geometry');
//module nethome.geom.primitive
/**
 * @author matsuzaki**/
var GScalableGeometry = (function (_super) {
    __extends(GScalableGeometry, _super);
    function GScalableGeometry() {
        _super.apply(this, arguments);
        /**
         * X方向へのスケーリングの許可 **/
        this.scaleEnX = false;
        /**
         * Y方向へのスケーリングの許可 **/
        this.scaleEnY = false;
        /**
         * アスペクト比一定のフラグ **/
        this.mKeepAspect = false;
        /**
         * スケーリングの基点X **/
        this.scaleBaseX = 0;
        /**
         * スケーリングの基点Y **/
        this.scaleBaseY = 0;
    }
    /**
     * コピーインスタンスの取得
     * 引数インスタンスに対し属性をコピーする
     * @param g　コピー属性設定対象オブジェクト
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    GScalableGeometry.prototype.copyTo = function (g) {
        if (g == null)
            return null;
        _super.prototype.copyTo.call(this, g);
        var s = (g);
        s.scaleEnX = this.scaleEnX;
        s.scaleEnY = this.scaleEnY;
        s.scaleBaseX = this.scaleBaseX;
        s.scaleBaseY = this.scaleBaseY;
        s.mKeepAspect = this.mKeepAspect;
        return g;
    };
    GScalableGeometry.prototype.isScaleEnX = function () {
        return this.scaleEnX;
    };
    GScalableGeometry.prototype.setScaleEnX = function (scaleEnX) {
        this.scaleEnX = scaleEnX;
    };
    GScalableGeometry.prototype.isScaleEnY = function () {
        return this.scaleEnY;
    };
    GScalableGeometry.prototype.setScaleEnY = function (scaleEnY) {
        this.scaleEnY = scaleEnY;
    };
    GScalableGeometry.prototype.getScaleBaseX = function () {
        return this.scaleBaseX;
    };
    GScalableGeometry.prototype.setScaleBaseX = function (scaleBaseX) {
        this.scaleBaseX = scaleBaseX;
    };
    GScalableGeometry.prototype.getScaleBaseY = function () {
        return this.scaleBaseY;
    };
    GScalableGeometry.prototype.setScaleBaseY = function (scaleBaseY) {
        this.scaleBaseY = scaleBaseY;
    };
    /**
     * アスペクト比を固定するか
     * @return the keepAspect
    **/
    GScalableGeometry.prototype.isKeepAspect = function () {
        return this.mKeepAspect;
    };
    /**
     * アスペクト比を固定するかどうかを設定
     * @param keepAspect the keepAspect to set
    **/
    GScalableGeometry.prototype.setKeepAspect = function (keepAspect) {
        this.mKeepAspect = keepAspect;
    };
    return GScalableGeometry;
})(Geometry_1.Geometry);
exports.GScalableGeometry = GScalableGeometry;
//# sourceMappingURL=GScalableGeometry.js.map