///<reference path='../../typings/bundle.d.ts' />
var kiteclib_1 = require('kiteclib');
var WorkSheet_1 = require('./WorkSheet');
//module nethome.geom
function equal(expect, actual, eps) {
    QUnit.ok(Math.abs(expect - actual) <= eps);
}
QUnit.test("testWorkSheet()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    QUnit.ok(true);
});
QUnit.test("testGetCopy()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setName("abc");
    ws.setModule(100);
    ws.setGridCenter(3, 5);
    ws.setGridDivide(10);
    ws.setArea(-100, -200, 600, 700);
    ws.addExtraGridX(0.5);
    ws.addExtraGridY(0.3);
    var ws2 = ws.getCopy();
    QUnit.equal(ws.getName(), ws2.getName());
    equal(ws.getModule(), ws2.getModule(), 0);
    QUnit.equal(ws.getGridDivide(), ws2.getGridDivide());
    equal(ws.getGridCenterX(), ws2.getGridCenterX(), 0);
    equal(ws.getGridCenterY(), ws2.getGridCenterY(), 0);
    QUnit.deepEqual([], ws2.getExtraGridX());
    QUnit.deepEqual([], ws2.getExtraGridY());
    QUnit.ok(ws.getArea().equals(ws2.getArea()));
    QUnit.equal(ws.getAreaPolygon().length, ws2.getAreaPolygon().length);
});
QUnit.test("testSetName()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setName("abc");
    QUnit.equal("abc", ws.getName());
});
QUnit.test("testGetName()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setName("abc");
    QUnit.equal("abc", ws.getName());
    ws.setName("c");
    QUnit.equal("c", ws.getName());
});
QUnit.test("testSetArea()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setArea(0, 0, 200, 300);
    var area = ws.getArea();
    equal(0, area.minX, 0);
    equal(0, area.minY, 0);
    equal(200, area.maxX, 0);
    equal(300, area.maxY, 0);
});
QUnit.test("testGetArea()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setArea(0, 0, 200, 300);
    var area = ws.getArea();
    equal(0, area.minX, 0);
    equal(0, area.minY, 0);
    equal(200, area.maxX, 0);
    equal(300, area.maxY, 0);
});
QUnit.test("testUpdateArea()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setArea(0, 0, 200, 300);
    ws.getArea().updateMinMax(-100, -100);
    ws.updateArea();
    var area = ws.getArea();
    equal(0, area.minX, 0);
    equal(0, area.minY, 0);
    equal(200, area.maxX, 0);
    equal(300, area.maxY, 0);
});
QUnit.test("testGetAreaPolygon()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setArea(0, 0, 200, 300);
    var areaPolygon = ws.getAreaPolygon();
    var p;
    p = areaPolygon[0];
    equal(0, p.x, 0);
    equal(0, p.y, 0);
    p = areaPolygon[1];
    equal(200, p.x, 0);
    equal(0, p.y, 0);
    p = areaPolygon[2];
    equal(200, p.x, 0);
    equal(300, p.y, 0);
    p = areaPolygon[3];
    equal(0, p.x, 0);
    equal(300, p.y, 0);
});
QUnit.test("testGetModule()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setModule(100.0);
    equal(100.0, ws.getModule(), 0);
});
QUnit.test("testSetModule()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setModule(100.0);
    ws.setModule(0.0);
    try {
        ws.setModule(-10.0);
        QUnit.ok(false);
    }
    catch (e) {
        QUnit.ok(true);
    }
    QUnit.expect(1);
});
QUnit.test("testSetGridDivide()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(100);
    ws.setGridDivide(10);
    try {
        ws.setGridDivide(0);
        QUnit.ok(false);
    }
    catch (e) {
        QUnit.ok(true);
    }
    try {
        ws.setGridDivide(-1);
        QUnit.ok(false);
    }
    catch (e) {
        QUnit.ok(true);
    }
    QUnit.expect(2);
});
QUnit.test("testGetGridDivide()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(100);
    QUnit.equal(100, ws.getGridDivide());
    ws.setGridDivide(10);
    QUnit.equal(10, ws.getGridDivide());
});
QUnit.test("testGetCurrentGrid()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    equal(10, ws.getCurrentGrid(), 0.1);
    ws.setModule(1000.0);
    equal(100, ws.getCurrentGrid(), 0.1);
});
QUnit.test("testSetGridCenter()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridCenter(0.0, 0.0);
    ws.setGridCenter(0.0, 100.0);
    QUnit.ok(true);
});
QUnit.test("testGetGridCenterX()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridCenter(0.0, 0.0);
    equal(0.0, ws.getGridCenterX(), 0.1);
    ws.setGridCenter(100.0, 0.0);
    equal(100.0, ws.getGridCenterX(), 0.1);
});
QUnit.test("testGetGridCenterY()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridCenter(0.0, 0.0);
    equal(0.0, ws.getGridCenterY(), 0.1);
    ws.setGridCenter(200.0, 100.0);
    equal(100.0, ws.getGridCenterY(), 0.1);
});
QUnit.test("testGetNearGridX()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(2.5, 2.5);
    equal(2.5, ws.getNearGridX(0.0, true), 0.1);
    equal(12.5, ws.getNearGridX(9.0, true), 0.1);
    equal(92.5, ws.getNearGridX(89.0, true), 0.1);
    equal(2.5, ws.getNearGridX(0.0, false), 0.1);
    equal(12.5, ws.getNearGridX(9.0, false), 0.1);
    equal(92.5, ws.getNearGridX(89.0, false), 0.1);
    equal(9000002.5, ws.getNearGridX(9000000.0, true), 1.0);
    equal(9000002.5, ws.getNearGridX(9000000.0, false), 1.0);
    ws.addExtraGridX(4.2);
    equal(2.5, ws.getNearGridX(0.0, true), 0.1);
    equal(4.2, ws.getNearGridX(4.0, true), 0.1);
    equal(12.5, ws.getNearGridX(9.0, true), 0.1);
    equal(2.5, ws.getNearGridX(0.0, false), 0.1);
    equal(2.5, ws.getNearGridX(4.0, false), 0.1);
    equal(12.5, ws.getNearGridX(9.0, false), 0.1);
    ws.setModule(0);
    equal(0.0, ws.getNearGridX(0.0, true), 0);
    equal(9.0, ws.getNearGridX(9.0, true), 0);
    equal(89.0, ws.getNearGridX(89.0, true), 0);
    equal(0.0, ws.getNearGridX(0.0, false), 0);
    equal(9.0, ws.getNearGridX(9.0, false), 0);
    equal(89.0, ws.getNearGridX(89.0, false), 0);
    ws.getNearGridX(Number.POSITIVE_INFINITY, true);
    ws.getNearGridX(Number.NEGATIVE_INFINITY, true);
    ws.getNearGridX(Number.NaN, true);
    ws.getNearGridX(Number.POSITIVE_INFINITY, false);
    ws.getNearGridX(Number.NEGATIVE_INFINITY, false);
    ws.getNearGridX(Number.NaN, false);
});
QUnit.test("testGetNearGridY()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(2.5, 2.5);
    equal(2.5, ws.getNearGridY(0.0, true), 0.1);
    equal(12.5, ws.getNearGridY(9.0, true), 0.1);
    equal(92.5, ws.getNearGridY(89.0, true), 0.1);
    equal(2.5, ws.getNearGridY(0.0, false), 0.1);
    equal(12.5, ws.getNearGridY(9.0, false), 0.1);
    equal(92.5, ws.getNearGridY(89.0, false), 0.1);
    equal(9000002.5, ws.getNearGridY(9000000.0, true), 1.0);
    equal(9000002.5, ws.getNearGridY(9000000.0, false), 1.0);
    ws.addExtraGridY(4.2);
    equal(2.5, ws.getNearGridY(0.0, true), 0.1);
    equal(4.2, ws.getNearGridY(4.0, true), 0.1);
    equal(12.5, ws.getNearGridY(9.0, true), 0.1);
    equal(2.5, ws.getNearGridY(0.0, false), 0.1);
    equal(2.5, ws.getNearGridY(4.0, false), 0.1);
    equal(12.5, ws.getNearGridY(9.0, false), 0.1);
    ws.setModule(0);
    equal(0.0, ws.getNearGridY(0.0, true), 0);
    equal(9.0, ws.getNearGridY(9.0, true), 0);
    equal(89.0, ws.getNearGridY(89.0, true), 0);
    equal(0.0, ws.getNearGridY(0.0, false), 0);
    equal(9.0, ws.getNearGridY(9.0, false), 0);
    equal(89.0, ws.getNearGridY(89.0, false), 0);
    ws.getNearGridY(Number.POSITIVE_INFINITY, true);
    ws.getNearGridY(Number.NEGATIVE_INFINITY, true);
    ws.getNearGridY(Number.NaN, true);
    ws.getNearGridY(Number.POSITIVE_INFINITY, false);
    ws.getNearGridY(Number.NEGATIVE_INFINITY, false);
    ws.getNearGridY(Number.NaN, false);
});
QUnit.test("testGetDefNearGridX()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(2.5, 2.5);
    equal(0.0, ws.getDefNearGridX(0.0), 0.1);
    equal(10.0, ws.getDefNearGridX(9.1), 0.1);
    equal(88.0, ws.getDefNearGridX(87.5), 0.1);
    equal(9000000.0, ws.getDefNearGridX(9000000.0), 1.0);
    ws.addExtraGridX(4.2);
    equal(0.0, ws.getDefNearGridX(0.0), 0.1);
    equal(4.0, ws.getDefNearGridX(4.15), 0.1);
    equal(10.0, ws.getDefNearGridX(9.5), 0.1);
    ws.getDefNearGridX(Number.POSITIVE_INFINITY);
    ws.getDefNearGridX(Number.NEGATIVE_INFINITY);
    ws.getDefNearGridX(Number.NaN);
});
QUnit.test("testGetDefNearGridY()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(2.5, 2.5);
    equal(0.0, ws.getDefNearGridY(0.0), 0.1);
    equal(10.0, ws.getDefNearGridY(9.1), 0.1);
    equal(88.0, ws.getDefNearGridY(87.5), 0.1);
    equal(9000000.0, ws.getDefNearGridY(9000000.0), 1.0);
    ws.addExtraGridY(4.2);
    equal(0.0, ws.getDefNearGridY(0.0), 0.1);
    equal(4.0, ws.getDefNearGridY(4.15), 0.1);
    equal(10.0, ws.getDefNearGridY(9.5), 0.1);
    ws.getDefNearGridY(Number.POSITIVE_INFINITY);
    ws.getDefNearGridY(Number.NEGATIVE_INFINITY);
    ws.getDefNearGridY(Number.NaN);
});
QUnit.test("testIsOnGridX()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(2.5, 0.0);
    QUnit.equal(true, ws.isOnGridX(2.5));
    QUnit.equal(true, ws.isOnGridX(22.5));
    QUnit.equal(true, ws.isOnGridX(102.5));
    QUnit.equal(true, ws.isOnGridX(-287.5));
    QUnit.equal(false, ws.isOnGridX(0.0));
    QUnit.equal(false, ws.isOnGridX(90.0));
    QUnit.equal(false, ws.isOnGridX(4.2));
    ws.addExtraGridX(4.2);
    QUnit.equal(true, ws.isOnGridX(2.5));
    QUnit.equal(false, ws.isOnGridX(4.0));
    QUnit.equal(true, ws.isOnGridX(4.2));
    ws.setModule(0);
    QUnit.equal(true, ws.isOnGridX(0.0));
    QUnit.equal(true, ws.isOnGridX(9.0));
    QUnit.equal(true, ws.isOnGridX(89.0));
});
QUnit.test("testIsOnGridY()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(0.0, 2.5);
    QUnit.equal(true, ws.isOnGridY(2.5));
    QUnit.equal(true, ws.isOnGridY(22.5));
    QUnit.equal(true, ws.isOnGridY(102.5));
    QUnit.equal(true, ws.isOnGridY(-287.5));
    QUnit.equal(false, ws.isOnGridY(0.0));
    QUnit.equal(false, ws.isOnGridY(90.0));
    QUnit.equal(false, ws.isOnGridY(4.2));
    ws.addExtraGridY(4.2);
    QUnit.equal(true, ws.isOnGridY(2.5));
    QUnit.equal(false, ws.isOnGridY(4.0));
    QUnit.equal(true, ws.isOnGridY(4.2));
    ws.setModule(0);
    QUnit.equal(true, ws.isOnGridY(0.0));
    QUnit.equal(true, ws.isOnGridY(9.0));
    QUnit.equal(true, ws.isOnGridY(89.0));
});
QUnit.test("testIsOnBaseGridX()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(2.5, 0.0);
    QUnit.equal(true, ws.isOnBaseGridX(0.0));
    QUnit.equal(true, ws.isOnBaseGridX(100.0));
    QUnit.equal(true, ws.isOnBaseGridX(100.0 + kiteclib_1.MathUtil.EPS / 10));
    QUnit.equal(true, ws.isOnBaseGridX(100.0 - kiteclib_1.MathUtil.EPS / 10));
    QUnit.equal(true, ws.isOnBaseGridX(10000.0));
    QUnit.equal(true, ws.isOnBaseGridX(-300.0));
    QUnit.equal(false, ws.isOnBaseGridX(2.5));
    QUnit.equal(false, ws.isOnBaseGridX(10.0));
    QUnit.equal(false, ws.isOnBaseGridX(50.0));
    QUnit.equal(false, ws.isOnBaseGridX(-10.0));
    QUnit.equal(false, ws.isOnBaseGridX(4.2));
    ws.addExtraGridX(4.2);
    QUnit.equal(true, ws.isOnBaseGridX(0.0));
    QUnit.equal(false, ws.isOnBaseGridX(4.2));
});
QUnit.test("testIsOnBaseGridY()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(0.0, 2.5);
    QUnit.equal(true, ws.isOnBaseGridY(0.0));
    QUnit.equal(true, ws.isOnBaseGridY(100.0));
    QUnit.equal(true, ws.isOnBaseGridY(100.0 + kiteclib_1.MathUtil.EPS / 10));
    QUnit.equal(true, ws.isOnBaseGridY(100.0 - kiteclib_1.MathUtil.EPS / 10));
    QUnit.equal(true, ws.isOnBaseGridY(10000.0));
    QUnit.equal(true, ws.isOnBaseGridY(-300.0));
    QUnit.equal(false, ws.isOnBaseGridY(2.5));
    QUnit.equal(false, ws.isOnBaseGridY(10.0));
    QUnit.equal(false, ws.isOnBaseGridY(50.0));
    QUnit.equal(false, ws.isOnBaseGridY(-10.0));
    QUnit.equal(false, ws.isOnBaseGridY(4.2));
    ws.addExtraGridY(4.2);
    QUnit.equal(true, ws.isOnBaseGridY(0.0));
    QUnit.equal(false, ws.isOnBaseGridY(4.2));
});
QUnit.test("testGetNearGridX2()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(2.5, 0.0);
    equal(-107.5, ws.getNearGridX2(-108.0, true), 0.1);
    equal(-7.5, ws.getNearGridX2(-10.0, true), 0.1);
    equal(2.5, ws.getNearGridX2(0.0, true), 0.1);
    equal(2.5, ws.getNearGridX2(2.8, true), 0.1);
    equal(12.5, ws.getNearGridX2(2.9, true), 0.1);
    equal(12.5, ws.getNearGridX2(9.0, true), 0.1);
    equal(92.5, ws.getNearGridX2(83.0, true), 0.1);
    equal(9000002.5, ws.getNearGridX2(9000000.0, true), 1.0);
    equal(900000002.5, ws.getNearGridX2(900000000, true), 1);
    equal(-117.5, ws.getNearGridX2(-108.0, false), 0.1);
    equal(-17.5, ws.getNearGridX2(-10.0, false), 0.1);
    equal(-7.5, ws.getNearGridX2(0.0, false), 0.1);
    equal(-7.5, ws.getNearGridX2(2.1, false), 0.1);
    equal(2.5, ws.getNearGridX2(2.4, false), 0.1);
    equal(2.5, ws.getNearGridX2(2.9, false), 0.1);
    equal(2.5, ws.getNearGridX2(9.0, false), 0.1);
    equal(82.5, ws.getNearGridX2(83.0, false), 0.1);
    equal(9000002.5, ws.getNearGridX2(9000003.0, false), 1.0);
    equal(900000002.5, ws.getNearGridX2(900000003, false), 1);
    ws.addExtraGridX(4.2);
    equal(2.5, ws.getNearGridX2(0.0, true), 0.1);
    equal(4.2, ws.getNearGridX2(4.0, true), 0.1);
    equal(2.5, ws.getNearGridX2(2.83, true), 0.1);
    equal(4.2, ws.getNearGridX2(2.84, true), 0.1);
    equal(12.5, ws.getNearGridX2(9.0, true), 0.1);
    equal(-7.5, ws.getNearGridX2(0.0, false), 0.1);
    equal(-7.5, ws.getNearGridX2(2.1, false), 0.1);
    equal(2.5, ws.getNearGridX2(2.2, false), 0.1);
    equal(2.5, ws.getNearGridX2(2.83, false), 0.1);
    equal(4.2, ws.getNearGridX2(4.0, false), 0.1);
    ws.setModule(0);
    equal(0.0, ws.getNearGridX2(0.0, true), 0);
    equal(9.0, ws.getNearGridX2(9.0, true), 0);
    equal(89.0, ws.getNearGridX2(89.0, true), 0);
    equal(0.0, ws.getNearGridX2(0.0, false), 0);
    equal(9.0, ws.getNearGridX2(9.0, false), 0);
    equal(89.0, ws.getNearGridX2(89.0, false), 0);
    ws.getNearGridX2(Number.POSITIVE_INFINITY, true);
    ws.getNearGridX2(Number.NEGATIVE_INFINITY, true);
    ws.getNearGridX2(Number.NaN, true);
    ws.getNearGridX2(Number.POSITIVE_INFINITY, false);
    ws.getNearGridX2(Number.NEGATIVE_INFINITY, false);
    ws.getNearGridX2(Number.NaN, false);
});
QUnit.test("testGetNearGridY2()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(0.0, 2.5);
    equal(-107.5, ws.getNearGridY2(-108.0, true), 0.1);
    equal(-7.5, ws.getNearGridY2(-10.0, true), 0.1);
    equal(2.5, ws.getNearGridY2(0.0, true), 0.1);
    equal(2.5, ws.getNearGridY2(2.8, true), 0.1);
    equal(12.5, ws.getNearGridY2(2.9, true), 0.1);
    equal(12.5, ws.getNearGridY2(9.0, true), 0.1);
    equal(92.5, ws.getNearGridY2(83.0, true), 0.1);
    equal(9000002.5, ws.getNearGridY2(9000000.0, true), 1.0);
    equal(900000002.5, ws.getNearGridY2(900000000, true), 1);
    equal(-117.5, ws.getNearGridY2(-108.0, false), 0.1);
    equal(-17.5, ws.getNearGridY2(-10.0, false), 0.1);
    equal(-7.5, ws.getNearGridY2(0.0, false), 0.1);
    equal(-7.5, ws.getNearGridY2(2.1, false), 0.1);
    equal(2.5, ws.getNearGridY2(2.4, false), 0.1);
    equal(2.5, ws.getNearGridY2(2.9, false), 0.1);
    equal(2.5, ws.getNearGridY2(9.0, false), 0.1);
    equal(82.5, ws.getNearGridY2(83.0, false), 0.1);
    equal(9000002.5, ws.getNearGridY2(9000003.0, false), 1.0);
    equal(900000002.5, ws.getNearGridY2(900000003, false), 1);
    ws.addExtraGridY(4.2);
    equal(2.5, ws.getNearGridY2(0.0, true), 0.1);
    equal(4.2, ws.getNearGridY2(4.0, true), 0.1);
    equal(2.5, ws.getNearGridY2(2.83, true), 0.1);
    equal(4.2, ws.getNearGridY2(2.84, true), 0.1);
    equal(12.5, ws.getNearGridY2(9.0, true), 0.1);
    equal(-7.5, ws.getNearGridY2(0.0, false), 0.1);
    equal(-7.5, ws.getNearGridY2(2.1, false), 0.1);
    equal(2.5, ws.getNearGridY2(2.2, false), 0.1);
    equal(2.5, ws.getNearGridY2(2.83, false), 0.1);
    equal(4.2, ws.getNearGridY2(4.0, false), 0.1);
    ws.setModule(0);
    equal(0.0, ws.getNearGridY2(0.0, true), 0);
    equal(9.0, ws.getNearGridY2(9.0, true), 0);
    equal(89.0, ws.getNearGridY2(89.0, true), 0);
    equal(0.0, ws.getNearGridY2(0.0, false), 0);
    equal(9.0, ws.getNearGridY2(9.0, false), 0);
    equal(89.0, ws.getNearGridY2(89.0, false), 0);
    ws.getNearGridY2(Number.POSITIVE_INFINITY, true);
    ws.getNearGridY2(Number.NEGATIVE_INFINITY, true);
    ws.getNearGridY2(Number.NaN, true);
    ws.getNearGridY2(Number.POSITIVE_INFINITY, false);
    ws.getNearGridY2(Number.NEGATIVE_INFINITY, false);
    ws.getNearGridY2(Number.NaN, false);
});
QUnit.test("testGetNearNotExtraGrid()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    QUnit.equal(-90, ws.getNearNotExtraGrid(-900.0, 2.5, 10.0));
    QUnit.equal(0, ws.getNearNotExtraGrid(0.0, 2.5, 10.0));
    QUnit.equal(1, ws.getNearNotExtraGrid(9.0, 2.5, 10.0));
    QUnit.equal(9, ws.getNearNotExtraGrid(89.0, 2.5, 10.0));
    QUnit.equal(9, ws.getNearNotExtraGrid(90.0, 2.5, 10.0));
    QUnit.equal(90, ws.getNearNotExtraGrid(900.0, 2.5, 10.0));
    QUnit.equal(900000, ws.getNearNotExtraGrid(9000000.0, 2.5, 10.0));
    QUnit.equal(90000000, ws.getNearNotExtraGrid(900000000.0, 2.5, 10.0));
    QUnit.equal(0, ws.getNearNotExtraGrid(100.0, 100.0, 10.0));
    QUnit.equal(10, ws.getNearNotExtraGrid(200.0, 100.0, 10.0));
    ws.addExtraGridX(4.2);
    QUnit.equal(0, ws.getNearNotExtraGrid(0.0, 2.5, 10.0));
    QUnit.equal(0, ws.getNearNotExtraGrid(4.0, 2.5, 10.0));
    QUnit.equal(1, ws.getNearNotExtraGrid(9.0, 2.5, 10.0));
    ws.getNearNotExtraGrid(Number.POSITIVE_INFINITY, 0.0, 10.0);
    ws.getNearNotExtraGrid(Number.NEGATIVE_INFINITY, 0.0, 10.0);
    ws.getNearNotExtraGrid(Number.NaN, 0.0, 10);
});
QUnit.test("testAddExtraGridX()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(0.0, 0.0);
    QUnit.deepEqual([], ws.getExtraGridX());
    QUnit.equal(true, ws.addExtraGridX(5));
    QUnit.equal(1, ws.getExtraGridX().length);
    QUnit.equal(true, ws.addExtraGridX(2.5));
    QUnit.equal(2, ws.getExtraGridX().length);
    QUnit.equal(false, ws.addExtraGridX(10));
    QUnit.equal(2, ws.getExtraGridX().length);
    QUnit.equal(false, ws.addExtraGridX(5));
    QUnit.equal(2, ws.getExtraGridX().length);
    //QUnit.equal(false, ws.addExtraGridX(Math.nextAfter(5, 1)));
    QUnit.equal(2, ws.getExtraGridX().length);
    //QUnit.equal(false, ws.addExtraGridX(Math.nextAfter(5, -1)));
    QUnit.equal(2, ws.getExtraGridX().length);
});
QUnit.test("testAddExtraGridY()", function () {
    var ws = new WorkSheet_1.WorkSheet();
    ws.setGridDivide(10);
    ws.setModule(100.0);
    ws.setGridCenter(0.0, 0.0);
    QUnit.deepEqual([], ws.getExtraGridY());
    QUnit.equal(true, ws.addExtraGridY(5));
    QUnit.equal(1, ws.getExtraGridY().length);
    QUnit.equal(true, ws.addExtraGridY(2.5));
    QUnit.equal(2, ws.getExtraGridY().length);
    QUnit.equal(false, ws.addExtraGridY(10));
    QUnit.equal(2, ws.getExtraGridY().length);
    QUnit.equal(false, ws.addExtraGridY(5));
    QUnit.equal(2, ws.getExtraGridY().length);
    //QUnit.equal(false, ws.addExtraGridY(Math.nextAfter(5, 1)));
    QUnit.equal(2, ws.getExtraGridY().length);
    //QUnit.equal(false, ws.addExtraGridY(Math.nextAfter(5, -1)));
    QUnit.equal(2, ws.getExtraGridY().length);
});
//# sourceMappingURL=WorkSheetTest.js.map