import { ObjectFolder } from 'kiteclib';
import { SymbolAttribute } from './SymbolAttribute';
/**
 * シンボルの属性コレクション
 * @author kawae
**/
export declare class SymbolAttributeCollection {
    /**
     * 属性のコレクション **/
    mAttributes: Array<SymbolAttribute>;
    /**
     * コンストラクタ**/
    constructor();
    /**
     * コピーの取得
     * @return
    **/
    getCopy(): SymbolAttributeCollection;
    /**
     * 属性の追加
     * @param key
     * @param val
    **/
    addAttribute(key: string, val: string, copybuffer: boolean): void;
    /**
     * アトリビュートの設定
     * @param sa
    **/
    addAttribute(sa: SymbolAttribute): void;
    /**
     * アトリビュートの取得
     * @param key
     * @return
    **/
    getAttributes(): Array<SymbolAttribute>;
    /**
     * キーが存在するか
     * @param key
     * @return
    **/
    hasAttribute(key: string): boolean;
    /**
     * キーの削除
     * @param key
    **/
    getAttribute(key: string): SymbolAttribute;
    /**
     * キーの削除
     * @param key
    **/
    removeAttributeKey(key: string): void;
    /**
     * キーの削除
     * @param key
    **/
    removeAttribute(sa: SymbolAttribute): void;
    /**
     * 保存
     * @param w
     * @param space
     * @throws Exception
    **/
    save(savenode: ObjectFolder): void;
}
