import { GLine } from './primitive/GLine';
import { Ltype } from './Ltype';
/**
 * <p>タイトル: </p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2001</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
**/
export declare class HatchPattern {
    /**
     * 最大・最小にフィットパターン **/
    static MINMAXFIT: number;
    /**
     * 指定された間隔でフィットパターン **/
    static INTERVALFIT: number;
    /**
     * 対象の部屋に対してサイズ依存であるものパターン **/
    static SIZEDEPEND: number;
    /**
     * サブタイプリストから自動的に適合するものを選択する。 **/
    static SUBTYPESIZE: number;
    /**
     * ハッチ名 **/
    mName: string;
    /**
     * グループ名 **/
    mGroupName: string[];
    /**
     * ｘ方向無限ライン **/
    mInfinityX: number[];
    /**
     * ｙ方向無限ライン **/
    mInfinityY: number[];
    /**
     * ライン **/
    mLines: GLine[];
    /**
     * 畳数 **/
    mDisplaySize: number;
    /**
     * サイクル **/
    mCycleX: number;
    mCycleY: number;
    /**
     * 最大・最小（無限パターンは除く) **/
    mMinX: number;
    mMaxX: number;
    mMinY: number;
    mMaxY: number;
    /**
     * フィットパターン **/
    mFitPattern: number;
    /**
     * 対象ポリゴンに対する内向きオフセット **/
    mOffsetToInside: number;
    /**
     * ポリゴン領域を追加するかのフラグ　**/
    mFrameLine: boolean;
    /**
     * ラインタイプ **/
    mLtype: Ltype;
    /**
     * スムースモード（平行なものに段差を付けないか **/
    mSmooth: boolean;
    /**
     * サブタイプ **/
    mSubTypes: number[][];
    /**
     * コンストラクタ
     * @param fitpattern	フィットするパターン
     * @param cycx	x方向の周期
     * @param cycy	y方向の周期
    **/
    constructor(group: string[]);
    /**
     * サブタイプの取得**/
    getSubTypes(): any[];
    addSubType(x: number, y: number, w: number, h: number): void;
    getSubtype(w: number, h: number): number[];
    setGroup(s: string[]): void;
    getGroupName(): string[];
    setName(s: string): void;
    getName(): string;
    setArea(f: number): void;
    getArea(): number;
    /**
     * フィットパターンの設定**/
    setFitPattern(fitpattern: number): void;
    /**
     * サイクルの指定**/
    setCycle(cycx: number, cycy: number): void;
    /**
     * スムースモードの設定**/
    setSmooth(b: boolean): void;
    /**
     * スムースモードの取得**/
    getSmooth(): boolean;
    /**
     * 最大・最小領域の設定**/
    setMinMax(xmin: number, ymin: number, xmax: number, ymax: number): void;
    /**
     * ｘ方向無限ライン追加**/
    addInfinityX(x: number): void;
    /**
     * ｙ方向無限ライン追加**/
    addInfinityY(y: number): void;
    /**
     * 線追加**/
    addLine(x1: number, y1: number, x2: number, y2: number): void;
    addMinMaxLine(): void;
}
