var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var kiteclib_1 = require('kiteclib');
var NethomeCoreResource_1 = require('../NethomeCoreResource');
var Geometry_1 = require('./primitive/Geometry');
var GPoint2Df_1 = require('./primitive/GPoint2Df');
var GText_1 = require('./primitive/GText');
//module nethome.geom
var GTextGroup = (function (_super) {
    __extends(GTextGroup, _super);
    /**
     * コンストラクタ
     * @param p1
     * @param scaleFontLabel
     * @param angl
     * @param size
    **/
    function GTextGroup(p1, scaleFontLabel, angl, size) {
        _super.call(this);
        /**
         * 描画方向 (true:横) **/
        this.mDir = true;
        this.mBackFill = false;
        this.mCp = new GPoint2Df_1.GPoint2Df(p1.x, p1.y);
        this.mAngl = angl;
        this.mScaleFont = scaleFontLabel;
        this.mTexts = new Array();
        this.mSize = size;
    }
    /**
     * 描画方向の設定**/
    GTextGroup.prototype.setDir = function (dir) {
        this.mDir = dir;
    };
    GTextGroup.prototype.setBackColor = function (fill, c) {
        this.mBackFill = fill;
        this.mFillColor = c;
    };
    /**
     * テキストの個数の取得**/
    GTextGroup.prototype.getTextSize = function () {
        return this.mTexts.length;
    };
    GTextGroup.prototype.update = function () {
        for (var _i = 0, _a = this.mTexts; _i < _a.length; _i++) {
            var gt = _a[_i];
            gt.setFillMode(this.mBackFill, this.mFillColor);
        }
        if (this.mDir) {
            var toth = 0;
            for (var _b = 0, _c = this.mTexts; _b < _c.length; _b++) {
                var gt = _c[_b];
                gt.update();
                toth += (gt.mMaxy - gt.mMiny);
            }
            var y = 0;
            for (var i = 0; i < this.mTexts.length; i++) {
                var gt = this.mTexts[i];
                if (i == 0)
                    y = this.mCp.y + toth / 2;
                gt.mAngl = this.mAngl;
                gt.mCp.x = this.mCp.x;
                gt.mCp.y = y - (gt.mMaxy - gt.mMiny) / 2;
                y = y - (gt.mMaxy - gt.mMiny);
            }
        }
        else {
            var totw = 0;
            for (var i = 0; i < this.mTexts.length; i++) {
                var gt = this.mTexts[i];
                gt.setDir(this.mDir);
                gt.update();
                totw += (gt.mMaxx - gt.mMinx);
            }
            var x = 0;
            for (var i = 0; i < this.mTexts.length; i++) {
                var gt = this.mTexts[i];
                gt.mAngl = this.mAngl;
                gt.mCp.y = this.mCp.y;
                if (NethomeCoreResource_1.NethomeCoreResource.TATEGAKI_DIR) {
                    if (i == 0)
                        x = this.mCp.x - totw / 2;
                    gt.mCp.x = x + (gt.mMaxx - gt.mMinx) / 2;
                    x = x + (gt.mMaxx - gt.mMinx);
                }
                else {
                    if (i == 0)
                        x = this.mCp.x + totw / 2;
                    gt.mCp.x = x - (gt.mMaxx - gt.mMinx) / 2;
                    x = x - (gt.mMaxx - gt.mMinx);
                }
            }
        }
    };
    GTextGroup.prototype.addText = function (s, size, bold) {
        if (s == null || s.length == 0)
            return;
        var gt = new GText_1.GText(new GPoint2Df_1.GPoint2Df(), this.mScaleFont, s, 0, size, bold);
        this.mTexts.push(gt);
        this.update();
    };
    /**
     * 全テキストの削除**/
    GTextGroup.prototype.removeAll = function () {
        this.mTexts.length = 0;
    };
    GTextGroup.prototype.getDistanceToPoint = function (x, y) {
        return kiteclib_1.MathUtil.getLength2D(x, y, this.mCp.x, this.mCp.y);
    };
    GTextGroup.prototype.offset = function (x, y) {
        this.mCp.x += x;
        this.mCp.y += y;
    };
    /**
     * 横反転**/
    GTextGroup.prototype.flipx = function (x, ofsx) {
    };
    /**
     * 縦反転**/
    GTextGroup.prototype.flipy = function (y, ofsy) {
    };
    //static readData(r: AbstFile, version: number): Object /*Exception*/ {
    //    return null;
    //}
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, KColor.BLACK, null);
    //}
    GTextGroup.prototype.drawGeom = function (d, fore, back) {
        for (var i = 0; i < this.mTexts.length; i++) {
            var gt = this.mTexts[i];
            gt.drawGeom(d, fore, back);
        }
    };
    return GTextGroup;
})(Geometry_1.Geometry);
exports.GTextGroup = GTextGroup;
//# sourceMappingURL=GTextGroup.js.map