///<reference path='../../typings/bundle.d.ts' />
//import { java } from '../../tsconv'
var kiteclib_1 = require('kiteclib');
var GLine_1 = require('../geom/primitive/GLine');
var WorkSheet_1 = require('../geom/WorkSheet');
var Layer_1 = require('./Layer');
//module nethome.doc
QUnit.test("testLayerWorkSheet()", function () {
    new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    QUnit.ok(true);
});
QUnit.test("testLayerStringWorkSheet()", function () {
    new Layer_1.Layer(new WorkSheet_1.WorkSheet(), "name");
    QUnit.ok(true);
});
QUnit.test("testSetName_GetNage()", function () {
    var l = new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    l.setName("hoge");
    QUnit.equal("hoge", l.getName());
    l.setName("abc");
    QUnit.equal("abc", l.getName());
});
//QUnit.test("testSetWorkSheet()", function () {
//});
//QUnit.test("testGetWorkSheet()", function () {
//});
//QUnit.test("testGetViewPort()", function () {
//});
QUnit.test("testRenumberID()", function () {
    var l = new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    l.renumberID();
    var g0 = new GLine_1.GLine();
    var g1 = new GLine_1.GLine();
    var g2 = new GLine_1.GLine();
    l.addPrimitive(g0);
    l.addPrimitive(g1);
    l.addPrimitive(g2);
    l.renumberID();
    QUnit.equal(1, g0.getID());
    QUnit.equal(2, g1.getID());
    QUnit.equal(3, g2.getID());
});
QUnit.test("testSave()", function () {
    var l = new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    var g0 = new GLine_1.GLine();
    var g1 = new GLine_1.GLine();
    var g2 = new GLine_1.GLine();
    l.addPrimitive(g0);
    l.addPrimitive(g1);
    l.addPrimitive(g2);
    l.renumberID();
    var of = new kiteclib_1.ObjectFolder();
    l.save(of);
    QUnit.equal(of.getName(), "LAYER");
    QUnit.equal(of.getChildren().length, 4);
});
QUnit.test("testAddSelectBuffer()", function () {
    var l = new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    var g0 = new GLine_1.GLine();
    var g1 = new GLine_1.GLine();
    var g2 = new GLine_1.GLine();
    QUnit.equal(0, l.getSelectBuffer().length);
    l.addSelectBuffer(g0, false);
    QUnit.equal(0, l.getSelectBuffer().length);
    QUnit.ok(l.getSelectBuffer().indexOf(g0) < 0);
    l.addPrimitive(g0);
    l.addPrimitive(g1);
    l.addPrimitive(g2);
    l.addSelectBuffer(g0, false);
    QUnit.equal(1, l.getSelectBuffer().length);
    QUnit.ok(l.getSelectBuffer().indexOf(g0) >= 0);
    l.addSelectBuffer(g0, false);
    QUnit.equal(1, l.getSelectBuffer().length);
    QUnit.ok(l.getSelectBuffer().indexOf(g0) >= 0);
    l.addSelectBuffer(g0, true);
    l.addSelectBuffer(g1, true);
    QUnit.equal(1, l.getSelectBuffer().length);
    QUnit.ok(l.getSelectBuffer().indexOf(g1) >= 0);
    l.addSelectBuffer(g0, false);
    l.addSelectBuffer(g1, false);
    l.addSelectBuffer(g0, false);
    l.addSelectBuffer(g0, false);
    QUnit.equal(2, l.getSelectBuffer().length);
    QUnit.ok(l.getSelectBuffer().indexOf(g0) >= 0);
    QUnit.ok(l.getSelectBuffer().indexOf(g1) >= 0);
});
QUnit.test("testClearSelectBuffer()", function () {
    var l = new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    var g0 = new GLine_1.GLine();
    var g1 = new GLine_1.GLine();
    var g2 = new GLine_1.GLine();
    l.addPrimitive(g0);
    l.addPrimitive(g1);
    l.addPrimitive(g2);
    l.addSelectBuffer(g0, false);
    l.addSelectBuffer(g1, false);
    l.addSelectBuffer(g2, false);
    QUnit.equal(3, l.getSelectBuffer().length);
    l.clearSelectBuffer();
    QUnit.equal(0, l.getSelectBuffer().length);
});
QUnit.test("testGetSelectBuffer()", function () {
    var l = new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    var g0 = new GLine_1.GLine();
    var g1 = new GLine_1.GLine();
    var g2 = new GLine_1.GLine();
    l.addPrimitive(g0);
    l.addPrimitive(g1);
    l.addPrimitive(g2);
    l.addSelectBuffer(g0, false);
    l.addSelectBuffer(g1, false);
    l.addSelectBuffer(g2, false);
    QUnit.equal(3, l.getSelectBuffer().length);
    QUnit.equal(g0, l.getSelectBuffer()[0]);
    QUnit.equal(g1, l.getSelectBuffer()[1]);
    QUnit.equal(g2, l.getSelectBuffer()[2]);
});
QUnit.test("testSortSelectBuffer()", function () {
    var l = new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    var g0 = new GLine_1.GLine();
    var g1 = new GLine_1.GLine();
    var g2 = new GLine_1.GLine();
    l.addPrimitive(g0);
    l.addPrimitive(g1);
    l.addPrimitive(g2);
    l.addSelectBuffer(g0, false);
    l.addSelectBuffer(g1, false);
    l.addSelectBuffer(g2, false);
    l.removePrimitive(g0);
    l.removePrimitive(g1);
    l.addPrimitive(g1);
    l.sortSelectBuffer();
    QUnit.equal(2, l.getSelectBuffer().length);
    QUnit.equal(g2, l.getSelectBuffer()[0]);
    QUnit.equal(g1, l.getSelectBuffer()[1]);
});
//QUnit.test("testSaveGeom()", function () {
//});
QUnit.test("testReflesh()", function () {
    var l = new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    var g0 = new GLine_1.GLine();
    var g1 = new GLine_1.GLine();
    var g2 = new GLine_1.GLine();
    l.addPrimitive(g0);
    l.addPrimitive(g1);
    l.addPrimitive(g2);
    l.setVisible(false);
    QUnit.equal(3, l.getPrims().length);
    QUnit.equal(false, l.isVisible());
    l.refresh();
    QUnit.equal(0, l.getPrims().length);
    QUnit.equal(true, l.isVisible());
});
QUnit.test("testIsHasData()", function () {
    var l = new Layer_1.Layer(new WorkSheet_1.WorkSheet());
    QUnit.equal(false, l.hasData());
    var g0 = new GLine_1.GLine();
    l.addPrimitive(g0);
    QUnit.equal(true, l.hasData());
    l.deleteAll();
    QUnit.equal(false, l.hasData());
});
//# sourceMappingURL=LayerTest.js.map