import { Project } from './Project';
import { GeomParser } from '../geom/GeomParser';
import { Layer } from './Layer';
/**
 * @author matsuzaki**/
export interface DocumentFactory {
    /**
     * 新規レイヤーマネージャの作成
     * レイヤーマネージャは必ずここ経由で行う
     * @param layername　レイヤマネージャの名前
     * @return
     * @author kawae
     * @since 2004/09/30
    **/
    createLayer(prj: Project, layername: string): Layer;
    /**
     * 新規プロジェクトフレームの作成
     * @return
    **/
    createNewProject(): Project;
    /**
     * Geometryの読み込みパーサーの取得
     * @return
     * @author kawae
     * @since 2004/11/02
    **/
    getGeomParser(): GeomParser;
}
