import { ObjectFolder } from 'kiteclib';
import { Project } from './Project';
import { Layer } from './Layer';
import { DocumentFactory } from './DocumentFactory';
import { ProjectListener } from './ProjectListener';
import { ProjectHistoryManager } from './ProjectHistoryManager';
import { Geometry } from '../geom/primitive/Geometry';
/**
 * プロジェクトの基本単位
 * @author kawae
**/
export declare class DefaultProject implements Project {
    /**
     * ヒストリー **/
    protected mHistoryManager: ProjectHistoryManager;
    /**
     * 　アクティブな階 **/
    protected mActiveLayer: Layer;
    /**
     * レイヤーマネージャのコレクション **/
    protected mLayers: Layer[];
    /**
     * 保存フラグ **/
    protected mSaved: boolean;
    /**
     * 各種情報 **/
    protected mProjectInfo: Map<Object, Object>;
    /**
     * リスナー **/
    protected mListeners: ProjectListener[];
    /**
     * コンストラクタ**/
    constructor(history: ProjectHistoryManager);
    /**
     * データの保存
     * @return
    **/
    save(): ObjectFolder;
    load(rootf: ObjectFolder, docFactory: DocumentFactory): void;
    /**
     * レイヤーノードの読み込み
     * @param layerf
     * @param docFactory
     * @author kawae
     * @since 2005/10/07
    **/
    /**
     * レイヤーノードの読み込み
     * @param layerf
     * @param docFactory
     * @author kawae
     * @since 2005/11/02
    **/
    loadLayer(layerf: ObjectFolder, docFactory: DocumentFactory, recover?: boolean): Layer;
    /**
     * ロード時のLayer
     * @param app
     * @param layerName
     * @return
     * @author kawae
     * @since 2004/12/13
    **/
    createLoadLayer(app: DocumentFactory, layerName: string): Layer;
    /**
     * プロジェクト情報の書き込み
     * @param savenode
     * @author kawae
     * @since 2004/11/06
    **/
    saveProjectInformation(savenode: ObjectFolder): void;
    /**
     * プロジェクト情報の読み込み
     * @param savenode
     * @author kawae
     * @since 2004/11/28
    **/
    loadProjectInformation(node: ObjectFolder): void;
    /**
     * 読み込んだ幾何をレイヤーに追加
     * @param l
     * @param g
     * @author kawae
     * @since 2004/11/06
    **/
    addGeomToLayer(l: Layer, g: Geometry): void;
    /**
     * レイヤー単位で読み込み完了後に必要な処理の実行
     * @param l
     * @author kawae
     * @since 2004/11/06
    **/
    recoverAfterLoad(l: Layer): void;
    /**
     * プロジェクト情報の取得
     * @return
    **/
    getProjectInfoMap(): Map<Object, Object>;
    /**
     * プロジェクト情報の特定のオブジェクトの取得
     * @param key
     * @return
    **/
    getProjectInfo(key: Object): Object;
    /**
     * レイヤーの追加
     * @param lm
    **/
    addLayer(l: Layer): void;
    /**
     * 現在のレイヤーの設定
     * @param i	レイヤーID
    **/
    setCurrentLayer(i: number): void;
    /**
     * 現在レイヤーの設定
     * @param s	レイヤーの名前
    **/
    setCurrentLayer(s: string): void;
    getLayers(): Layer[];
    setSaved(changed: boolean): void;
    isSaved(): boolean;
    /**
     * 現在のアクティブレイヤーの取得
     * @return アクティブなレイヤー
    **/
    getCurrentLayer(): Layer;
    /**
     * ドキュメントのクリア**/
    documentRefresh(): void;
    /**
     * ヒストリのクリア
     * @param o
    **/
    flushHistory(): void;
    /**
     * ヒストリに設定
     * @param o
    **/
    setHistoryObject(o: Object): void;
    /**
     * カレントフロアの最後のヒストリの取得
     * @return
    **/
    getLastHistory(): Object;
    /**
     * カレントフロアの現在のヒストリの取得
     * @return
    **/
    getCurrentHistory(): Object;
    /**
     * アンドゥ**/
    undo(): boolean;
    /**
     * リドゥ**/
    redo(): boolean;
    /**
     * ヒストリに追加
     * @author kawae
     * @since 2004/09/22
    **/
    addHistory(): void;
    /**
     * UNDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    hasUndo(): boolean;
    /**
     * REDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    hasRedo(): boolean;
    /**
     * 指定された数の履歴を保存する新たな履歴を構築する。
     * @param num
    **/
    setMaxHistory(num: number): void;
    addProjectListener(l: ProjectListener): void;
    removeProjectListener(l: ProjectListener): void;
    fireProjectChanged(source: Object): void;
}
