var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
var kiteclib_3 = require('kiteclib');
var kiteclib_4 = require('kiteclib');
var NethomeCoreResource_1 = require('../../NethomeCoreResource');
//module nethome.geom.rich
/**
 * テキストの最小単位
 * @author kawae
 * @since 2004/11/13
**/
var KTextElement = (function () {
    /**
     * コンストラクタ
     * @author kawae
     * @since 2004/11/14
    **/
    function KTextElement() {
    }
    /**
     * テキストの設定
     * @param text
     * @author kawae
     * @since 2004/11/13
    **/
    KTextElement.prototype.setText = function (text) {
        this.mText = kiteclib_4.UtilString.tab2space(text);
    };
    KTextElement.prototype.getText = function () {
        return this.mText;
    };
    KTextElement.prototype.getBackColor = function () {
        return this.mBackColor;
    };
    KTextElement.prototype.getFontName = function () {
        return this.mFontname;
    };
    KTextElement.prototype.getFontSize = function () {
        return this.mFontsize;
    };
    KTextElement.prototype.getFontStyle = function () {
        return this.mFontstyle;
    };
    KTextElement.prototype.getTextColor = function () {
        return this.mTextColor;
    };
    KTextElement.prototype.isSameTextFormat = function (tf) {
        if (kiteclib_4.UtilString.isDiff(this.getFontName(), tf.getFontName()))
            return false;
        if (this.getFontStyle() != tf.getFontStyle())
            return false;
        if (Math.abs(this.getFontSize() - tf.getFontSize()) > 1e-3)
            return false;
        if (kiteclib_3.KColor.isDiff(this.getTextColor(), tf.getTextColor()))
            return false;
        if (kiteclib_3.KColor.isDiff(this.getBackColor(), tf.getBackColor()))
            return false;
        if (this.isUnderLine() != tf.isUnderLine())
            return false;
        return true;
    };
    KTextElement.prototype.isUnderLine = function () {
        return this.mIsUnderline;
    };
    KTextElement.prototype.setBackColor = function (c) {
        this.mBackColor = c;
    };
    KTextElement.prototype.setFontName = function (s) {
        this.mFontname = s;
    };
    KTextElement.prototype.setFontSize = function (f) {
        this.mFontsize = f;
    };
    KTextElement.prototype.setFontStyle = function (style) {
        this.mFontstyle = style;
    };
    KTextElement.prototype.setFormat = function (f) {
        this.setBackColor(f.getBackColor());
        this.setTextColor(f.getTextColor());
        this.setFontName(f.getFontName());
        this.setFontSize(f.getFontSize());
        this.setFontStyle(f.getFontStyle());
        this.setUnderLine(f.isUnderLine());
    };
    KTextElement.prototype.setTextColor = function (c) {
        this.mTextColor = c;
    };
    KTextElement.prototype.setUnderLine = function (flag) {
        this.mIsUnderline = flag;
    };
    /**
     * 保存
     * @param savenode
     * @author kawae
     * @since 2004/11/17
     * @see nethome.text.ITextFormat#save(jp.kitec.lib.util.tree.ObjectFolder)
    **/
    KTextElement.prototype.save = function (savenode) {
        if (savenode == null)
            return;
        savenode.setName(KTextElement.GEOMNAME);
        savenode.addNode("text", this.mText);
        savenode.addNode("textsize", this.mFontsize);
        savenode.addNode("textfont", this.mFontname);
        savenode.addNode("textstyle", this.mFontstyle);
        savenode.addNode("underline", this.mIsUnderline);
        if (this.mTextColor != null)
            savenode.addChild(new kiteclib_1.ObjectNode("textcolor", kiteclib_3.KColor.getColorRGBString(this.mTextColor)));
        if (this.mBackColor != null)
            savenode.addChild(new kiteclib_1.ObjectNode("backcolor", kiteclib_3.KColor.getColorRGBString(this.mBackColor)));
    };
    /**
     * 読み込み
     * @param of
     * @param tl
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    KTextElement.readData = function (of, tl) {
        var on = null;
        if (kiteclib_1.ObjectNode.isStringObject(on = of.getNode("text")))
            tl.mText = kiteclib_4.UtilString.tab2space(kiteclib_1.ObjectNode.getNodeString(on));
        if (kiteclib_1.ObjectNode.isStringObject(on = of.getNode("textfont")))
            tl.mFontname = kiteclib_1.ObjectNode.getNodeString(on);
        if (kiteclib_1.ObjectNode.isFloatObject(on = of.getNode("textsize")))
            tl.mFontsize = kiteclib_1.ObjectNode.getNodeFloat(on);
        if (kiteclib_1.ObjectNode.isBoolObject(on = of.getNode("underline")))
            tl.mIsUnderline = kiteclib_1.ObjectNode.getNodeBool(on);
        if (kiteclib_1.ObjectNode.isIntObject(on = of.getNode("textstyle")))
            tl.mFontstyle = on.getInt();
        if ((on = of.getNode("textcolor")) != null)
            tl.mTextColor = kiteclib_3.KColor.getColorFromRGBString(on.getString());
        if ((on = of.getNode("backcolor")) != null)
            tl.mBackColor = kiteclib_3.KColor.getColorFromRGBString(on.getString());
        return tl;
    };
    /**
     * フォントの取得
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    KTextElement.prototype.getFont = function () {
        return kiteclib_2.KFont.getFont(this.getFontName(), this.getFontStyle(), this.getFontSize());
    };
    /**
     * 最大幅の取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/14
     * @version 2006/01/05縦書き対応
    **/
    KTextElement.prototype.getMaxWidth = function (hor, dpi) {
        var total = 0;
        var str = this.getText();
        var f = kiteclib_2.KFont.getFont(this.getFontName(), this.getFontStyle(), dpi.getDpiScaleSize(this.getFontSize()));
        var fm = f.getFontMetrics(null);
        if (hor) {
            return (Math.ceil(fm.stringWidth(str) * 1000) / 1000);
        }
        else {
            for (var i = 0; i < str.length; i++) {
                var s = str.substring(i, i + 1);
                var ww = 0;
                if (NethomeCoreResource_1.NethomeCoreResource.TATE_STRING.indexOf(s) >= 0)
                    ww = (Math.ceil((fm.getDescent() + fm.getAscent()) * 1000) / 1000);
                else
                    ww = (Math.ceil(fm.stringWidth(s) * 1000) / 1000);
                total = total < ww ? ww : total;
            }
        }
        return total;
    };
    /**
     * 最大高さの取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/14
     * @version 2006/01/05縦書き対応
    **/
    KTextElement.prototype.getMaxHeight = function (hor, dpi) {
        var height = 0;
        var dpiScaleSize = dpi.getDpiScaleSize(this.getFontSize());
        var f = kiteclib_2.KFont.getFont(this.getFontName(), this.getFontStyle(), dpiScaleSize);
        var fm = f.getFontMetrics(null);
        if (hor) {
            height = Math.ceil((fm.getDescent() + fm.getAscent()) * 1000) / 1000;
            if (height < dpiScaleSize / 5) {
                height = dpiScaleSize;
            }
        }
        else {
            var str = this.getText();
            for (var i = 0; i < str.length; i++) {
                var s = str.substring(i, i + 1);
                if (NethomeCoreResource_1.NethomeCoreResource.TATE_STRING.indexOf(s) >= 0)
                    height += (Math.ceil(fm.stringWidth(s) * 1000) / 1000);
                else
                    height += (Math.ceil((fm.getDescent() + fm.getAscent()) * 1000) / 1000);
            }
        }
        return height;
    };
    KTextElement.prototype.getCopy = function () {
        var c = new KTextElement();
        c.mText = this.mText;
        c.mFontname = this.mFontname;
        c.mFontsize = this.mFontsize;
        c.mIsUnderline = this.mIsUnderline;
        ;
        c.mFontstyle = this.mFontstyle;
        c.mTextColor = this.mTextColor;
        c.mBackColor = this.mBackColor;
        return c;
    };
    KTextElement.GEOMNAME = "TEXT_ELEMENT";
    return KTextElement;
})();
exports.KTextElement = KTextElement;
//# sourceMappingURL=KTextElement.js.map