var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
var GPoint2Df_1 = require('./GPoint2Df');
var Geometry_1 = require('./Geometry');
//import { ToolPolygon } from '../util/ToolPolygon'
var NethomeCoreResource_1 = require('../../NethomeCoreResource');
//module nethome.geom.primitive
var GText = (function (_super) {
    __extends(GText, _super);
    /**
     * コンストラクタ**/
    //constructor() {
    //    super();
    //}
    /**
     * コンストラクタ
     * @param p1
     * @param scaleFontLabel
     * @param text
     * @param angl
     * @param size
     * @param bold
    **/
    function GText(p1, scaleFontLabel, text, angl, size, bold) {
        if (p1 === void 0) { p1 = null; }
        if (scaleFontLabel === void 0) { scaleFontLabel = null; }
        if (text === void 0) { text = ""; }
        if (angl === void 0) { angl = 0; }
        if (size === void 0) { size = 0; }
        if (bold === void 0) { bold = false; }
        _super.call(this, GText.GEOMNAME);
        /**
         * 描画方向 (true:横)
         **/
        this.mDir = true;
        /**
         * 背景の塗り潰しモード
         **/
        this.mFillBack = false;
        /**
         * 太字
         **/
        this.mBold = false;
        this.mCp = new GPoint2Df_1.GPoint2Df();
        if (p1)
            this.mCp.setXY(p1.x, p1.y);
        this.mAngl = angl;
        this.mText = text;
        this.mSize = size;
        this.mScaleFontName = scaleFontLabel;
        this.mBold = bold;
        this.mGeomColor = kiteclib_1.KColor.BLACK;
    }
    /**
     * 塗り潰しモードの指定
     * @param fill
     * @param fillColor
    **/
    GText.prototype.setFillMode = function (fill, fillColor) {
        this.mFillBack = fill;
        this.mFillColor = fillColor;
    };
    /****/
    GText.prototype.updateMinMax = function (area) {
        area.updateMinMax(this.mMinx, this.mMiny);
        area.updateMinMax(this.mMaxx, this.mMaxy);
    };
    GText.prototype.copy = function () {
        return this.copyTo(new GText());
    };
    GText.prototype.copyTo = function (g) {
        if (g == null || !(g instanceof GText))
            return null;
        var gt = (g);
        _super.prototype.copyTo.call(this, gt);
        gt.mCp = this.mCp.copy();
        gt.mAngl = this.mAngl;
        gt.mText = this.mText;
        gt.mSize = this.mSize;
        gt.mScaleFontName = this.mScaleFontName;
        gt.mBold = this.mBold;
        gt.setFillMode(this.mFillBack, this.mFillColor);
        gt.mDir = this.mDir;
        return gt;
    };
    GText.prototype.getDistanceToPoint = function (x, y) {
        if (x > this.mMinx && x < this.mMaxx && y > this.mMiny && y < this.mMaxy)
            return 0;
        var len = Number.MAX_VALUE;
        var tmp;
        tmp = kiteclib_2.MathUtil.getLengthLimitLineToPoint2D(x, y, this.mMinx, this.mMiny, this.mMaxx, this.mMiny);
        if (tmp >= 0)
            len = Math.min(tmp, len);
        tmp = kiteclib_2.MathUtil.getLengthLimitLineToPoint2D(x, y, this.mMaxx, this.mMiny, this.mMaxx, this.mMaxy);
        if (tmp >= 0)
            len = Math.min(tmp, len);
        tmp = kiteclib_2.MathUtil.getLengthLimitLineToPoint2D(x, y, this.mMaxx, this.mMaxy, this.mMinx, this.mMaxy);
        if (tmp >= 0)
            len = Math.min(tmp, len);
        tmp = kiteclib_2.MathUtil.getLengthLimitLineToPoint2D(x, y, this.mMinx, this.mMaxy, this.mMinx, this.mMiny);
        if (tmp >= 0)
            len = Math.min(tmp, len);
        return len;
    };
    GText.prototype.offset = function (x, y) {
        this.mMinx += x;
        this.mMiny += y;
        this.mMaxx += x;
        this.mMaxy += y;
        this.mCp.x += x;
        this.mCp.y += y;
    };
    GText.prototype.rotate = function (xc, yc, angl) {
        this.mCp.rotate(xc, yc, angl);
        this.mAngl += angl;
    };
    GText.prototype.isInner = function (minx, miny, maxx, maxy) {
        if (this.mMinx >= minx && this.mMaxx <= maxx && this.mMiny >= miny && this.mMaxy <= maxy)
            return true;
        return false;
    };
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    return ToolPolygon.isInnerPolygon(v, this.mMinx, this.mMiny) && ToolPolygon.isInnerPolygon(v, this.mMaxx, this.mMaxy);
    //}
    /**
     * 描画方向の設定**/
    GText.prototype.setDir = function (dir) {
        this.mDir = dir;
    };
    GText.prototype.isDir = function () {
        return this.mDir;
    };
    /**
     * データの保存
     * @param savenode
    **/
    GText.prototype.save = function (savenode) {
        if (savenode == null)
            return;
        _super.prototype.save.call(this, savenode);
        savenode.addNode("x", this.mCp.x);
        savenode.addNode("y", this.mCp.y);
        savenode.addNode("scalefontname", this.mScaleFontName);
        savenode.addNode("string", this.mText);
        savenode.addNode("angl", this.mAngl);
        savenode.addNode("textsize", this.mSize);
        savenode.addNode("dir", this.mDir);
        savenode.addNode("fillback", this.mFillBack);
        savenode.addNode("bold", this.mBold);
    };
    GText.prototype.drawHighLight = function (d, c, outline) {
        GPoint2Df_1.GPoint2Df.drawHighLight(d, c, this.mMinx, this.mMiny);
        GPoint2Df_1.GPoint2Df.drawHighLight(d, c, this.mMaxx, this.mMiny);
        GPoint2Df_1.GPoint2Df.drawHighLight(d, c, this.mMaxx, this.mMaxy);
        GPoint2Df_1.GPoint2Df.drawHighLight(d, c, this.mMinx, this.mMaxy);
    };
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, this.mGeomColor, this.mFillColor);
    //}
    GText.prototype.drawGeom = function (d, fore, back) {
        if (fore == null)
            fore = this.mGeomColor;
        if (back == null)
            back = this.mFillColor;
        this.drawAbstDevice(d, fore, back, null);
    };
    GText.prototype.drawAlias = function (d, fore, back, la) {
        if (back == null)
            back = this.mFillColor;
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, la);
    };
    GText.prototype.drawAbstDevice = function (d, fore, back, la) {
        this.update();
        if (this.mFillBack) {
            d.setColor(back);
            d.drawFillRect(this.mMinx, this.mMiny, this.mMaxx, this.mMaxy, null);
        }
        var scaleFont = NethomeCoreResource_1.NethomeCoreResource.getScaleFont(this.mScaleFontName);
        var scale = this.mSize / NethomeCoreResource_1.NethomeCoreResource.SCALEFONTSIZE;
        var _tmpf = new Array(2);
        if (this.mDir) {
            var cx = this.mCp.x;
            var cy = this.mCp.y;
            var angl = this.mAngl;
            var textw = scaleFont.stringWidth(this.mText) * scale;
            var size = this.mSize;
            var x;
            var y;
            if (la != null) {
                angl += la.mRot * 180 / Math.PI;
                var tx = la.getGlobalX(cx, cy, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                var ty = la.getGlobalY(cx, cy, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                cx = tx;
                cy = ty;
                size = this.mSize * la.getScaleX();
                if (la.getFlipY())
                    angl += 180.0;
                kiteclib_2.MathUtil.rotation2D(0, 0, angl * kiteclib_2.MathUtil.D2R, -textw / 2, -((scaleFont.ascent - scaleFont.descent) * scale) / 2 * 1, _tmpf);
                x = cx + _tmpf[0] * la.getScaleX();
                y = cy + _tmpf[1] * la.getScaleX();
            }
            else {
                kiteclib_2.MathUtil.rotation2D(0, 0, angl * kiteclib_2.MathUtil.D2R, -textw / 2, -((scaleFont.ascent - scaleFont.descent) * scale) / 2 * 1, _tmpf);
                x = cx + _tmpf[0];
                y = cy + _tmpf[1];
            }
            d.setColor(fore);
            d.drawText(this.mText, x, y, scaleFont.name, scaleFont.style, size, angl);
        }
        else {
            for (var i = 0; i < this.mText.length; i++) {
                var ss = this.mText.substring(i, i + 1);
                var wid = (scaleFont.stringWidth(ss) * scale);
                var hei = (scaleFont.height * scale);
                var size = (scaleFont.descent + scaleFont.ascent) * scale;
                var x1 = this.mCp.x - wid / 2;
                var y1 = this.mMaxy - size * (i + 1);
                var x2 = x1 + wid;
                var y2 = y1 + hei;
                var cx = (x1 + x2) / 2;
                var cy = (y1 + y2) / 2;
                var ofs = scaleFont.descent * scale;
                d.setColor(fore);
                if (NethomeCoreResource_1.NethomeCoreResource.TATE_STRING.indexOf(ss) >= 0) {
                    d.drawText(ss, cx - hei / 2 + ofs, cy + wid / 2, scaleFont.name, scaleFont.style, this.mSize, (this.mAngl - 90));
                }
                else {
                    d.drawText(ss, cx - wid / 2, cy - hei / 2 + ofs, scaleFont.name, scaleFont.style, this.mSize, this.mAngl);
                }
            }
        }
    };
    GText.prototype.update = function () {
        var scaleFont = NethomeCoreResource_1.NethomeCoreResource.getScaleFont(this.mScaleFontName);
        var scale = this.mSize / scaleFont.size;
        var size = 0;
        if (this.mDir) {
            size = scaleFont.descent + scaleFont.ascent;
            var width = scaleFont.stringWidth(this.mText);
            var w = width * scale / 2;
            this.mMinx = this.mCp.x - w - size / 10 * scale;
            this.mMaxx = this.mCp.x + w + size / 10 * scale;
            this.mMiny = this.mCp.y - size / 2 * scale;
            this.mMaxy = this.mCp.y + size / 2 * scale;
        }
        else {
            var w = 0;
            for (var i = 0; i < this.mText.length; i++) {
                var ss = this.mText.substring(i, i + 1);
                var tw = scaleFont.stringWidth(ss) / 2;
                w = Math.max(w, tw);
            }
            this.mMinx = this.mCp.x - w * scale;
            this.mMaxx = this.mCp.x + w * scale;
            size = scaleFont.descent + scaleFont.ascent;
            var h = this.mText.length * size * scale / 2;
            this.mMiny = this.mCp.y - h;
            this.mMaxy = this.mCp.y + h;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    /**
     * @return String
     **/
    GText.prototype.getText = function () {
        return this.mText;
    };
    GText.prototype.setText = function (s) {
        this.mText = s;
        this.update();
    };
    /**
     * @return double
     **/
    GText.prototype.getSize = function () {
        return this.mSize;
    };
    /**
     * Sets the mSize.
     * @param mSize The mSize to set
    **/
    GText.prototype.setSize = function (mSize) {
        this.mSize = mSize;
    };
    GText.prototype.flipx = function (x, ofsx) {
        this.mCp.flipx(x, ofsx);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    /**
     * 縦反転**/
    GText.prototype.flipy = function (y, ofsy) {
        this.mCp.flipy(y, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GText.prototype.rot = function (x, y, ofsx, ofsy) {
        this.mCp.rot(x, y, ofsx, ofsy);
        this.mDir = !this.mDir;
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GText.GEOMNAME = "TEXT";
    return GText;
})(Geometry_1.Geometry);
exports.GText = GText;
//# sourceMappingURL=GText.js.map