var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
//import { MathUtilEx } from '../util/MathUtilEx'
//import { ToolPolygon } from '../util/ToolPolygon'
//import { ToolMath } from '../util/ToolMath'
var kiteclib_3 = require('kiteclib');
var GPoint2Df_1 = require('./GPoint2Df');
var Geometry_1 = require('./Geometry');
//module nethome.geom.primitive
var GRect = (function (_super) {
    __extends(GRect, _super);
    /**
     * コンストラクタ
     * @param x1	始点X座標3
     * @param y1	始点X座標
     * @param x2	始点X座標
     * @param y2	始点X座標
     * @param c	描画色
    //**/
    //public constructor() {
    //    thisconstructor(0, 0, 0, 0, false);
    //}
    //public constructor(x1 : number, y1 : number, x2 : number, y2 : number, fill : boolean) {
    //    thisconstructor(x1, y1, x2, y1, x2, y2, x1, y2, fill);
    //}
    function GRect(x1, y1, x2, y2, x3, y3, x4, y4, fill) {
        if (x1 === void 0) { x1 = 0; }
        if (y1 === void 0) { y1 = 0; }
        if (x2 === void 0) { x2 = 0; }
        if (y2 === void 0) { y2 = 0; }
        if (x3 === void 0) { x3 = 0; }
        if (y3 === void 0) { y3 = 0; }
        if (x4 === void 0) { x4 = 0; }
        if (y4 === void 0) { y4 = 0; }
        if (fill === void 0) { fill = false; }
        _super.call(this);
        /**
         * 塗り潰しフラグ **/
        this.mFill = false;
        this.mGeomColor = kiteclib_1.KColor.BLACK;
        this.mFillColor = kiteclib_1.KColor.BLACK;
        this.mFill = fill;
        this.mLineWidth = 0;
        this.mPoints = [];
        this.mPoints.push(new GPoint2Df_1.GPoint2Df(x1, y1));
        this.mPoints.push(new GPoint2Df_1.GPoint2Df(x2, y2));
        this.mPoints.push(new GPoint2Df_1.GPoint2Df(x3, y3));
        this.mPoints.push(new GPoint2Df_1.GPoint2Df(x4, y4));
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    GRect.prototype.getP1 = function () {
        return this.mPoints[0];
    };
    GRect.prototype.getP2 = function () {
        return this.mPoints[2];
    };
    GRect.prototype.setRect = function (x1, y1, x2, y2) {
        var xa;
        var ya;
        var xb;
        var yb;
        xa = x1 < x2 ? x1 : x2;
        ya = y1 < y2 ? y1 : y2;
        xb = x1 > x2 ? x1 : x2;
        yb = y1 > y2 ? y1 : y2;
        for (var i = 0; i < 4; i++) {
            var p = this.mPoints[i];
            p.x = (i == 0 || i == 3) ? xa : xb;
            p.y = (i == 0 || i == 1) ? ya : yb;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GRect.prototype.getSnapNode = function (x1, y1, gx, gy, min, res, eps, limit) {
        var flag = false;
        for (var i = 0; i < this.mPoints.length; i++) {
            var r = false;
            if (r)
                flag = r;
        }
        return flag;
    };
    GRect.prototype.getSnapLoop = function (v) {
        for (var i = 0; i <= this.mPoints.length; i++)
            v.push(this.mPoints[i]);
    };
    GRect.prototype.getCenter = function (p) {
        var x = 0;
        var y = 0;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            x += p1.x;
            y += p1.y;
        }
        p.x = x / this.mPoints.length;
        p.y = y / this.mPoints.length;
    };
    GRect.prototype.getNearNodeOnLine = function (p1, p2, eps) {
        var len;
        var min = Number.MAX_VALUE;
        var res = null;
        for (var k = 0; k < this.mPoints.length; k++) {
            var pa = this.mPoints[k];
            if ((len = kiteclib_3.MathUtil.getLengthLimitLineToPoint2D(pa.x, pa.y, p1.x, p1.y, p2.x, p2.y)) >= 0 && len < eps && len < min) {
                min = len;
                res = pa;
            }
        }
        return res;
    };
    GRect.prototype.getNearLine = function (x, y, eps, pts) {
        var len;
        var exist = false;
        for (var k = 0; k < this.mPoints.length; k++) {
            var pa = this.mPoints[k];
            var pb = this.mPoints[(k + 1) % pts.length];
            if ((len = kiteclib_3.MathUtil.getLengthLimitLineToPoint2D(x, y, pa.x, pa.y, pb.x, pb.y)) >= 0 && len < eps) {
                pts[0] = pa;
                pts[1] = pb;
                exist = true;
            }
        }
        return exist;
    };
    GRect.prototype.getRotbasePoint = function () {
        return this.mPoints[0];
    };
    GRect.prototype.updateMinMax = function (area) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p = this.mPoints[i];
            area.updateMinMax(p.x, p.y);
        }
    };
    GRect.prototype.copy = function () {
        return this.copyTo(new GRect());
    };
    GRect.prototype.copyTo = function (g) {
        if (g == null || !(g instanceof GRect))
            return null;
        var pl = (g);
        _super.prototype.copyTo.call(this, pl);
        var x1 = this.mPoints[0].x;
        var y1 = this.mPoints[0].y;
        var x3 = this.mPoints[2].x;
        var y3 = this.mPoints[2].y;
        pl.setRect(x1, y1, x3, y3);
        pl.area.maximize();
        pl.setFillMode(this.mFill);
        pl.setFillColor(this.mFillColor);
        pl.updateMinMax(pl.area);
        return pl;
    };
    GRect.prototype.getNearNode = function (x, y) {
        var min = Number.MAX_VALUE;
        var gp = null;
        var tmp;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p = this.mPoints[i];
            if ((tmp = kiteclib_3.MathUtil.getLength2D(x, y, p.x, p.y)) < min) {
                gp = p;
                min = tmp;
            }
        }
        return gp;
    };
    GRect.prototype.getDistanceToPoint = function (x, y) {
        var min = Number.MAX_VALUE;
        var len;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            var p2 = this.mPoints[(i + 1) % this.mPoints.length];
            len = kiteclib_3.MathUtil.getLengthLimitLineToPoint2D(x, y, p1.x, p1.y, p2.x, p2.y);
            if (len >= 0 && len < min)
                min = len;
        }
        return min;
    };
    GRect.prototype.offset = function (x, y) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            p1.offset(x, y);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GRect.prototype.rotate = function (xc, yc, angl) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            p1.rotate(xc, yc, angl);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GRect.prototype.isInner = function (minx, miny, maxx, maxy) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            if (!(p1.x > minx && p1.x < maxx && p1.y > miny && p1.y < maxy))
                return false;
        }
        return true;
    };
    /**
     * ポリゴン内に存在するか**/
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    for (var i: number = 0; i < this.mPoints.length; i++) {
    //        var p1: GPoint2Df = (this.mPoints.elementAt(i)) as GPoint2Df;
    //        var p2: GPoint2Df = (this.mPoints.elementAt(i + 1)) as GPoint2Df;
    //        var b1: boolean = ToolPolygon.isInnerPolygon(v, p1.x, p1.y);
    //        var b2: boolean = ToolPolygon.isInnerPolygon(v, p2.x, p2.y);
    //        if (!b1 || !b2) return false;
    //    }
    //    return true;
    //}
    /**
     * データの保存
     * @param savenode
    **/
    GRect.prototype.save = function (savenode) {
        if (savenode == null)
            return;
        _super.prototype.save.call(this, savenode);
        for (var i = 0; i < this.mPoints.length; i++) {
            var p = this.mPoints[i];
            savenode.addNode("x" + (i + 1), p.x);
            savenode.addNode("y" + (i + 1), p.y);
        }
        savenode.addNode("fill", this.mFill);
        savenode.addNode("width", this.mLineWidth);
    };
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, KColor.BLACK, null);
    //}
    GRect.prototype.drawGeom = function (d, fore, back) {
        if (back == null)
            back = this.mFillColor;
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, null);
    };
    GRect.prototype.drawAlias = function (d, fore, back, la) {
        this.drawAbstDevice(d, fore, back, la);
    };
    GRect.prototype.drawAbstDevice = function (d, fore, back, la) {
        if (this.mFill) {
            if (la != null) {
                if (this._pbuf == null)
                    this._pbuf = [];
                if (this._pbuf.length != this.mPoints.length) {
                    this._pbuf = [];
                    for (var i = 0; i < this.mPoints.length; i++)
                        this._pbuf.push(new GPoint2Df_1.GPoint2Df());
                }
                for (var i = 0; i < this.mPoints.length; i++) {
                    var p1 = this.mPoints[i];
                    var p2 = this._pbuf[i];
                    p2.x = la.getGlobalX(p1.x, p1.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                    p2.y = la.getGlobalY(p1.x, p1.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                }
                d.setColor(back);
                d.drawFillPolygon(this._pbuf, null);
            }
            else {
                d.setColor(back);
                d.drawFillPolygon(this.mPoints, null);
            }
        }
        d.setColor(fore);
        d.drawFillPolygon(this.mPoints, null);
    };
    GRect.prototype.drawHighLight = function (d, c, outline) {
        if (outline) {
            d.setColor(c);
            d.drawPolygon(this.mPoints, kiteclib_2.IRichGraphicsConst.LINE_DASH_1);
        }
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            p1.drawHighLight(d, c, false);
        }
    };
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
    **/
    GRect.prototype.getNearControlPoint = function (x, y) {
        var min = Number.POSITIVE_INFINITY;
        var p = null;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            var len = p1.getDistanceToPoint(x, y);
            if (len < min) {
                min = len;
                p = p1;
            }
        }
        return p;
    };
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
    **/
    GRect.prototype.moveControlPoint = function (cp, x, y) {
        //TODO
        //var pa: GPoint2Df; var pb: GPoint2Df; var pc: GPoint2Df;
        //var p: GPoint2Df = cp as GPoint2Df;
        //var o: Object;
        //pa = ((o = (this.mPoints.itemAt(p).nextItem.getObject()) as GPoint2Df) != null && o instanceof GPoint2Df) ? ((o) as GPoint2Df) : null;
        //pb = ((o = (this.mPoints.itemAt(o).nextItem.getObject()) as GPoint2Df) != null && o instanceof GPoint2Df) ? ((o) as GPoint2Df) : null;
        //pc = ((o = (this.mPoints.itemAt(o).nextItem.getObject()) as GPoint2Df) != null && o instanceof GPoint2Df) ? ((o) as GPoint2Df) : null;
        //if (pa != null && pb != null && pb != null) {
        //    if (!MathUtilEx.isPointPickUporDown(x, y, pa, pb) || !MathUtilEx.isPointPickUporDown(x, y, pb, pc)) return;
        //}
        //var len: number;
        //len = MathUtil.getLengthLimitlessLineToPoint2D(x, y, pa.x, pa.y, pb.x, pb.y);
        //if (len >= 0 && len < MathUtil.EPS) return;
        //len = MathUtil.getLengthLimitlessLineToPoint2D(x, y, pb.x, pb.y, pc.x, pc.y);
        //if (len >= 0 && len < MathUtil.EPS) return;
        //var _tmpf: number[] = new Array(2);
        //for (var i: number = 0; i < this.mPoints.length; i++) {
        //    var p1: GPoint2Df = (this.mPoints.elementAt(i)) as GPoint2Df;
        //    if (p1 == cp) {
        //        var pt: GPoint2Df = (this.mPoints.elementAt(i - 2)) as GPoint2Df;
        //        var p0: GPoint2Df = (this.mPoints.elementAt(i - 1)) as GPoint2Df;
        //        var p2: GPoint2Df = (this.mPoints.elementAt(i + 1)) as GPoint2Df;
        //        p1.x = x;
        //        p1.y = y;
        //        MathUtil.isCrossPointVertLimitlessLineToPoint2D(x, y, pt.x, pt.y, p0.x, p0.y, _tmpf);
        //        p0.x = _tmpf[0];
        //        p0.y = _tmpf[1];
        //        MathUtil.isCrossPointVertLimitlessLineToPoint2D(x, y, pt.x, pt.y, p2.x, p2.y, _tmpf);
        //        p2.x = _tmpf[0];
        //        p2.y = _tmpf[1];
        //        break;
        //    }
        //}
        //this.area.maximize();
        //this.updateMinMax(this.area);
    };
    GRect.prototype.flipx = function (x, ofsx) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].flipx(x, ofsx);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GRect.prototype.flipy = function (y, ofsy) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].flipy(y, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GRect.prototype.rot = function (x, y, ofsx, ofsy) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].rot(x, y, ofsx, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    /**
     * 幾何形状の更新**/
    GRect.prototype.updateShape = function () {
        var p1 = this.mPoints[0];
        var p2 = this.mPoints[1];
        var p3 = this.mPoints[2];
        var p4 = this.mPoints[3];
        p2.x = p3.x;
        p2.y = p1.y;
        p4.x = p1.x;
        p4.y = p3.y;
    };
    GRect.prototype.setFillMode = function (b) {
        this.mFill = b;
    };
    GRect.prototype.isFillMode = function () {
        return this.mFill;
    };
    GRect.prototype.getFillColor = function () {
        return this.mFillColor;
    };
    GRect.prototype.setFillColor = function (fillColor) {
        this.mFillColor = fillColor;
    };
    return GRect;
})(Geometry_1.Geometry);
exports.GRect = GRect;
//# sourceMappingURL=GRect.js.map