var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
var kiteclib_3 = require('kiteclib');
var Geometry_1 = require('./Geometry');
var GPoint2Df_1 = require('./GPoint2Df');
//module nethome.geom.primitive
var GPolyLine = (function (_super) {
    __extends(GPolyLine, _super);
    /**
     * コンストラクタ**/
    //public constructor() {
    //    thisconstructor(new RefList<GPoint2Df>(), 0, 0);
    //}
    /**
     * コンストラクタ
     * @param p1		ポリライン構成点コレクション
     * @param type	始点X座標
     * @param c		描画色
    **/
    function GPolyLine(p1, type, smooth) {
        if (type === void 0) { type = 0; }
        if (smooth === void 0) { smooth = 0; }
        _super.call(this);
        this.mGeomColor = kiteclib_1.KColor.BLACK;
        this.mPoints = p1 || [];
        this.mType = type;
        this.mSmooth = smooth;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    GPolyLine.prototype.addPoint = function (p) {
        this.mPoints.push(p);
        if (this.areaControl != null)
            this.areaControl.setArea(this.mPoints);
    };
    GPolyLine.prototype.getSnapNode = function (x1, y1, gx, gy, min, res, eps, limit) {
        return false;
    };
    GPolyLine.prototype.getSnapLoop = function (v) {
        for (var i = 0; i < this.mPoints.length; i++)
            v.push(this.mPoints[i]);
    };
    GPolyLine.prototype.getCenter = function (p) {
        var x = 0;
        var y = 0;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            x += p1.x;
            y += p1.y;
        }
        p.x = x / this.mPoints.length;
        p.y = y / this.mPoints.length;
    };
    GPolyLine.prototype.getNearNodeOnLine = function (p1, p2, eps) {
        var len;
        var min = Number.MAX_VALUE;
        var res = null;
        for (var k = 0; k < this.mPoints.length; k++) {
            var pa = this.mPoints[k];
            if ((len = kiteclib_3.MathUtil.getLengthLimitLineToPoint2D(pa.x, pa.y, p1.x, p1.y, p2.x, p2.y)) >= 0 && len < eps && len < min) {
                min = len;
                res = pa;
            }
        }
        return res;
    };
    GPolyLine.prototype.getNearLine = function (x, y, eps, pts) {
        var len;
        var exist = false;
        for (var k = 0; k < this.mPoints.length; k++) {
            var pa = this.mPoints[k];
            var pb = this.mPoints[(k + 1) % this.mPoints.length];
            if ((len = kiteclib_3.MathUtil.getLengthLimitLineToPoint2D(x, y, pa.x, pa.y, pb.x, pb.y)) >= 0 && len < eps) {
                pts[0] = pa;
                pts[1] = pb;
                exist = true;
            }
        }
        return exist;
    };
    GPolyLine.prototype.getRotbasePoint = function () {
        return this.mPoints[0];
    };
    GPolyLine.prototype.updateMinMax = function (area) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p = this.mPoints[i];
            area.updateMinMax(p.x, p.y);
        }
    };
    GPolyLine.prototype.copy = function () {
        return this.copyTo(new GPolyLine());
    };
    GPolyLine.prototype.copyTo = function (g) {
        if (g == null || !(g instanceof GPolyLine))
            return null;
        var np = (g);
        _super.prototype.copyTo.call(this, np);
        var v = [];
        for (var i = 0; i < this.mPoints.length; i++)
            v.push(this.mPoints[i].copy());
        np.mPoints = v;
        np.mType = this.mType;
        np.mSmooth = this.mSmooth;
        np.area.maximize();
        np.updateMinMax(np.area);
        return np;
    };
    GPolyLine.prototype.getNearNode = function (x, y) {
        var min = Number.MAX_VALUE;
        var gp = null;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            var len = kiteclib_3.MathUtil.getLength2D(x, y, p1.x, p1.y);
            if (len < min) {
                min = len;
                gp = p1;
            }
        }
        return gp;
    };
    GPolyLine.prototype.getDistanceToPoint = function (x, y) {
        var min = Number.MAX_VALUE;
        for (var i = 0; i < this.mPoints.length - 1; i++) {
            var p1 = this.mPoints[i];
            var p2 = this.mPoints[(i + 1) % this.mPoints.length];
            var len = kiteclib_3.MathUtil.getLengthLimitLineToPoint2D(x, y, p1.x, p1.y, p2.x, p2.y);
            if (len < 0)
                continue;
            else if (len < min)
                min = len;
        }
        return min;
    };
    GPolyLine.prototype.offset = function (x, y) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].offset(x, y);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GPolyLine.prototype.rotate = function (xc, yc, angl) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].rotate(xc, yc, angl);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GPolyLine.prototype.isInner = function (minx, miny, maxx, maxy) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1;
            var p2;
            p1 = this.mPoints[i];
            if (i == this.mPoints.length - 1)
                p2 = this.mPoints[0];
            else
                p2 = this.mPoints[i + 1];
            var b1 = false;
            var b2 = false;
            if (p1.x > minx && p1.x < maxx && p1.y > miny && p1.y < maxy)
                b1 = true;
            if (p2.x > minx && p2.x < maxx && p2.y > miny && p2.y < maxy)
                b2 = true;
            if (!b1 || !b2)
                return false;
        }
        return true;
    };
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    for (var i: number = 0; i < this.mPoints.length; i++) {
    //        var p1: GPoint2Df; var p2: GPoint2Df;
    //        p1 = (this.mPoints.[i]) as GPoint2Df;
    //        if (i == this.mPoints.length - 1) p2 = (this.mPoints.elementAt(0)) as GPoint2Df; else p2 = (this.mPoints.elementAt(i + 1)) as GPoint2Df;
    //        var b1: boolean = ToolPolygon.isInnerPolygon(v, p1.x, p1.y);
    //        var b2: boolean = ToolPolygon.isInnerPolygon(v, p2.x, p2.y);
    //        if (!b1 || !b2) return false;
    //    }
    //    return true;
    //}
    GPolyLine.prototype.getPoints = function () {
        return this.mPoints;
    };
    GPolyLine.readData = function (of, g, ps) {
        var on;
        var gp = null;
        if (!(g instanceof GPolyLine))
            return;
        Geometry_1.Geometry.readData(of, g, ps);
        gp = (g);
        gp.mPoints = [];
        var num = 0;
        if ((on = of.getNode("smooth")) != null)
            gp.mSmooth = on.getInt();
        if ((on = of.getNode("type")) != null)
            gp.mType = on.getInt();
        if ((on = of.getNode("pointsize")) != null)
            num = on.getInt();
        for (var i = 0; i < num; i++) {
            var x = 0;
            var y = 0;
            if ((on = of.getNode("x" + (i + 1))) != null)
                x = on.getFloat();
            if ((on = of.getNode("y" + (i + 1))) != null)
                y = on.getFloat();
            gp.mPoints.push(new GPoint2Df_1.GPoint2Df(x, y));
        }
    };
    /**
     * データの保存
     * @param savenode
    **/
    GPolyLine.prototype.save = function (savenode) {
        if (savenode == null)
            return;
        _super.prototype.save.call(this, savenode);
        savenode.addNode("smooth", this.mSmooth);
        savenode.addNode("type", this.mType);
        savenode.addNode("pointsize", this.mPoints.length);
        for (var i = 0; i < this.mPoints.length; i++) {
            var p = this.mPoints[i];
            savenode.addNode("x" + (i + 1), p.x);
            savenode.addNode("y" + (i + 1), p.y);
        }
    };
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, null, null);
    //}
    GPolyLine.prototype.drawGeom = function (d, fore, back) {
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, null);
    };
    GPolyLine.prototype.drawHighLight = function (d, c, outline) {
        if (outline) {
            d.setColor(c);
            d.drawPolyLine(this.mPoints, kiteclib_2.IRichGraphicsConst.LINE_DASH_1);
        }
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].drawHighLight(d, c, false);
    };
    GPolyLine.prototype.drawAlias = function (d, fore, back, la) {
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, la);
    };
    GPolyLine.prototype.drawAbstDevice = function (d, fore, back, la) {
        var poly = null;
        if (la != null) {
            var _pbuf = [];
            for (var i = 0; i < this.mPoints.length; i++) {
                var p = this.mPoints[i];
                _pbuf.push(new GPoint2Df_1.GPoint2Df(la.getGlobalX(p.x, p.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY), la.getGlobalY(p.x, p.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY)));
            }
            poly = _pbuf;
        }
        else {
            poly = this.mPoints;
        }
        d.setColor(fore);
        d.drawPolyLine(poly, null);
    };
    GPolyLine.prototype.flipx = function (x, ofsx) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].flipx(x, ofsx);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GPolyLine.prototype.flipy = function (y, ofsy) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].flipy(y, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    GPolyLine.prototype.rot = function (x, y, ofsx, ofsy) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].rot(x, y, ofsx, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    };
    return GPolyLine;
})(Geometry_1.Geometry);
exports.GPolyLine = GPolyLine;
//# sourceMappingURL=GPolyLine.js.map