import { IRichGraphics } from 'kiteclib';
import { KColor } from 'kiteclib';
import { KArea } from 'kiteclib';
import { K2DPathFigurePoint } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { Geometry } from './Geometry';
/**
 * @author kawae**/
export declare class GPoint2Df extends Geometry implements K2DPathFigurePoint {
    static GEOMNAME: string;
    /**
     * 座標値 **/
    x: number;
    y: number;
    /**
     * 汎用オブジェクト **/
    flagObj: Object;
    /**
     * 汎用フラグ **/
    wideUseFlag: number;
    /**
     * コンストラクタ
     * @param x
     * @param y
    **/
    constructor(x?: number, y?: number);
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigure#getType()
    **/
    getType(): number;
    /**
     * 座標地のセット**/
    setXY(x: number, y: number): void;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#getX()
    **/
    getX(): number;
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#getY()
    **/
    getY(): number;
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#setX(double)
    **/
    setX(x: number): void;
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#setY(double)
    **/
    setY(y: number): void;
    /**
     * 座標地のセット
     * @param p
    **/
    setPoint(p: GPoint2Df): void;
    /**
     * 最大・最小値の更新**/
    updateMinMax(area: KArea): void;
    /**
     * コピーインスタンスの取得**/
    copy(): Geometry;
    /**
     * コピーインスタンスの取得**/
    copyTo(g: Geometry): Geometry;
    getNearNode(x: number, y: number): GPoint2Df;
    getDistanceToPoint(x: number, y: number): number;
    offset(dx: number, dy: number): void;
    rotate(xc: number, yc: number, angl: number): void;
    drawHighLight(d: IRichGraphics, c: KColor, outline: boolean): void;
    static drawHighLight(d: IRichGraphics, c: KColor, x: number, y: number): void;
    /**
     * 幾何データの保存
     * @param savenode		保存対象ノード
     * @author kawae
     * @since 2003/01/01
    **/
    save(savenode: ObjectFolder): void;
    flipx(x: number, ofsx: number): void;
    flipy(y: number, ofsy: number): void;
    rot(x: number, y: number, ofsx: number, ofsy: number): void;
    /**
     * 描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    drawGeom(d: IRichGraphics): void;
}
