import { IRichGraphics } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { ILinkTarget } from '../ILinkTarget';
import { GeomParser } from '../GeomParser';
import { Geometry } from './Geometry';
/**
 * ダミーのIDのみを持つGeometry
 * 保存からの復帰等の場合、他のオブジェクトにリンク等していて
 * 全てのオブジェクトを復帰させないといけない場合にIDのみで管理
 * を行う。
 * @author kawae
 * @since 2004/11/02
**/
export declare class GDummyLinkGeom extends Geometry implements ILinkTarget {
    constructor(id: number);
    static readData(of: ObjectFolder, geom: Geometry, ps: GeomParser): void;
    drawGeom(d: IRichGraphics): void;
    getLinkDistance(x: number, y: number): number;
    getLinkPoint(px: number, py: number, rx: number, ry: number, linktype: number, resp: number[]): boolean;
    getNormal(x: number, y: number, resv: number[]): void;
}
