var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var kiteclib_1 = require('kiteclib');
var kiteclib_2 = require('kiteclib');
var kiteclib_3 = require('kiteclib');
var Geometry_1 = require('./Geometry');
var AreaControl_1 = require('../AreaControl');
var GPoint2Df_1 = require('./GPoint2Df');
//import { ToolPolygon } from '../util/ToolPolygon'
//module nethome.geom.primitive
var GCircle = (function (_super) {
    __extends(GCircle, _super);
    /**
     * コンストラクタ
    **/
    //constructor() {
    //}
    /**
     * コンストラクタ**/
    function GCircle(cx, cy, r, start, end) {
        if (cx === void 0) { cx = 0; }
        if (cy === void 0) { cy = 0; }
        if (r === void 0) { r = 0; }
        if (start === void 0) { start = 0; }
        if (end === void 0) { end = Math.PI * 2; }
        //thisconstructor();
        _super.call(this, GCircle.GEOMNAME);
        this._tmpP = new GPoint2Df_1.GPoint2Df();
        /**
         * 塗潰しモード
         **/
        this.mFill = false;
        this.mGeomColor = kiteclib_1.KColor.BLACK;
        this.mCp = new GPoint2Df_1.GPoint2Df(cx, cy);
        this._r = r;
        this._start = start;
        this._end = end;
        this.areaControl = new AreaControl_1.AreaControl();
        this.updateMaxPoints();
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    GCircle.prototype.getSnapNode = function (x1, y1, gx, gy, min, res, eps, limit) {
        return false;
    };
    GCircle.prototype.getCenter = function (p) {
        p.x = this.mCp.x;
        p.y = this.mCp.y;
    };
    GCircle.prototype.getSnapLoop = function (v) {
    };
    /**
     * TODO:実装**/
    GCircle.prototype.getNearNodeOnLine = function (p1, p2, eps) {
        return null;
    };
    GCircle.prototype.getNearLine = function (x, y, eps, pts) {
        return false;
    };
    GCircle.prototype.getRotbasePoint = function () {
        return this._maxPts[0];
    };
    GCircle.isParallel = function (g1, g2) {
        if (g1 == null || g2 == null)
            return false;
        if (!(g1 instanceof GCircle) || !(g2 instanceof GCircle))
            return false;
        var c1 = (g1);
        var c2 = (g2);
        if (Math.abs(c1.getR() - c2.getR()) < kiteclib_3.MathUtil.EPS && kiteclib_3.MathUtil.getLength2D(c1.getX(), c1.getY(), c2.getX(), c2.getY()) < kiteclib_3.MathUtil.EPS) {
            if (Math.abs(c1.getStart() - c2.getEnd()) < kiteclib_3.MathUtil.EPS) {
                if (!kiteclib_3.MathUtil.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getStart()))
                    return true;
            }
            else if (Math.abs(c1.getEnd() - c2.getStart()) < kiteclib_3.MathUtil.EPS) {
                if (!kiteclib_3.MathUtil.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getEnd()))
                    return true;
            }
        }
        return false;
    };
    GCircle.marge = function (g1, g2) {
        if (GCircle.isParallel(g1, g2)) {
            var c1 = (g1);
            var c2 = (g2);
            if (Math.abs(c1.getStart() - c2.getEnd()) < kiteclib_3.MathUtil.EPS) {
                if (!kiteclib_3.MathUtil.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getStart())) {
                    return new GCircle(c1.getX(), c1.getY(), c1.getR(), c2.getStart(), c1.getEnd());
                }
            }
            else if (Math.abs(c1.getEnd() - c2.getStart()) < kiteclib_3.MathUtil.EPS) {
                if (!kiteclib_3.MathUtil.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getEnd()))
                    return new GCircle(c1.getX(), c1.getY(), c1.getR(), c1.getStart(), c2.getEnd());
            }
        }
        return null;
    };
    GCircle.prototype.getStart = function () {
        return this._start;
    };
    GCircle.prototype.setStart = function (f) {
        this._start = f;
    };
    GCircle.prototype.getEnd = function () {
        return this._end;
    };
    GCircle.prototype.setEnd = function (f) {
        this._end = f;
    };
    GCircle.prototype.getR = function () {
        return this._r;
    };
    GCircle.prototype.setR = function (r) {
        this._r = r;
    };
    GCircle.prototype.setX = function (f) {
        this.mCp.x = f;
    };
    GCircle.prototype.setY = function (f) {
        this.mCp.y = f;
    };
    GCircle.prototype.getX = function () {
        return this.mCp.x;
    };
    GCircle.prototype.getY = function () {
        return this.mCp.y;
    };
    GCircle.prototype.copy = function () {
        return this.copyTo(new GCircle());
    };
    GCircle.prototype.copyTo = function (g) {
        if (g == null || !(g instanceof GCircle))
            return null;
        var gc = (g);
        _super.prototype.copyTo.call(this, gc);
        gc.mCp = new GPoint2Df_1.GPoint2Df(this.mCp.x, this.mCp.y);
        gc._r = this._r;
        gc._start = this._start;
        gc._end = this._end;
        gc.setFillMode(this.mFill);
        gc.setFillColor(this.mFillColor);
        gc.areaControl = new AreaControl_1.AreaControl();
        gc.updateMaxPoints();
        gc.area.maximize();
        gc.updateMinMax(gc.area);
        return gc;
    };
    GCircle.prototype.updateMinMax = function (area) {
        var s;
        var e;
        s = this._start;
        e = this._end;
        while (s > e)
            s = s - 360;
        if (s <= 0 && e >= 0)
            area.maxX = Math.max(this.mCp.x + this._r, area.maxX);
        if (s <= 90 && e >= 90)
            area.maxY = Math.max(this.mCp.y + this._r, area.maxY);
        if (s <= 180 && e >= 180)
            area.minX = Math.min(this.mCp.x - this._r, area.minX);
        if (s <= 270 && e >= 270)
            area.minY = Math.min(this.mCp.y - this._r, area.minY);
        if (this._start == this._end) {
            area.updateMinMax(this.mCp.x + this._r, this.mCp.y + this._r);
            area.updateMinMax(this.mCp.x - this._r, this.mCp.y - this._r);
        }
        else {
            var x1 = this.mCp.x + (this._r * Math.cos(this._start * Math.PI / 180));
            var y1 = this.mCp.y + (this._r * Math.sin(this._start * Math.PI / 180));
            var x2 = this.mCp.x + (this._r * Math.cos(this._end * Math.PI / 180));
            var y2 = this.mCp.y + (this._r * Math.sin(this._end * Math.PI / 180));
            area.updateMinMax(x1, y1);
            area.updateMinMax(x2, y2);
        }
    };
    GCircle.prototype.updateMaxPoints = function () {
        var s;
        var e;
        s = this._start;
        e = this._end;
        while (s > e)
            s = s - 360;
        this._maxPts = [];
        if (s < 0 && e > 0 || this._start == this._end)
            this._maxPts.push(new GPoint2Df_1.GPoint2Df(this.mCp.x + this._r, this.mCp.y));
        if (s < 90 && e > 90 || this._start == this._end)
            this._maxPts.push(new GPoint2Df_1.GPoint2Df(this.mCp.x, this.mCp.y + this._r));
        if (s < 180 && e > 180 || this._start == this._end)
            this._maxPts.push(new GPoint2Df_1.GPoint2Df(this.mCp.x - this._r, this.mCp.y));
        if (s < 270 && e > 270 || this._start == this._end)
            this._maxPts.push(new GPoint2Df_1.GPoint2Df(this.mCp.x, this.mCp.y - this._r));
        if (this._start != this._end) {
            var p1 = new GPoint2Df_1.GPoint2Df(this.mCp.x + (this._r * Math.cos(this._start * Math.PI / 180)), this.mCp.y + (this._r * Math.sin(this._start * Math.PI / 180)));
            var p2 = new GPoint2Df_1.GPoint2Df(this.mCp.x + (this._r * Math.cos(this._end * Math.PI / 180)), this.mCp.y + (this._r * Math.sin(this._end * Math.PI / 180)));
            this._maxPts.push(p1);
            this._maxPts.push(p2);
        }
        this.areaControl.getPoints().length = 0;
        for (var i = 0; i < this._maxPts.length; i++)
            this.areaControl.getPoints().push(this._maxPts[i]);
    };
    GCircle.prototype.getNearNode = function (x, y) {
        var min;
        var x1;
        var y1;
        this._tmpP.x = this.mCp.x + (this._r * Math.cos(this._start * Math.PI / 180));
        this._tmpP.y = this.mCp.y + (this._r * Math.sin(this._start * Math.PI / 180));
        min = kiteclib_3.MathUtil.getLength2D(x, y, this._tmpP.x, this._tmpP.y);
        x1 = this.mCp.x + (this._r * Math.cos(this._end * Math.PI / 180));
        y1 = this.mCp.y + (this._r * Math.sin(this._end * Math.PI / 180));
        if (min > kiteclib_3.MathUtil.getLength2D(x, y, x1, y1)) {
            this._tmpP.x = x1;
            this._tmpP.y = y1;
        }
        return this._tmpP;
    };
    GCircle.prototype.getDistanceToPoint = function (x, y) {
        var angl = (kiteclib_3.MathUtil.getAngle2D(this.mCp.x, this.mCp.y, x, y) * 180 / Math.PI);
        var s = this._start;
        var e = this._end;
        e -= s;
        angl -= s;
        s = 0;
        e = kiteclib_3.MathUtil.getAngl360(e);
        angl = kiteclib_3.MathUtil.getAngl360(angl);
        if ((angl > s && angl < e) || s == e) {
            return Math.abs(this._r - kiteclib_3.MathUtil.getLength2D(this.mCp.x, this.mCp.y, x, y));
        }
        var min;
        var x1;
        var y1;
        x1 = this.mCp.x + (this._r * Math.cos(this._start * Math.PI / 180));
        y1 = this.mCp.y + (this._r * Math.sin(this._start * Math.PI / 180));
        min = kiteclib_3.MathUtil.getLength2D(x, y, x1, y1);
        x1 = this.mCp.x + (this._r * Math.cos(this._end * Math.PI / 180));
        y1 = this.mCp.y + (this._r * Math.sin(this._end * Math.PI / 180));
        min = Math.min(min, kiteclib_3.MathUtil.getLength2D(x, y, x1, y1));
        return min;
    };
    GCircle.prototype.offset = function (x, y) {
        if (x == 0 && y == 0)
            return;
        this.mCp.x += x;
        this.mCp.y += y;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    };
    GCircle.prototype.rotate = function (xc, yc, angl) {
        if (angl == 0)
            return;
        this.mCp.rotate(xc, yc, angl);
        this._start += (angl * 180 / Math.PI);
        this._end += (angl * 180 / Math.PI);
        while (this._start >= 360)
            this._start -= 360;
        while (this._start < 0)
            this._start += 360;
        while (this._end >= 360)
            this._end -= 360;
        while (this._end < 0)
            this._end += 360;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    };
    GCircle.prototype.isInner = function (minx, miny, maxx, maxy) {
        for (var i = 0; i < this._maxPts.length; i++) {
            var p = this._maxPts[i];
            if (p.x < minx || p.x > maxx || p.y < miny || p.y > maxy)
                return false;
        }
        return true;
    };
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    for (var i: number = 0; i < this._maxPts.length; i++) {
    //        var p: GPoint2Df = (this._maxPts.elementAt(i)) as GPoint2Df;
    //        if (!ToolPolygon.isInnerPolygon(v, p.x, p.y)) return false;
    //    }
    //    return true;
    //}
    /**
     * データの保存
     * @param savenode
    **/
    GCircle.prototype.save = function (savenode) {
        if (savenode == null)
            return;
        _super.prototype.save.call(this, savenode);
        savenode.addNode("cx", this.mCp.x);
        savenode.addNode("cy", this.mCp.y);
        savenode.addNode("r", this._r);
        savenode.addNode("start", this._start);
        savenode.addNode("end", this._end);
        savenode.addNode("fill", this.mFill);
        if (this.mFillColor != null)
            savenode.addNode("fillc", this.mFillColor.getRed() + "," + this.mFillColor.getGreen() + "," + this.mFillColor.getBlue());
    };
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, this.mGeomColor, null);
    //}
    GCircle.prototype.drawGeom = function (d, fore, back) {
        if (back == null)
            back = this.mFillColor;
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, null);
    };
    GCircle.prototype.drawAlias = function (d, fore, back, la) {
        if (back == null)
            back = this.mFillColor;
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, la);
    };
    GCircle.prototype.drawAbstDevice = function (d, fore, back, la) {
        var x1 = this.mCp.x;
        var y1 = this.mCp.y;
        var s = this._start;
        var e = this._end;
        var r = this._r;
        if (la != null) {
            //if (false) {
            //    x1 = la.getGlobalX(this.mCp.x, this.mCp.y);
            //    y1 = la.getGlobalY(this.mCp.x, this.mCp.y);
            //}
            //else {
            x1 = la.getGlobalX(this.mCp.x, this.mCp.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            y1 = la.getGlobalY(this.mCp.x, this.mCp.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            //}
            s = (la.getGlobalAngl(this._start * Math.PI / 180) * 180 / Math.PI);
            e = (la.getGlobalAngl(this._end * Math.PI / 180) * 180 / Math.PI);
            r = la.getGlobalLength(this._r);
            while (s >= 360)
                s -= 360;
            while (s < 0)
                s += 360;
            while (e >= 360)
                e -= 360;
            while (e < 0)
                e += 360;
        }
        if (this.mFill && back != null) {
            d.setColor(back);
            d.drawFillCircle(x1, y1, r, s, e, null);
        }
        d.setColor(fore);
        d.drawCircle(x1, y1, r, s, e, null);
    };
    GCircle.prototype.drawHighLight = function (d, c, outline) {
        if (outline) {
            var f = this.mFill;
            this.mFill = false;
            this.drawAbstDevice(d, c, c, null);
            this.mFill = f;
        }
        for (var i = 0; i < this._maxPts.length; i++)
            this._maxPts[i].drawHighLight(d, c, false);
    };
    GCircle.prototype.getLocalMinMax = function (area) {
        var s;
        var s2;
        var e;
        s = s2 = (this._start * Math.PI / 180);
        e = (this._end * Math.PI / 180);
        var angl;
        if (s > e)
            angl = (Math.PI * 2 - (s - e));
        else
            angl = e - s;
        while (s2 >= Math.PI)
            s2 -= Math.PI * 2;
        var minx = Number.POSITIVE_INFINITY;
        var miny = Number.POSITIVE_INFINITY;
        var maxx = Number.NEGATIVE_INFINITY;
        var maxy = Number.NEGATIVE_INFINITY;
        if (Math.abs(s - e) < kiteclib_3.MathUtil.EPS) {
            minx = this.mCp.x - this._r;
            maxx = this.mCp.x + this._r;
            miny = this.mCp.y - this._r;
            maxy = this.mCp.y + this._r;
        }
        else {
            if (s <= 0 && s + angl >= 0)
                maxx = this.mCp.x + this._r;
            if (s <= Math.PI * 2 && s + angl >= Math.PI * 2)
                maxx = this.mCp.x + this._r;
            if (s <= (Math.PI / 2) && s + angl >= (Math.PI / 2))
                maxy = this.mCp.y + this._r;
            if (s <= (Math.PI / 2 + Math.PI * 2) && s + angl >= (Math.PI / 2 + Math.PI * 2))
                maxy = this.mCp.y + this._r;
            if (s <= Math.PI && s + angl >= Math.PI)
                minx = this.mCp.x - this._r;
            if (s <= Math.PI + Math.PI * 2 && s + angl >= Math.PI + Math.PI * 2)
                minx = this.mCp.x - this._r;
            if (s <= (Math.PI / 2) * 3 && s + angl >= (Math.PI / 2) * 3)
                miny = this.mCp.y - this._r;
            if (s <= (Math.PI / 2) * 3 + Math.PI * 2 && s + angl >= (Math.PI / 2) * 3 + Math.PI * 2)
                miny = this.mCp.y - this._r;
            minx = Math.min(minx, this.mCp.x + (this._r * Math.cos(s)));
            miny = Math.min(miny, this.mCp.y + (this._r * Math.sin(s)));
            maxx = Math.max(maxx, this.mCp.x + (this._r * Math.cos(e)));
            maxy = Math.max(maxy, this.mCp.y + (this._r * Math.sin(e)));
        }
        area.updateMinMax(minx, miny);
        area.updateMinMax(maxx, maxy);
    };
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
    **/
    GCircle.prototype.getNearControlPoint = function (x, y) {
        var min = Number.POSITIVE_INFINITY;
        var p = null;
        for (var i = 0; i < this._maxPts.length; i++) {
            var p1 = this._maxPts[i];
            var len = p1.getDistanceToPoint(x, y);
            if (len < min) {
                min = len;
                p = p1;
            }
        }
        return p;
    };
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
    **/
    GCircle.prototype.moveControlPoint = function (cp, x, y) {
        var r = kiteclib_3.MathUtil.getLength2D(x, y, this.mCp.x, this.mCp.y);
        this._r = r;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    };
    GCircle.prototype.flipx = function (x, ofsx) {
        this.mCp.flipx(x, ofsx);
        this._start = kiteclib_3.MathUtil.getAngl360((180 - this._start));
        this._end = kiteclib_3.MathUtil.getAngl360((180 - this._end));
        var tmp = this._start;
        this._start = this._end;
        this._end = tmp;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    };
    GCircle.prototype.flipy = function (y, ofsy) {
        this.mCp.flipy(y, ofsy);
        this._start = kiteclib_3.MathUtil.getAngl360((-this._start));
        this._end = kiteclib_3.MathUtil.getAngl360((-this._end));
        var tmp = this._start;
        this._start = this._end;
        this._end = tmp;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    };
    GCircle.prototype.rot = function (x, y, ofsx, ofsy) {
        this.mCp.rot(x, y, ofsx, ofsy);
        this._start = kiteclib_3.MathUtil.getAngl360(this._start + 90);
        this._end = kiteclib_3.MathUtil.getAngl360(this._end + 90);
        if (Math.abs(this._start - this._end) < kiteclib_3.MathUtil.EPS)
            this._start = this._end = 0;
        while (this._start >= 360)
            this._start -= 360;
        while (this._start < 0)
            this._start += 360;
        while (this._end >= 360)
            this._end -= 360;
        while (this._end < 0)
            this._end += 360;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    };
    GCircle.prototype.setFillMode = function (fill) {
        this.mFill = fill;
    };
    GCircle.prototype.isFillMode = function () {
        return this.mFill;
    };
    /**
     * @return Returns the mFillColor.**/
    GCircle.prototype.getFillColor = function () {
        return this.mFillColor;
    };
    /**
     * @param fillColor The mFillColor to set.**/
    GCircle.prototype.setFillColor = function (fillColor) {
        this.mFillColor = fillColor;
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#getCX()
    **/
    GCircle.prototype.getCX = function () {
        return this.mCp.getX();
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#getCY()
    **/
    GCircle.prototype.getCY = function () {
        return this.mCp.getY();
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#getRadius()
    **/
    GCircle.prototype.getRadius = function () {
        return this._r;
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#isCw()
    **/
    GCircle.prototype.isCw = function () {
        return false;
    };
    /**
     * @param cw
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setCw(boolean)
    **/
    GCircle.prototype.setCw = function (cw) {
    };
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setCX(double)
    **/
    GCircle.prototype.setCX = function (x) {
        this.mCp.setX(x);
    };
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setCY(double)
    **/
    GCircle.prototype.setCY = function (y) {
        this.mCp.setY(y);
    };
    /**
     * @param radius
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setRadius(double)
    **/
    GCircle.prototype.setRadius = function (radius) {
        this._r = radius;
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getX1()
    **/
    GCircle.prototype.getX1 = function () {
        return this.mCp.x + this._r * Math.cos(this._start * kiteclib_3.MathUtil.D2R);
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getX2()
    **/
    GCircle.prototype.getX2 = function () {
        return this.mCp.x + this._r * Math.cos(this._end * kiteclib_3.MathUtil.D2R);
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getY1()
    **/
    GCircle.prototype.getY1 = function () {
        return this.mCp.y + this._r * Math.sin(this._start * kiteclib_3.MathUtil.D2R);
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getY2()
    **/
    GCircle.prototype.getY2 = function () {
        return this.mCp.y + this._r * Math.sin(this._end * kiteclib_3.MathUtil.D2R);
    };
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX1(double)
    **/
    GCircle.prototype.setX1 = function (x) {
    };
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX2(double)
    **/
    GCircle.prototype.setX2 = function (x) {
    };
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY1(double)
    **/
    GCircle.prototype.setY1 = function (y) {
    };
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY2(double)
    **/
    GCircle.prototype.setY2 = function (y) {
    };
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigure#getType()
    **/
    GCircle.prototype.getType = function () {
        return kiteclib_2.K2DFigureType.ARC_CCW;
    };
    GCircle.GEOMNAME = "CIRCLE";
    return GCircle;
})(Geometry_1.Geometry);
exports.GCircle = GCircle;
//# sourceMappingURL=GCircle.js.map