var kiteclib_1 = require('kiteclib');
var GLine_1 = require('./primitive/GLine');
//module nethome.geom
/**
 * <p>タイトル: </p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2001</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
**/
var HatchPattern = (function () {
    /**
     * コンストラクタ
     * @param fitpattern	フィットするパターン
     * @param cycx	x方向の周期
     * @param cycy	y方向の周期
    **/
    function HatchPattern(group) {
        /**
         * 対象ポリゴンに対する内向きオフセット **/
        this.mOffsetToInside = 0;
        /**
         * ポリゴン領域を追加するかのフラグ　**/
        this.mFrameLine = false;
        /**
         * ラインタイプ **/
        this.mLtype = null;
        this.mGroupName = group;
        this.mMinX = this.mMinY = Number.MAX_VALUE;
        this.mMaxX = this.mMaxY = -Number.MAX_VALUE;
        this.mInfinityX = [];
        this.mInfinityY = [];
        this.mLines = [];
        this.mOffsetToInside = 0;
        this.mFrameLine = false;
        this.mSmooth = false;
        this.mDisplaySize = -1;
        this.mSubTypes = [];
    }
    /**
     * サブタイプの取得**/
    HatchPattern.prototype.getSubTypes = function () {
        return this.mSubTypes;
    };
    HatchPattern.prototype.addSubType = function (x, y, w, h) {
        var st = [x, y, w, h];
        this.mSubTypes.push(st);
    };
    //addSubType2(cx: number, cy: number, w: number, h: number): void {
    //    var st: number[] = [cx, cy, w, h];
    //    this.mSubTypes.push(st);
    //}
    HatchPattern.prototype.getSubtype = function (w, h) {
        for (var i = 0; i < this.mSubTypes.length; i++) {
            var st = this.mSubTypes[i];
            if (Math.abs(st[0] - w) < kiteclib_1.MathUtil.EPS && Math.abs(st[1] - h) < kiteclib_1.MathUtil.EPS)
                return st;
        }
        return null;
    };
    //getSubtype2(w: number, h: number): number[] {
    //    for (var i: number = 0; i < this.mSubTypes.size(); i++) {
    //        var st: number[] = (((this.mSubTypes.elementAt(i)) as Object) as number[]);
    //        if (Math.abs(st[0] - w) < nethome.geom.util.ToolMath.EPS && Math.abs(st[1] - h) < nethome.geom.util.ToolMath.EPS) return st;
    //    }
    //    return null;
    //}
    HatchPattern.prototype.setGroup = function (s) {
        this.mGroupName = s;
    };
    HatchPattern.prototype.getGroupName = function () {
        return this.mGroupName;
    };
    HatchPattern.prototype.setName = function (s) {
        this.mName = s;
    };
    HatchPattern.prototype.getName = function () {
        return this.mName;
    };
    HatchPattern.prototype.setArea = function (f) {
        this.mDisplaySize = f;
    };
    HatchPattern.prototype.getArea = function () {
        return this.mDisplaySize;
    };
    /**
     * フィットパターンの設定**/
    HatchPattern.prototype.setFitPattern = function (fitpattern) {
        this.mFitPattern = fitpattern;
    };
    /**
     * サイクルの指定**/
    HatchPattern.prototype.setCycle = function (cycx, cycy) {
        this.mCycleX = cycx;
        this.mCycleY = cycy;
    };
    /**
     * スムースモードの設定**/
    HatchPattern.prototype.setSmooth = function (b) {
        this.mSmooth = b;
    };
    /**
     * スムースモードの取得**/
    HatchPattern.prototype.getSmooth = function () {
        return this.mSmooth;
    };
    /**
     * 最大・最小領域の設定**/
    HatchPattern.prototype.setMinMax = function (xmin, ymin, xmax, ymax) {
        this.mMinX = xmin;
        this.mMaxX = xmax;
        this.mMinY = ymin;
        this.mMaxY = ymax;
    };
    /**
     * ｘ方向無限ライン追加**/
    HatchPattern.prototype.addInfinityX = function (x) {
        this.mInfinityX.push(x);
    };
    /**
     * ｙ方向無限ライン追加**/
    HatchPattern.prototype.addInfinityY = function (y) {
        this.mInfinityY.push(y);
    };
    /**
     * 線追加**/
    HatchPattern.prototype.addLine = function (x1, y1, x2, y2) {
        this.mLines.push(new GLine_1.GLine(x1, y1, x2, y2));
    };
    HatchPattern.prototype.addMinMaxLine = function () {
        this.mLines.push(new GLine_1.GLine(this.mMinX, this.mMinY, this.mMaxX, this.mMinY));
        this.mLines.push(new GLine_1.GLine(this.mMinX, this.mMinY, this.mMinX, this.mMaxY));
        this.mLines.push(new GLine_1.GLine(this.mMinX, this.mMaxY, this.mMaxX, this.mMaxY));
        this.mLines.push(new GLine_1.GLine(this.mMaxX, this.mMinY, this.mMaxX, this.mMaxY));
    };
    /**
     * 最大・最小にフィットパターン **/
    HatchPattern.MINMAXFIT = 0;
    /**
     * 指定された間隔でフィットパターン **/
    HatchPattern.INTERVALFIT = 1;
    /**
     * 対象の部屋に対してサイズ依存であるものパターン **/
    HatchPattern.SIZEDEPEND = 2;
    /**
     * サブタイプリストから自動的に適合するものを選択する。 **/
    HatchPattern.SUBTYPESIZE = 3;
    return HatchPattern;
})();
exports.HatchPattern = HatchPattern;
//# sourceMappingURL=HatchPattern.js.map