var kiteclib_1 = require('kiteclib');
var ObjectFolderHistoryDataConverter_1 = require('./ObjectFolderHistoryDataConverter');
//module nethome.doc
var ObjectFolderProjectHistoryManager = (function () {
    /**
     * コンストラクタ**/
    function ObjectFolderProjectHistoryManager(histnum, factory) {
        this.mHistory = new kiteclib_1.History(histnum, new ObjectFolderHistoryDataConverter_1.ObjectFolderHistoryDataConverter(new ObjectFolderProjectProvider(factory), factory));
    }
    ObjectFolderProjectHistoryManager.prototype.setProject = function (project) {
        this.mProject = project;
    };
    ObjectFolderProjectHistoryManager.prototype.flushHistory = function () {
        this.mHistory.flushHistory();
    };
    ObjectFolderProjectHistoryManager.prototype.setHistoryObject = function (o) {
        var hisObj = this.mHistory.getConverter().readHistory(o);
        if (hisObj == null)
            return;
        else {
            this.copyProject(hisObj);
        }
    };
    ObjectFolderProjectHistoryManager.prototype.getLastHistory = function () {
        return this.mHistory.getLastHistory();
    };
    ObjectFolderProjectHistoryManager.prototype.getCurrentHistory = function () {
        return this.mHistory.getCurrentHistory();
    };
    ObjectFolderProjectHistoryManager.prototype.undo = function () {
        var flag = false;
        var hisObj = this.mHistory.undo();
        if (hisObj == null)
            flag = false;
        else {
            this.copyProject(hisObj);
            flag = true;
        }
        if (flag)
            this.mProject.setSaved(false);
        return flag;
    };
    ObjectFolderProjectHistoryManager.prototype.redo = function () {
        var flag = false;
        var hisObj = this.mHistory.redo();
        if (hisObj == null)
            flag = false;
        else {
            this.copyProject(hisObj);
            flag = true;
        }
        if (flag)
            this.mProject.setSaved(false);
        return flag;
    };
    ObjectFolderProjectHistoryManager.prototype.copyProject = function (src) {
        var _this = this;
        var currentIndex = src.getLayers().indexOf(src.getCurrentLayer());
        this.mProject.getLayers().length = 0;
        src.getLayers().forEach(function (l) {
            return _this.mProject.getLayers().push(l);
        });
        this.mProject.setCurrentLayer(currentIndex);
    };
    ObjectFolderProjectHistoryManager.prototype.addHistory = function () {
        this.mProject.getLayers().forEach(function (l) {
            l.renumberID();
        });
        this.mHistory.addHistory(this.mProject);
        this.mProject.setSaved(false);
    };
    ObjectFolderProjectHistoryManager.prototype.hasUndo = function () {
        return this.mHistory.hasUndo();
    };
    ObjectFolderProjectHistoryManager.prototype.hasRedo = function () {
        return this.mHistory.hasRedo();
    };
    ObjectFolderProjectHistoryManager.prototype.setMaxHistory = function (num) {
        this.mHistory.setMaxHistory(num);
    };
    return ObjectFolderProjectHistoryManager;
})();
exports.ObjectFolderProjectHistoryManager = ObjectFolderProjectHistoryManager;
var ObjectFolderProjectProvider = (function () {
    function ObjectFolderProjectProvider(factory) {
        this.factory = factory;
    }
    ObjectFolderProjectProvider.prototype.getProject = function () {
        return this.factory.createNewProject();
    };
    return ObjectFolderProjectProvider;
})();
var ObjectFolderProjectHistoryManager_ProjectProvider = (function () {
    function ObjectFolderProjectHistoryManager_ProjectProvider(factory) {
        this.factory = factory;
    }
    ObjectFolderProjectHistoryManager_ProjectProvider.prototype.getProject = function () {
        return this.factory.createNewProject();
    };
    return ObjectFolderProjectHistoryManager_ProjectProvider;
})();
//# sourceMappingURL=ObjectFolderProjectHistoryManager.js.map