var DocumentEvent_1 = require('./DocumentEvent');
//module nethome.doc
/**
 * ライブラリ用のドキュメントなど、各種ドキュメントを管理する
 * ドキュメント管理クラス。
 * @since 　2003/03/12
 * @author　Kawae
 * @version 2003/03/12
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
**/
var Document = (function () {
    /**
     * すべてのドキュメントを空として、新たな Document を構築する。
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    function Document() {
        this.mProject = null;
        this.mProjects = [];
        this.mListeners = [];
    }
    /**
     * この Document が管理する NetHomeドキュメントを返す。
     * @return NetHomeドキュメント
     * @see #setNh3Doc(DocumentNh3)
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    Document.prototype.getProject = function () {
        return this.mProject;
    };
    /**
     * 指定されたプロジェクトを、この Document が管理する
     * NetHome ドキュメントとして設定する。
     * @param prj	NetHome ドキュメント
     * @see #getProject()
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    Document.prototype.setProject = function (prj) {
        if (this.mProjects.indexOf(prj) < 0)
            this.addProject(prj);
        this.mProject = prj;
    };
    /**
     * 指定されたプロジェクトを、この Document が管理するプロジェクトに追加する。
     * @param prj
    **/
    Document.prototype.addProject = function (prj) {
        this.mProjects.push(prj);
        prj.addProjectListener(this);
    };
    /**
     * 指定されたプロジェクトを、この Document が管理するプロジェクトから削除する。
     * @param prj
    **/
    Document.prototype.removeProject = function (prj) {
        var i = this.mProjects.indexOf(prj);
        if (i >= 0)
            this.mProjects.splice(i, 1);
    };
    /**
     * この Document が管理するプロジェクトのリストを返す。**/
    Document.prototype.getProjects = function () {
        return this.mProjects.slice();
    };
    /**
     * この Document が管理するすべてのドキュメントをリフレッシュする。
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    Document.prototype.refreshDocument = function () {
        this.mProjects.forEach(function (prj) {
            return prj.documentRefresh();
        });
    };
    Document.prototype.addDocumentListener = function (l) {
        if (l == null)
            return;
        if (this.mListeners.indexOf(l) >= 0)
            return;
        this.mListeners.push(l);
    };
    Document.prototype.removeDocumentListener = function (l) {
        var i = this.mListeners.indexOf(l);
        if (i >= 0)
            this.mListeners.splice(i, 1);
    };
    Document.prototype.fireDocumentChanged = function (source) {
        var e = new DocumentEvent_1.DocumentEvent(source, this);
        var size = this.mListeners.length;
        for (var i = size - 1; i >= 0; i--) {
            this.mListeners[i].documentChanged(e);
        }
    };
    Document.prototype.projectChanged = function (e) {
        this.fireDocumentChanged(e.source);
    };
    return Document;
})();
exports.Document = Document;
//# sourceMappingURL=Document.js.map